/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.controlflow;

import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiConditionalExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.util.IncorrectOperationException;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.PsiReplacementUtil;
import com.siyeh.ig.psiutils.BoolUtils;
import org.jetbrains.annotations.NotNull;

public class ConstantConditionalExpressionInspection
extends BaseInspection {
    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("constant.conditional.expression.display.name", new Object[0]);
        if (string == null) {
            ConstantConditionalExpressionInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    public boolean isEnabledByDefault() {
        return true;
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos2) {
        PsiConditionalExpression expression2 = (PsiConditionalExpression)infos2[0];
        String string = InspectionGadgetsBundle.message("constant.conditional.expression.problem.descriptor", ConstantConditionalExpressionInspection.calculateReplacementExpression(expression2));
        if (string == null) {
            ConstantConditionalExpressionInspection.$$$reportNull$$$0(1);
        }
        return string;
    }

    static String calculateReplacementExpression(PsiConditionalExpression exp) {
        PsiExpression thenExpression = exp.getThenExpression();
        PsiExpression elseExpression = exp.getElseExpression();
        PsiExpression condition = exp.getCondition();
        assert (thenExpression != null);
        assert (elseExpression != null);
        if (BoolUtils.isTrue(condition)) {
            return thenExpression.getText();
        }
        return elseExpression.getText();
    }

    @Override
    public InspectionGadgetsFix buildFix(Object ... infos2) {
        return new ConstantConditionalFix();
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new ConstantConditionalExpressionVisitor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/siyeh/ig/controlflow/ConstantConditionalExpressionInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "buildErrorString";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    private static class ConstantConditionalExpressionVisitor
    extends BaseInspectionVisitor {
        private ConstantConditionalExpressionVisitor() {
        }

        @Override
        public void visitConditionalExpression(PsiConditionalExpression expression2) {
            super.visitConditionalExpression(expression2);
            PsiExpression condition = expression2.getCondition();
            PsiExpression thenExpression = expression2.getThenExpression();
            if (thenExpression == null) {
                return;
            }
            PsiExpression elseExpression = expression2.getElseExpression();
            if (elseExpression == null) {
                return;
            }
            if (BoolUtils.isFalse(condition) || BoolUtils.isTrue(condition)) {
                this.registerError((PsiElement)expression2, expression2);
            }
        }
    }

    private static class ConstantConditionalFix
    extends InspectionGadgetsFix {
        private ConstantConditionalFix() {
        }

        @Override
        @NotNull
        public String getFamilyName() {
            String string = InspectionGadgetsBundle.message("constant.conditional.expression.simplify.quickfix", new Object[0]);
            if (string == null) {
                ConstantConditionalFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        @Override
        public void doFix(Project project, ProblemDescriptor descriptor2) throws IncorrectOperationException {
            PsiConditionalExpression expression2 = (PsiConditionalExpression)descriptor2.getPsiElement();
            String newExpression = ConstantConditionalExpressionInspection.calculateReplacementExpression(expression2);
            PsiReplacementUtil.replaceExpression(expression2, newExpression);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/controlflow/ConstantConditionalExpressionInspection$ConstantConditionalFix", "getFamilyName"));
        }
    }
}

