/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.controlflow;

import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiBlockStatement;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiIfStatement;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.PsiReplacementUtil;
import com.siyeh.ig.psiutils.BoolUtils;
import com.siyeh.ig.psiutils.DeclarationSearchUtils;
import org.jetbrains.annotations.NotNull;

public class ConstantIfStatementInspection
extends BaseInspection {
    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("constant.if.statement.display.name", new Object[0]);
        if (string == null) {
            ConstantIfStatementInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    public boolean isEnabledByDefault() {
        return true;
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos2) {
        String string = InspectionGadgetsBundle.message("constant.if.statement.problem.descriptor", new Object[0]);
        if (string == null) {
            ConstantIfStatementInspection.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new ConstantIfStatementVisitor();
    }

    @Override
    public InspectionGadgetsFix buildFix(Object ... infos2) {
        return new ConstantIfStatementFix();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/siyeh/ig/controlflow/ConstantIfStatementInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "buildErrorString";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    private static class ConstantIfStatementVisitor
    extends BaseInspectionVisitor {
        private ConstantIfStatementVisitor() {
        }

        @Override
        public void visitIfStatement(PsiIfStatement statement2) {
            super.visitIfStatement(statement2);
            PsiExpression condition = statement2.getCondition();
            if (condition == null) {
                return;
            }
            PsiStatement thenBranch = statement2.getThenBranch();
            if (thenBranch == null) {
                return;
            }
            if (BoolUtils.isTrue(condition) || BoolUtils.isFalse(condition)) {
                this.registerStatementError(statement2, new Object[0]);
            }
        }
    }

    private static class ConstantIfStatementFix
    extends InspectionGadgetsFix {
        private ConstantIfStatementFix() {
        }

        @Override
        @NotNull
        public String getFamilyName() {
            String string = InspectionGadgetsBundle.message("constant.conditional.expression.simplify.quickfix", new Object[0]);
            if (string == null) {
                ConstantIfStatementFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        @Override
        public void doFix(Project project, ProblemDescriptor descriptor2) throws IncorrectOperationException {
            PsiElement ifKeyword = descriptor2.getPsiElement();
            PsiIfStatement statement2 = (PsiIfStatement)ifKeyword.getParent();
            assert (statement2 != null);
            PsiStatement thenBranch = statement2.getThenBranch();
            PsiStatement elseBranch = statement2.getElseBranch();
            PsiExpression condition = statement2.getCondition();
            if (BoolUtils.isFalse(condition)) {
                if (elseBranch != null) {
                    ConstantIfStatementFix.replaceStatementWithUnwrapping(elseBranch, statement2);
                } else {
                    ConstantIfStatementFix.deleteElement(statement2);
                }
            } else {
                ConstantIfStatementFix.replaceStatementWithUnwrapping(thenBranch, statement2);
            }
        }

        private static void replaceStatementWithUnwrapping(PsiStatement branch, PsiIfStatement statement2) throws IncorrectOperationException {
            if (branch instanceof PsiBlockStatement && !(statement2.getParent() instanceof PsiIfStatement)) {
                PsiCodeBlock parentBlock = PsiTreeUtil.getParentOfType((PsiElement)branch, PsiCodeBlock.class);
                if (parentBlock == null) {
                    String elseText = branch.getText();
                    PsiReplacementUtil.replaceStatement(statement2, elseText);
                    return;
                }
                PsiCodeBlock block = ((PsiBlockStatement)branch).getCodeBlock();
                boolean hasConflicts = DeclarationSearchUtils.containsConflictingDeclarations(block, parentBlock);
                if (hasConflicts) {
                    String elseText = branch.getText();
                    PsiReplacementUtil.replaceStatement(statement2, elseText);
                } else {
                    PsiElement containingElement = statement2.getParent();
                    PsiStatement[] statements = block.getStatements();
                    if (statements.length > 0) {
                        assert (containingElement != null);
                        PsiJavaToken lBrace = block.getLBrace();
                        PsiJavaToken rBrace = block.getRBrace();
                        PsiElement added = null;
                        if (lBrace != null && rBrace != null) {
                            PsiElement firstNonBrace = lBrace.getNextSibling();
                            PsiElement lastNonBrace = rBrace.getPrevSibling();
                            if (firstNonBrace != null && lastNonBrace != null) {
                                added = containingElement.addRangeBefore(firstNonBrace, lastNonBrace, statement2);
                            }
                        }
                        if (added == null) {
                            added = containingElement.addRangeBefore(statements[0], statements[statements.length - 1], statement2);
                        }
                        Project project = statement2.getProject();
                        CodeStyleManager codeStyleManager = CodeStyleManager.getInstance(project);
                        codeStyleManager.reformat(added);
                    }
                    statement2.delete();
                }
            } else {
                String elseText = branch.getText();
                PsiReplacementUtil.replaceStatement(statement2, elseText);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/controlflow/ConstantIfStatementInspection$ConstantIfStatementFix", "getFamilyName"));
        }
    }
}

