/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.controlflow;

import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiPolyadicExpression;
import com.intellij.psi.PsiPrefixExpression;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.PsiReplacementUtil;
import com.siyeh.ig.psiutils.BoolUtils;
import com.siyeh.ig.psiutils.ParenthesesUtils;
import com.siyeh.ig.psiutils.TypeUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DoubleNegationInspection
extends BaseInspection {
    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("double.negation.display.name", new Object[0]);
        if (string == null) {
            DoubleNegationInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos2) {
        String string = InspectionGadgetsBundle.message("double.negation.problem.descriptor", new Object[0]);
        if (string == null) {
            DoubleNegationInspection.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Override
    public boolean isEnabledByDefault() {
        return true;
    }

    @Override
    @Nullable
    protected InspectionGadgetsFix buildFix(Object ... infos2) {
        return new DoubleNegationFix();
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new DoubleNegationVisitor();
    }

    public static boolean isNegation(@Nullable PsiExpression expression2) {
        if ((expression2 = ParenthesesUtils.stripParentheses(expression2)) instanceof PsiPrefixExpression) {
            return DoubleNegationInspection.isUnaryNegation((PsiPrefixExpression)expression2);
        }
        if (expression2 instanceof PsiPolyadicExpression) {
            return DoubleNegationInspection.isBinaryNegation((PsiPolyadicExpression)expression2);
        }
        return false;
    }

    static boolean isUnaryNegation(PsiPrefixExpression expression2) {
        return JavaTokenType.EXCL.equals(expression2.getOperationTokenType());
    }

    static boolean isBinaryNegation(PsiPolyadicExpression expression2) {
        for (PsiExpression operand : expression2.getOperands()) {
            if (!TypeUtils.hasFloatingPointType(operand)) continue;
            return false;
        }
        return JavaTokenType.NE.equals(expression2.getOperationTokenType());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/siyeh/ig/controlflow/DoubleNegationInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "buildErrorString";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    private static class DoubleNegationVisitor
    extends BaseInspectionVisitor {
        private DoubleNegationVisitor() {
        }

        @Override
        public void visitPrefixExpression(PsiPrefixExpression expression2) {
            super.visitPrefixExpression(expression2);
            if (!DoubleNegationInspection.isUnaryNegation(expression2)) {
                return;
            }
            PsiExpression operand = expression2.getOperand();
            if (!DoubleNegationInspection.isNegation(operand)) {
                return;
            }
            this.registerError((PsiElement)expression2, new Object[0]);
        }

        @Override
        public void visitPolyadicExpression(PsiPolyadicExpression expression2) {
            super.visitPolyadicExpression(expression2);
            if (!DoubleNegationInspection.isBinaryNegation(expression2)) {
                return;
            }
            PsiExpression[] operands = expression2.getOperands();
            if (operands.length == 2) {
                int notNegatedCount = 0;
                for (PsiExpression operand : operands) {
                    if (DoubleNegationInspection.isNegation(operand)) continue;
                    ++notNegatedCount;
                }
                if (notNegatedCount > 1) {
                    return;
                }
            }
            this.registerError((PsiElement)expression2, new Object[0]);
        }
    }

    private static class DoubleNegationFix
    extends InspectionGadgetsFix {
        private DoubleNegationFix() {
        }

        @Override
        @NotNull
        public String getFamilyName() {
            String string = InspectionGadgetsBundle.message("double.negation.quickfix", new Object[0]);
            if (string == null) {
                DoubleNegationFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        @Override
        protected void doFix(Project project, ProblemDescriptor descriptor2) {
            PsiElement expression2 = descriptor2.getPsiElement();
            if (expression2 instanceof PsiPrefixExpression) {
                PsiPrefixExpression prefixExpression = (PsiPrefixExpression)expression2;
                PsiExpression operand = ParenthesesUtils.stripParentheses(prefixExpression.getOperand());
                PsiReplacementUtil.replaceExpression(prefixExpression, BoolUtils.getNegatedExpressionText(operand));
            } else if (expression2 instanceof PsiPolyadicExpression) {
                PsiPolyadicExpression polyadicExpression = (PsiPolyadicExpression)expression2;
                PsiExpression[] operands = polyadicExpression.getOperands();
                int length = operands.length;
                if (length == 2) {
                    PsiExpression firstOperand = operands[0];
                    PsiExpression secondOperand = operands[1];
                    if (DoubleNegationInspection.isNegation(firstOperand)) {
                        PsiReplacementUtil.replaceExpression(polyadicExpression, BoolUtils.getNegatedExpressionText(firstOperand) + "==" + secondOperand.getText());
                    } else {
                        PsiReplacementUtil.replaceExpression(polyadicExpression, firstOperand.getText() + "==" + BoolUtils.getNegatedExpressionText(secondOperand));
                    }
                } else {
                    StringBuilder newExpressionText = new StringBuilder();
                    for (int i = 0; i < length; ++i) {
                        if (i > 0) {
                            if (length % 2 != 1 && i == length - 1) {
                                newExpressionText.append("!=");
                            } else {
                                newExpressionText.append("==");
                            }
                        }
                        newExpressionText.append(operands[i].getText());
                    }
                    PsiReplacementUtil.replaceExpression(polyadicExpression, newExpressionText.toString());
                }
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/controlflow/DoubleNegationInspection$DoubleNegationFix", "getFamilyName"));
        }
    }
}

