/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.controlflow;

import com.intellij.codeInspection.CleanupLocalInspectionTool;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiConditionalExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiType;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.PsiReplacementUtil;
import com.siyeh.ig.psiutils.BoolUtils;
import com.siyeh.ig.psiutils.EquivalenceChecker;
import com.siyeh.ig.psiutils.ParenthesesUtils;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class SimplifiableConditionalExpressionInspection
extends BaseInspection
implements CleanupLocalInspectionTool {
    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("simplifiable.conditional.expression.display.name", new Object[0]);
        if (string == null) {
            SimplifiableConditionalExpressionInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    public boolean isEnabledByDefault() {
        return true;
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos2) {
        PsiConditionalExpression expression2 = (PsiConditionalExpression)infos2[0];
        String string = InspectionGadgetsBundle.message("simplifiable.conditional.expression.problem.descriptor", SimplifiableConditionalExpressionInspection.calculateReplacementExpression(expression2));
        if (string == null) {
            SimplifiableConditionalExpressionInspection.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Override
    public InspectionGadgetsFix buildFix(Object ... infos2) {
        return new SimplifiableConditionalFix();
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new SimplifiableConditionalExpressionVisitor();
    }

    @NonNls
    static String calculateReplacementExpression(PsiConditionalExpression expression2) {
        PsiExpression thenExpression = expression2.getThenExpression();
        PsiExpression elseExpression = expression2.getElseExpression();
        PsiExpression condition = expression2.getCondition();
        assert (thenExpression != null);
        assert (elseExpression != null);
        if (EquivalenceChecker.getCanonicalPsiEquivalence().expressionsAreEquivalent(BoolUtils.getNegated(thenExpression), elseExpression)) {
            return ParenthesesUtils.getText(condition, 9) + " != " + BoolUtils.getNegatedExpressionText(thenExpression, 9);
        }
        if (EquivalenceChecker.getCanonicalPsiEquivalence().expressionsAreEquivalent(thenExpression, BoolUtils.getNegated(elseExpression))) {
            return ParenthesesUtils.getText(condition, 9) + " == " + ParenthesesUtils.getText(thenExpression, 9);
        }
        if (BoolUtils.isTrue(thenExpression)) {
            String elseExpressionText = ParenthesesUtils.getText(elseExpression, 14);
            return ParenthesesUtils.getText(condition, 14) + " || " + elseExpressionText;
        }
        if (BoolUtils.isFalse(thenExpression)) {
            String elseExpressionText = ParenthesesUtils.getText(elseExpression, 13);
            return BoolUtils.getNegatedExpressionText(condition, 13) + " && " + elseExpressionText;
        }
        if (BoolUtils.isFalse(elseExpression)) {
            String thenExpressionText = ParenthesesUtils.getText(thenExpression, 13);
            return ParenthesesUtils.getText(condition, 13) + " && " + thenExpressionText;
        }
        String thenExpressionText = ParenthesesUtils.getText(thenExpression, 14);
        return BoolUtils.getNegatedExpressionText(condition, 14) + " || " + thenExpressionText;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/siyeh/ig/controlflow/SimplifiableConditionalExpressionInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "buildErrorString";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    private static class SimplifiableConditionalExpressionVisitor
    extends BaseInspectionVisitor {
        private SimplifiableConditionalExpressionVisitor() {
        }

        @Override
        public void visitConditionalExpression(PsiConditionalExpression expression2) {
            boolean elseConstant;
            super.visitConditionalExpression(expression2);
            PsiExpression thenExpression = expression2.getThenExpression();
            if (thenExpression == null) {
                return;
            }
            PsiExpression elseExpression = expression2.getElseExpression();
            if (elseExpression == null) {
                return;
            }
            PsiType thenType = thenExpression.getType();
            if (!PsiType.BOOLEAN.equals(thenType)) {
                return;
            }
            PsiType elseType = elseExpression.getType();
            if (!PsiType.BOOLEAN.equals(elseType)) {
                return;
            }
            boolean thenConstant = BoolUtils.isFalse(thenExpression) || BoolUtils.isTrue(thenExpression);
            boolean bl = elseConstant = BoolUtils.isFalse(elseExpression) || BoolUtils.isTrue(elseExpression);
            if (thenConstant == elseConstant) {
                if (EquivalenceChecker.getCanonicalPsiEquivalence().expressionsAreEquivalent(BoolUtils.getNegated(thenExpression), elseExpression) || EquivalenceChecker.getCanonicalPsiEquivalence().expressionsAreEquivalent(thenExpression, BoolUtils.getNegated(elseExpression))) {
                    this.registerError((PsiElement)expression2, expression2);
                }
                return;
            }
            this.registerError((PsiElement)expression2, expression2);
        }
    }

    private static class SimplifiableConditionalFix
    extends InspectionGadgetsFix {
        private SimplifiableConditionalFix() {
        }

        @Override
        @NotNull
        public String getFamilyName() {
            String string = InspectionGadgetsBundle.message("constant.conditional.expression.simplify.quickfix", new Object[0]);
            if (string == null) {
                SimplifiableConditionalFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        @Override
        public void doFix(Project project, ProblemDescriptor descriptor2) {
            PsiConditionalExpression expression2 = (PsiConditionalExpression)descriptor2.getPsiElement();
            String newExpression = SimplifiableConditionalExpressionInspection.calculateReplacementExpression(expression2);
            PsiReplacementUtil.replaceExpression(expression2, newExpression);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/controlflow/SimplifiableConditionalExpressionInspection$SimplifiableConditionalFix", "getFamilyName"));
        }
    }
}

