/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.dataflow;

import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiParenthesizedExpression;
import com.intellij.psi.PsiPrefixExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

class BooleanVariableAlwaysNegatedInspectionBase
extends BaseInspection {
    BooleanVariableAlwaysNegatedInspectionBase() {
    }

    @Override
    @Nls
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("boolean.variable.always.inverted.display.name", new Object[0]);
        if (string == null) {
            BooleanVariableAlwaysNegatedInspectionBase.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos2) {
        PsiVariable variable2 = (PsiVariable)infos2[0];
        if (variable2 instanceof PsiField) {
            String string = InspectionGadgetsBundle.message("boolean.field.always.inverted.problem.descriptor", new Object[0]);
            if (string == null) {
                BooleanVariableAlwaysNegatedInspectionBase.$$$reportNull$$$0(1);
            }
            return string;
        }
        String string = InspectionGadgetsBundle.message("boolean.variable.always.inverted.problem.descriptor", new Object[0]);
        if (string == null) {
            BooleanVariableAlwaysNegatedInspectionBase.$$$reportNull$$$0(2);
        }
        return string;
    }

    @Override
    protected boolean buildQuickFixesOnlyForOnTheFlyErrors() {
        return true;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new BooleanVariableAlwaysNegatedVisitor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/siyeh/ig/dataflow/BooleanVariableAlwaysNegatedInspectionBase";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "buildErrorString";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    private static class AlwaysNegatedVisitor
    extends JavaRecursiveElementWalkingVisitor {
        private final PsiVariable variable;
        private boolean alwaysNegated = true;
        private boolean read;

        AlwaysNegatedVisitor(PsiVariable variable2) {
            this.variable = variable2;
        }

        @Override
        public void visitReferenceExpression(PsiReferenceExpression expression2) {
            super.visitReferenceExpression(expression2);
            if (!this.alwaysNegated) {
                return;
            }
            String referenceName = expression2.getReferenceName();
            if (referenceName == null) {
                return;
            }
            if (!referenceName.equals(this.variable.getName())) {
                return;
            }
            PsiElement target = expression2.resolve();
            if (!this.variable.equals(target)) {
                return;
            }
            if (!PsiUtil.isAccessedForReading(expression2)) {
                return;
            }
            this.read = true;
            PsiElement parent2 = expression2.getParent();
            while (parent2 instanceof PsiParenthesizedExpression) {
                parent2 = parent2.getParent();
            }
            if (!(parent2 instanceof PsiPrefixExpression)) {
                this.alwaysNegated = false;
                return;
            }
            PsiPrefixExpression prefixExpression = (PsiPrefixExpression)parent2;
            IElementType tokenType = prefixExpression.getOperationTokenType();
            if (!JavaTokenType.EXCL.equals(tokenType)) {
                this.alwaysNegated = false;
            }
        }

        boolean isAlwaysNegated() {
            return this.alwaysNegated;
        }

        public boolean isRead() {
            return this.read;
        }
    }

    private static class BooleanVariableAlwaysNegatedVisitor
    extends BaseInspectionVisitor {
        private BooleanVariableAlwaysNegatedVisitor() {
        }

        @Override
        public void visitField(PsiField field) {
            super.visitField(field);
            if (!field.hasModifierProperty("private")) {
                return;
            }
            if (!BooleanVariableAlwaysNegatedVisitor.isAlwaysInvertedBoolean(field, field.getContainingClass())) {
                return;
            }
            this.registerVariableError(field, field);
        }

        @Override
        public void visitLocalVariable(PsiLocalVariable variable2) {
            super.visitLocalVariable(variable2);
            PsiCodeBlock codeBlock = PsiTreeUtil.getParentOfType((PsiElement)variable2, PsiCodeBlock.class);
            if (!BooleanVariableAlwaysNegatedVisitor.isAlwaysInvertedBoolean(variable2, codeBlock)) {
                return;
            }
            this.registerVariableError(variable2, variable2);
        }

        private static boolean isAlwaysInvertedBoolean(@NotNull PsiVariable field, PsiElement context) {
            if (field == null) {
                BooleanVariableAlwaysNegatedVisitor.$$$reportNull$$$0(0);
            }
            if (context == null) {
                return false;
            }
            PsiType type2 = field.getType();
            if (!PsiType.BOOLEAN.equals(type2)) {
                return false;
            }
            AlwaysNegatedVisitor visitor2 = new AlwaysNegatedVisitor(field);
            context.accept(visitor2);
            return visitor2.isRead() && visitor2.isAlwaysNegated();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "field", "com/siyeh/ig/dataflow/BooleanVariableAlwaysNegatedInspectionBase$BooleanVariableAlwaysNegatedVisitor", "isAlwaysInvertedBoolean"));
        }
    }
}

