/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.dataflow;

import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class NegativelyNamedBooleanVariableInspectionBase
extends BaseInspection {
    @NonNls
    private static final String[] NEGATIVE_NAMES = new String[]{"non", "not", "isNot", "isNon", "shouldNot", "shallNot", "willNot", "cannot", "canNot", "cant", "hasNot", "hasnt", "couldNot", "doesNot", "hidden", "isHidden", "disabled", "isDisabled", "isInvalid", "invalid"};

    @Override
    @Nls
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("negatively.named.boolean.variable.display.name", new Object[0]);
        if (string == null) {
            NegativelyNamedBooleanVariableInspectionBase.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos2) {
        String string = InspectionGadgetsBundle.message("negatively.named.boolean.variable.problem.descriptor", new Object[0]);
        if (string == null) {
            NegativelyNamedBooleanVariableInspectionBase.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Override
    protected boolean buildQuickFixesOnlyForOnTheFlyErrors() {
        return true;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new NegativelyNamedBooleanVariableVisitor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/siyeh/ig/dataflow/NegativelyNamedBooleanVariableInspectionBase";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "buildErrorString";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    private static class NegativelyNamedBooleanVariableVisitor
    extends BaseInspectionVisitor {
        private NegativelyNamedBooleanVariableVisitor() {
        }

        @Override
        public void visitVariable(PsiVariable variable2) {
            super.visitVariable(variable2);
            if (!PsiType.BOOLEAN.equals(variable2.getType())) {
                return;
            }
            String name = variable2.getName();
            JavaCodeStyleManager codeStyleManager = JavaCodeStyleManager.getInstance(variable2.getProject());
            String prefix = codeStyleManager.getPrefixByVariableKind(codeStyleManager.getVariableKind(variable2));
            for (String negativeName : NEGATIVE_NAMES) {
                if (!NegativelyNamedBooleanVariableVisitor.isNegativelyNamed(name, negativeName) && (prefix.isEmpty() || !NegativelyNamedBooleanVariableVisitor.isNegativelyNamed(name, prefix + negativeName))) continue;
                this.registerVariableError(variable2, variable2);
                break;
            }
        }

        private static boolean isNegativelyNamed(String name, String negativeName) {
            return name.startsWith(negativeName) && (name.length() == negativeName.length() || Character.isUpperCase(name.charAt(negativeName.length())));
        }
    }
}

