/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.dependency;

import com.intellij.analysis.AnalysisScope;
import com.intellij.codeInspection.CommonProblemDescriptor;
import com.intellij.codeInspection.GlobalInspectionContext;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.QuickFix;
import com.intellij.codeInspection.reference.RefEntity;
import com.intellij.codeInspection.reference.RefPackage;
import com.intellij.codeInspection.util.RefEntityAlphabeticalComparator;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseGlobalInspection;
import com.siyeh.ig.dependency.DependencyUtils;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CyclicPackageDependencyInspection
extends BaseGlobalInspection {
    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("cyclic.package.dependency.display.name", new Object[0]);
        if (string == null) {
            CyclicPackageDependencyInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    @Nullable
    public CommonProblemDescriptor[] checkElement(@NotNull RefEntity refEntity, @NotNull AnalysisScope analysisScope, @NotNull InspectionManager inspectionManager, @NotNull GlobalInspectionContext globalInspectionContext) {
        String errorString;
        if (refEntity == null) {
            CyclicPackageDependencyInspection.$$$reportNull$$$0(1);
        }
        if (analysisScope == null) {
            CyclicPackageDependencyInspection.$$$reportNull$$$0(2);
        }
        if (inspectionManager == null) {
            CyclicPackageDependencyInspection.$$$reportNull$$$0(3);
        }
        if (globalInspectionContext == null) {
            CyclicPackageDependencyInspection.$$$reportNull$$$0(4);
        }
        if (!(refEntity instanceof RefPackage)) {
            return null;
        }
        RefPackage refPackage = (RefPackage)refEntity;
        Set<RefPackage> dependencies2 = DependencyUtils.calculateTransitiveDependenciesForPackage(refPackage);
        Set<RefPackage> dependents = DependencyUtils.calculateTransitiveDependentsForPackage(refPackage);
        HashSet<RefPackage> mutualDependents = new HashSet<RefPackage>(dependencies2);
        mutualDependents.retainAll(dependents);
        int numMutualDependents = mutualDependents.size();
        if (numMutualDependents == 0) {
            return null;
        }
        String packageName = refPackage.getQualifiedName();
        if (numMutualDependents == 1) {
            RefPackage[] packages2 = mutualDependents.toArray(new RefPackage[1]);
            errorString = InspectionGadgetsBundle.message("cyclic.package.dependency.1.problem.descriptor", packageName, packages2[0].getQualifiedName());
        } else if (numMutualDependents == 2) {
            RefPackage[] packages3 = mutualDependents.toArray(new RefPackage[2]);
            Arrays.sort(packages3, RefEntityAlphabeticalComparator.getInstance());
            errorString = InspectionGadgetsBundle.message("cyclic.package.dependency.2.problem.descriptor", packageName, packages3[0].getQualifiedName(), packages3[1].getQualifiedName());
        } else {
            errorString = InspectionGadgetsBundle.message("cyclic.package.dependency.problem.descriptor", packageName, numMutualDependents);
        }
        return new CommonProblemDescriptor[]{inspectionManager.createProblemDescriptor(errorString, new QuickFix[0])};
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/siyeh/ig/dependency/CyclicPackageDependencyInspection";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "refEntity";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "analysisScope";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "inspectionManager";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "globalInspectionContext";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "com/siyeh/ig/dependency/CyclicPackageDependencyInspection";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "checkElement";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

