/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.errorhandling;

import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiCatchSection;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiDisjunctionType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiThrowStatement;
import com.intellij.psi.PsiTryStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.Processor;
import com.intellij.util.Query;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.fixes.DeleteCatchSectionFix;
import com.siyeh.ig.psiutils.ParenthesesUtils;
import gnu.trove.THashSet;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CaughtExceptionImmediatelyRethrownInspection
extends BaseInspection {
    @Override
    @Nls
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("caught.exception.immediately.rethrown.display.name", new Object[0]);
        if (string == null) {
            CaughtExceptionImmediatelyRethrownInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos2) {
        String string = InspectionGadgetsBundle.message("caught.exception.immediately.rethrown.problem.descriptor", new Object[0]);
        if (string == null) {
            CaughtExceptionImmediatelyRethrownInspection.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Override
    public boolean isEnabledByDefault() {
        return true;
    }

    @Override
    @Nullable
    protected InspectionGadgetsFix buildFix(Object ... infos2) {
        PsiTryStatement tryStatement = (PsiTryStatement)infos2[0];
        boolean removeTryCatch = tryStatement.getCatchSections().length == 1 && tryStatement.getFinallyBlock() == null && tryStatement.getResourceList() == null;
        return new DeleteCatchSectionFix(removeTryCatch);
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new CaughtExceptionImmediatelyRethrownVisitor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/siyeh/ig/errorhandling/CaughtExceptionImmediatelyRethrownInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "buildErrorString";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    private static class CaughtExceptionImmediatelyRethrownVisitor
    extends BaseInspectionVisitor {
        private CaughtExceptionImmediatelyRethrownVisitor() {
        }

        @Override
        public void visitThrowStatement(PsiThrowStatement statement2) {
            super.visitThrowStatement(statement2);
            PsiExpression expression2 = ParenthesesUtils.stripParentheses(statement2.getException());
            if (!(expression2 instanceof PsiReferenceExpression)) {
                return;
            }
            PsiStatement previousStatement = PsiTreeUtil.getPrevSiblingOfType(statement2, PsiStatement.class);
            if (previousStatement != null) {
                return;
            }
            PsiElement parent2 = statement2.getParent();
            if (parent2 instanceof PsiStatement) {
                return;
            }
            PsiReferenceExpression referenceExpression = (PsiReferenceExpression)expression2;
            PsiElement target = referenceExpression.resolve();
            if (!(target instanceof PsiParameter)) {
                return;
            }
            PsiParameter parameter = (PsiParameter)target;
            PsiElement declarationScope = parameter.getDeclarationScope();
            if (!(declarationScope instanceof PsiCatchSection)) {
                return;
            }
            PsiCatchSection catchSection = (PsiCatchSection)declarationScope;
            PsiCodeBlock block = PsiTreeUtil.getParentOfType((PsiElement)statement2, PsiCodeBlock.class);
            if (block == null) {
                return;
            }
            PsiElement blockParent = block.getParent();
            if (blockParent != catchSection) {
                return;
            }
            if (CaughtExceptionImmediatelyRethrownVisitor.isSuperClassExceptionCaughtLater(parameter, catchSection)) {
                return;
            }
            Query<PsiReference> query = ReferencesSearch.search(parameter);
            for (PsiReference reference : query) {
                PsiElement element = reference.getElement();
                if (element == expression2) continue;
                return;
            }
            PsiTryStatement tryStatement = catchSection.getTryStatement();
            this.registerVariableError(parameter, tryStatement);
        }

        private static boolean isSuperClassExceptionCaughtLater(PsiVariable parameter, PsiCatchSection catchSection) {
            PsiTryStatement tryStatement = catchSection.getTryStatement();
            PsiCatchSection[] catchSections = tryStatement.getCatchSections();
            for (int index2 = 0; catchSections[index2] != catchSection && index2 < catchSections.length; ++index2) {
            }
            PsiType type2 = parameter.getType();
            THashSet parameterClasses = new THashSet();
            CaughtExceptionImmediatelyRethrownVisitor.processExceptionClasses(type2, aClass2 -> {
                parameterClasses.add(aClass2);
                return true;
            });
            if (parameterClasses.isEmpty()) {
                return false;
            }
            Ref<Boolean> superClassExceptionType = new Ref<Boolean>(Boolean.FALSE);
            for (int i = index2; i < catchSections.length; ++i) {
                PsiCatchSection nextCatchSection = catchSections[i];
                PsiParameter nextParameter = nextCatchSection.getParameter();
                if (nextParameter == null) continue;
                PsiType nextType = nextParameter.getType();
                CaughtExceptionImmediatelyRethrownVisitor.processExceptionClasses(nextType, aClass2 -> {
                    for (PsiClass parameterClass : parameterClasses) {
                        if (!parameterClass.isInheritor((PsiClass)aClass2, true)) continue;
                        superClassExceptionType.set(Boolean.TRUE);
                        return false;
                    }
                    return true;
                });
                if (!superClassExceptionType.get().booleanValue()) continue;
                return true;
            }
            return false;
        }

        private static void processExceptionClasses(PsiType type2, Processor<PsiClass> processor) {
            if (type2 instanceof PsiClassType) {
                PsiClassType classType = (PsiClassType)type2;
                PsiClass aClass2 = classType.resolve();
                if (aClass2 != null) {
                    processor.process(aClass2);
                }
            } else if (type2 instanceof PsiDisjunctionType) {
                PsiDisjunctionType disjunctionType = (PsiDisjunctionType)type2;
                for (PsiType disjunction : disjunctionType.getDisjunctions()) {
                    PsiClassType classType;
                    PsiClass aClass3;
                    if (!(disjunction instanceof PsiClassType) || (aClass3 = (classType = (PsiClassType)disjunction).resolve()) == null) continue;
                    processor.process(aClass3);
                }
            }
        }
    }
}

