/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.errorhandling;

import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiResolveHelper;
import com.intellij.psi.util.InheritanceUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class NewExceptionWithoutArgumentsInspection
extends BaseInspection {
    @Deprecated
    public boolean ignoreWithoutParameters;

    @Override
    @Nls
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("new.exception.without.arguments.display.name", new Object[0]);
        if (string == null) {
            NewExceptionWithoutArgumentsInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos2) {
        String string = InspectionGadgetsBundle.message("new.exception.without.arguments.problem.descriptor", new Object[0]);
        if (string == null) {
            NewExceptionWithoutArgumentsInspection.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new NewExceptionWithoutArgumentsVisitor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/siyeh/ig/errorhandling/NewExceptionWithoutArgumentsInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "buildErrorString";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    private class NewExceptionWithoutArgumentsVisitor
    extends BaseInspectionVisitor {
        private NewExceptionWithoutArgumentsVisitor() {
        }

        @Override
        public void visitNewExpression(PsiNewExpression expression2) {
            super.visitNewExpression(expression2);
            PsiExpressionList argumentList2 = expression2.getArgumentList();
            if (argumentList2 == null) {
                return;
            }
            PsiExpression[] expressions = argumentList2.getExpressions();
            if (expressions.length != 0) {
                return;
            }
            PsiJavaCodeReferenceElement classReference = expression2.getClassReference();
            if (classReference == null) {
                return;
            }
            PsiElement target = classReference.resolve();
            if (!(target instanceof PsiClass)) {
                return;
            }
            PsiClass aClass2 = (PsiClass)target;
            if (!InheritanceUtil.isInheritor(aClass2, "java.lang.Exception")) {
                return;
            }
            if (this.hasAccessibleConstructorWithParameters(aClass2, expression2)) {
                this.registerNewExpressionError(expression2, new Object[0]);
            }
        }

        private boolean hasAccessibleConstructorWithParameters(PsiClass aClass2, PsiElement context) {
            PsiMethod[] constructors2;
            for (PsiMethod constructor : constructors2 = aClass2.getConstructors()) {
                PsiResolveHelper resolveHelper;
                PsiParameterList parameterList = constructor.getParameterList();
                int count2 = parameterList.getParametersCount();
                if (count2 <= 0 || !(resolveHelper = JavaPsiFacade.getInstance(context.getProject()).getResolveHelper()).isAccessible(constructor, context, aClass2)) continue;
                return true;
            }
            return false;
        }
    }
}

