/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.errorhandling;

import com.intellij.openapi.util.Ref;
import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.controlFlow.DefUseUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.psiutils.DeclarationSearchUtils;
import com.siyeh.ig.psiutils.ExpressionUtils;
import com.siyeh.ig.psiutils.ParenthesesUtils;
import com.siyeh.ig.psiutils.TypeUtils;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class UnnecessaryInitCauseInspectionBase
extends BaseInspection {
    @Override
    @Nls
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("unnecessary.initcause.display.name", new Object[0]);
        if (string == null) {
            UnnecessaryInitCauseInspectionBase.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos2) {
        String string = InspectionGadgetsBundle.message("unnecessary.initcause.problem.descriptor", new Object[0]);
        if (string == null) {
            UnnecessaryInitCauseInspectionBase.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new UnnecessaryInitCauseVisitor();
    }

    @Nullable
    static PsiNewExpression findNewExpression(PsiExpression expression2) {
        if (expression2 instanceof PsiNewExpression) {
            return (PsiNewExpression)expression2;
        }
        if (expression2 instanceof PsiReferenceExpression) {
            PsiReferenceExpression referenceExpression = (PsiReferenceExpression)expression2;
            PsiExpression definition = DeclarationSearchUtils.findDefinition(referenceExpression, null);
            if (!(definition instanceof PsiNewExpression)) {
                return null;
            }
            return (PsiNewExpression)definition;
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/siyeh/ig/errorhandling/UnnecessaryInitCauseInspectionBase";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "buildErrorString";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    private static class UnnecessaryInitCauseVisitor
    extends BaseInspectionVisitor {
        private UnnecessaryInitCauseVisitor() {
        }

        @Override
        public void visitMethodCallExpression(PsiMethodCallExpression expression2) {
            super.visitMethodCallExpression(expression2);
            PsiReferenceExpression methodExpression = expression2.getMethodExpression();
            String name = methodExpression.getReferenceName();
            if (!"initCause".equals(name)) {
                return;
            }
            PsiExpressionList argumentList2 = expression2.getArgumentList();
            PsiExpression argument = ExpressionUtils.getOnlyExpressionInList(argumentList2);
            if (!TypeUtils.expressionHasTypeOrSubtype(argument, "java.lang.Throwable")) {
                return;
            }
            PsiMethod method = expression2.resolveMethod();
            if (method == null) {
                return;
            }
            PsiClass aClass2 = method.getContainingClass();
            if (aClass2 == null || !"java.lang.Throwable".equals(aClass2.getQualifiedName())) {
                return;
            }
            PsiExpression qualifier = ParenthesesUtils.stripParentheses(methodExpression.getQualifierExpression());
            PsiNewExpression newExpression = UnnecessaryInitCauseInspectionBase.findNewExpression(qualifier);
            if (!UnnecessaryInitCauseVisitor.isCauseConstructorAvailable(newExpression, argument.getType()) || !UnnecessaryInitCauseVisitor.canExpressionBeMovedBackwards(argument, newExpression)) {
                return;
            }
            this.registerMethodCallError(expression2, new Object[0]);
        }

        private static boolean canExpressionBeMovedBackwards(final PsiExpression cause, PsiExpression newLocation) {
            if (cause == null || newLocation == null) {
                return false;
            }
            assert (cause.getTextOffset() > newLocation.getTextOffset());
            final PsiCodeBlock block = PsiTreeUtil.getParentOfType((PsiElement)cause, PsiCodeBlock.class);
            PsiCodeBlock newBlock = PsiTreeUtil.getParentOfType((PsiElement)newLocation, PsiCodeBlock.class);
            if (block == null || newBlock == null || !PsiTreeUtil.isAncestor(block, newBlock, false)) {
                return false;
            }
            final int offset2 = newLocation.getTextOffset();
            final Ref<Boolean> result2 = new Ref<Boolean>(Boolean.TRUE);
            cause.accept(new JavaRecursiveElementWalkingVisitor(){

                @Override
                public void visitReferenceExpression(PsiReferenceExpression expression2) {
                    PsiElement[] defs;
                    if (!((Boolean)result2.get()).booleanValue()) {
                        return;
                    }
                    super.visitReferenceExpression(expression2);
                    PsiElement target = expression2.resolve();
                    if (!(target instanceof PsiVariable)) {
                        return;
                    }
                    for (PsiElement def : defs = DefUseUtil.getDefs(block, (PsiVariable)target, cause)) {
                        if (def.getTextOffset() <= offset2) continue;
                        result2.set(Boolean.FALSE);
                    }
                }
            });
            return result2.get();
        }

        public static boolean isCauseConstructorAvailable(PsiNewExpression newExpression, PsiType causeType) {
            if (newExpression == null || causeType == null) {
                return false;
            }
            PsiMethod constructor = newExpression.resolveConstructor();
            if (constructor == null) {
                return false;
            }
            PsiClass aClass2 = constructor.getContainingClass();
            if (aClass2 == null) {
                return false;
            }
            PsiExpressionList argumentList2 = newExpression.getArgumentList();
            if (argumentList2 == null) {
                return false;
            }
            PsiExpression[] arguments2 = argumentList2.getExpressions();
            block0: for (PsiMethod constructor1 : aClass2.getConstructors()) {
                PsiParameterList parameterList = constructor1.getParameterList();
                if (parameterList.getParametersCount() != arguments2.length + 1) continue;
                PsiParameter[] parameters2 = parameterList.getParameters();
                for (int i = 0; i < arguments2.length; ++i) {
                    PsiExpression argument = arguments2[i];
                    PsiParameter parameter = parameters2[i];
                    PsiType type2 = argument.getType();
                    if (type2 == null || !parameter.getType().isAssignableFrom(type2)) continue block0;
                }
                PsiParameter lastParameter = parameters2[parameters2.length - 1];
                if (!lastParameter.getType().isAssignableFrom(causeType)) continue;
                return true;
            }
            return false;
        }
    }
}

