/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.inheritance;

import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiReferenceList;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import org.jetbrains.annotations.NotNull;

public class ExtendsAnnotationInspection
extends BaseInspection {
    @Override
    @NotNull
    public String getID() {
        if ("ClassExplicitlyAnnotation" == null) {
            ExtendsAnnotationInspection.$$$reportNull$$$0(0);
        }
        return "ClassExplicitlyAnnotation";
    }

    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("extends.annotation.display.name", new Object[0]);
        if (string == null) {
            ExtendsAnnotationInspection.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Override
    public boolean isEnabledByDefault() {
        return true;
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos2) {
        PsiClass containingClass = (PsiClass)infos2[0];
        String string = containingClass.isInterface() ? InspectionGadgetsBundle.message("extends.annotation.interface.problem.descriptor", containingClass.getName()) : InspectionGadgetsBundle.message("extends.annotation.problem.descriptor", containingClass.getName());
        if (string == null) {
            ExtendsAnnotationInspection.$$$reportNull$$$0(2);
        }
        return string;
    }

    @Override
    public boolean shouldInspect(PsiFile file2) {
        return PsiUtil.isLanguageLevel5OrHigher(file2);
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new ExtendsAnnotationVisitor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/siyeh/ig/inheritance/ExtendsAnnotationInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getID";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "buildErrorString";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    private static class ExtendsAnnotationVisitor
    extends BaseInspectionVisitor {
        private ExtendsAnnotationVisitor() {
        }

        @Override
        public void visitClass(@NotNull PsiClass aClass2) {
            if (aClass2 == null) {
                ExtendsAnnotationVisitor.$$$reportNull$$$0(0);
            }
            if (aClass2.isAnnotationType() || InheritanceUtil.isInheritor(aClass2, "javax.enterprise.util.AnnotationLiteral")) {
                return;
            }
            this.checkReferenceList(aClass2.getExtendsList(), aClass2);
            this.checkReferenceList(aClass2.getImplementsList(), aClass2);
        }

        private void checkReferenceList(PsiReferenceList referenceList, PsiClass containingClass) {
            PsiJavaCodeReferenceElement[] elements;
            if (referenceList == null) {
                return;
            }
            for (PsiJavaCodeReferenceElement element : elements = referenceList.getReferenceElements()) {
                PsiClass psiClass;
                PsiElement referent = element.resolve();
                if (!(referent instanceof PsiClass) || !(psiClass = (PsiClass)referent).isAnnotationType()) continue;
                this.registerError((PsiElement)element, containingClass);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "com/siyeh/ig/inheritance/ExtendsAnnotationInspection$ExtendsAnnotationVisitor", "visitClass"));
        }
    }
}

