/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.initialization;

import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaRecursiveElementVisitor;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassInitializer;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.psiutils.ClassUtils;
import com.siyeh.ig.psiutils.ParenthesesUtils;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DoubleBraceInitializationInspection
extends BaseInspection {
    @Override
    @Nls
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("double.brace.initialization.display.name", new Object[0]);
        if (string == null) {
            DoubleBraceInitializationInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos2) {
        String string = InspectionGadgetsBundle.message("double.brace.initialization.display.name", new Object[0]);
        if (string == null) {
            DoubleBraceInitializationInspection.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Override
    @Nullable
    protected InspectionGadgetsFix buildFix(Object ... infos2) {
        PsiClass aClass2 = (PsiClass)infos2[0];
        PsiElement parent2 = PsiTreeUtil.skipParentsOfType(aClass2, PsiNewExpression.class, ParenthesesUtils.class);
        if (!(parent2 instanceof PsiVariable) && !(parent2 instanceof PsiAssignmentExpression)) {
            return null;
        }
        return new DoubleBraceInitializationFix();
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new DoubleBraceInitializationVisitor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/siyeh/ig/initialization/DoubleBraceInitializationInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "buildErrorString";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    private static class DoubleBraceInitializationVisitor
    extends BaseInspectionVisitor {
        private DoubleBraceInitializationVisitor() {
        }

        @Override
        public void visitAnonymousClass(PsiAnonymousClass aClass2) {
            super.visitAnonymousClass(aClass2);
            if (ClassUtils.getDoubleBraceInitializer(aClass2) == null) {
                return;
            }
            this.registerClassError(aClass2, aClass2);
        }
    }

    private static class DoubleBraceInitializationFix
    extends InspectionGadgetsFix {
        private DoubleBraceInitializationFix() {
        }

        @Override
        @NotNull
        public String getFamilyName() {
            String string = InspectionGadgetsBundle.message("double.brace.initialization.quickfix", new Object[0]);
            if (string == null) {
                DoubleBraceInitializationFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        @Override
        protected void doFix(Project project, ProblemDescriptor descriptor2) {
            PsiElement child;
            String qualifierText;
            PsiElement element = descriptor2.getPsiElement().getParent();
            if (!(element instanceof PsiAnonymousClass)) {
                return;
            }
            PsiAnonymousClass aClass2 = (PsiAnonymousClass)element;
            PsiElement parent2 = aClass2.getParent();
            if (!(parent2 instanceof PsiNewExpression)) {
                return;
            }
            PsiNewExpression newExpression = (PsiNewExpression)parent2;
            PsiElement ancestor = PsiTreeUtil.skipParentsOfType(newExpression, ParenthesesUtils.class);
            if (ancestor instanceof PsiVariable) {
                qualifierText = ((PsiVariable)ancestor).getName();
            } else if (ancestor instanceof PsiAssignmentExpression) {
                PsiAssignmentExpression assignmentExpression = (PsiAssignmentExpression)ancestor;
                PsiExpression lhs = ParenthesesUtils.stripParentheses(assignmentExpression.getLExpression());
                if (!(lhs instanceof PsiReferenceExpression)) {
                    return;
                }
                PsiReferenceExpression referenceExpression = (PsiReferenceExpression)lhs;
                PsiElement target = referenceExpression.resolve();
                if (!(target instanceof PsiVariable)) {
                    return;
                }
                qualifierText = referenceExpression.getText();
            } else {
                return;
            }
            PsiElementFactory factory2 = JavaPsiFacade.getElementFactory(project);
            PsiJavaCodeReferenceElement baseClassReference = aClass2.getBaseClassReference();
            PsiElement baseClassTarget = baseClassReference.resolve();
            if (!(baseClassTarget instanceof PsiClass)) {
                return;
            }
            PsiExpressionList argumentList2 = aClass2.getArgumentList();
            if (argumentList2 == null) {
                return;
            }
            DoubleBraceInitializationFix.qualifyReferences(aClass2, (PsiClass)baseClassTarget, qualifierText);
            PsiClassInitializer initializer2 = aClass2.getInitializers()[0];
            PsiCodeBlock body = initializer2.getBody();
            PsiElement stop = body.getFirstBodyElement();
            Object anchor2 = PsiTreeUtil.getParentOfType((PsiElement)aClass2, PsiMember.class, PsiStatement.class);
            if (anchor2 == null) {
                return;
            }
            if (anchor2 instanceof PsiMember) {
                PsiModifierList modifierList;
                PsiMember member = (PsiMember)anchor2;
                PsiClassInitializer newInitializer = factory2.createClassInitializer();
                if (member.hasModifierProperty("static") && (modifierList = newInitializer.getModifierList()) != null) {
                    modifierList.setModifierProperty("static", true);
                }
                PsiCodeBlock initializerBody = newInitializer.getBody();
                while (child != null && !child.equals(stop)) {
                    initializerBody.add(child);
                    child = child.getPrevSibling();
                }
                member.getParent().addAfter(newInitializer, member);
            } else {
                PsiElement container2 = anchor2.getParent();
                for (child = body.getLastBodyElement(); child != null && !child.equals(stop); child = child.getPrevSibling()) {
                    container2.addAfter(child, (PsiElement)anchor2);
                }
            }
            PsiExpression newNewExpression = factory2.createExpressionFromText("new " + baseClassReference.getText() + argumentList2.getText(), aClass2);
            newExpression.replace(newNewExpression);
        }

        private static void qualifyReferences(PsiElement element, final PsiClass target, final String qualifierText) {
            final PsiElementFactory factory2 = JavaPsiFacade.getElementFactory(element.getProject());
            element.accept(new JavaRecursiveElementVisitor(){

                @Override
                public void visitReferenceExpression(PsiReferenceExpression expression2) {
                    super.visitReferenceExpression(expression2);
                    if (expression2.getQualifierExpression() != null) {
                        return;
                    }
                    PsiElement expressionTarget = expression2.resolve();
                    if (!(expressionTarget instanceof PsiMember)) {
                        return;
                    }
                    PsiMember member = (PsiMember)expressionTarget;
                    PsiClass containingClass = member.getContainingClass();
                    if (!InheritanceUtil.isInheritorOrSelf(target, containingClass, true)) {
                        return;
                    }
                    PsiExpression newExpression = factory2.createExpressionFromText(qualifierText + '.' + expression2.getText(), expression2);
                    expression2.replace(newExpression);
                }
            });
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/initialization/DoubleBraceInitializationInspection$DoubleBraceInitializationFix", "getFamilyName"));
        }
    }
}

