/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.internationalization;

import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.psiutils.TypeUtils;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class ImplicitDefaultCharsetUsageInspection
extends BaseInspection {
    @Override
    @Nls
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("implicit.default.charset.usage.display.name", new Object[0]);
        if (string == null) {
            ImplicitDefaultCharsetUsageInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos2) {
        if (infos2[0] instanceof PsiNewExpression) {
            String string = InspectionGadgetsBundle.message("implicit.default.charset.usage.constructor.problem.descriptor", new Object[0]);
            if (string == null) {
                ImplicitDefaultCharsetUsageInspection.$$$reportNull$$$0(1);
            }
            return string;
        }
        String string = InspectionGadgetsBundle.message("implicit.default.charset.usage.problem.descriptor", new Object[0]);
        if (string == null) {
            ImplicitDefaultCharsetUsageInspection.$$$reportNull$$$0(2);
        }
        return string;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new ImplicitDefaultCharsetUsageVisitor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/siyeh/ig/internationalization/ImplicitDefaultCharsetUsageInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "buildErrorString";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    private static class ImplicitDefaultCharsetUsageVisitor
    extends BaseInspectionVisitor {
        private ImplicitDefaultCharsetUsageVisitor() {
        }

        @Override
        public void visitMethodCallExpression(PsiMethodCallExpression expression2) {
            super.visitMethodCallExpression(expression2);
            PsiReferenceExpression methodExpression = expression2.getMethodExpression();
            String name = methodExpression.getReferenceName();
            if (!"getBytes".equals(name)) {
                return;
            }
            PsiMethod method = expression2.resolveMethod();
            if (method == null) {
                return;
            }
            PsiParameterList parameterList = method.getParameterList();
            if (parameterList.getParametersCount() == 1) {
                return;
            }
            PsiClass aClass2 = method.getContainingClass();
            if (aClass2 == null) {
                return;
            }
            String qName = aClass2.getQualifiedName();
            if (!"java.lang.String".equals(qName)) {
                return;
            }
            this.registerMethodCallError(expression2, expression2);
        }

        @Override
        public void visitNewExpression(PsiNewExpression expression2) {
            super.visitNewExpression(expression2);
            PsiMethod constructor = expression2.resolveConstructor();
            if (constructor == null) {
                return;
            }
            PsiClass aClass2 = constructor.getContainingClass();
            if (aClass2 == null) {
                return;
            }
            PsiParameterList parameterList = constructor.getParameterList();
            int count2 = parameterList.getParametersCount();
            if (count2 == 0) {
                return;
            }
            PsiParameter[] parameters2 = parameterList.getParameters();
            String qName = aClass2.getQualifiedName();
            if ("java.lang.String".equals(qName)) {
                if (!parameters2[0].getType().equalsToText("byte[]") || ImplicitDefaultCharsetUsageVisitor.hasCharsetType(parameters2[count2 - 1])) {
                    return;
                }
            } else if ("java.io.InputStreamReader".equals(qName) || "java.io.OutputStreamWriter".equals(qName) || "java.io.PrintStream".equals(qName)) {
                if (ImplicitDefaultCharsetUsageVisitor.hasCharsetType(parameters2[count2 - 1])) {
                    return;
                }
            } else if ("java.io.PrintWriter".equals(qName)) {
                if (count2 > 1 && ImplicitDefaultCharsetUsageVisitor.hasCharsetType(parameters2[count2 - 1]) || parameters2[0].getType().equalsToText("java.io.Writer")) {
                    return;
                }
            } else if ("java.util.Formatter".equals(qName)) {
                if (count2 > 1 && ImplicitDefaultCharsetUsageVisitor.hasCharsetType(parameters2[1])) {
                    return;
                }
                PsiType firstType = parameters2[0].getType();
                if (!(firstType.equalsToText("java.lang.String") || firstType.equalsToText("java.io.File") || firstType.equalsToText("java.io.OutputStream"))) {
                    return;
                }
            } else if ("java.util.Scanner".equals(qName)) {
                if (count2 > 1 && ImplicitDefaultCharsetUsageVisitor.hasCharsetType(parameters2[1])) {
                    return;
                }
                PsiType firstType = parameters2[0].getType();
                if (!(firstType.equalsToText("java.io.InputStream") || firstType.equalsToText("java.io.File") || firstType.equalsToText("java.nio.file.Path") || firstType.equalsToText("java.nio.channels.ReadableByteChannel"))) {
                    return;
                }
            } else if (!"java.io.FileReader".equals(qName) && !"java.io.FileWriter".equals(qName)) {
                return;
            }
            this.registerNewExpressionError(expression2, expression2);
        }

        private static boolean hasCharsetType(PsiVariable variable2) {
            return TypeUtils.variableHasTypeOrSubtype(variable2, "java.lang.String", "java.nio.charset.Charset", "java.nio.charset.CharsetEncoder", "java.nio.charset.CharsetDecoder");
        }
    }
}

