/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.j2me;

import com.intellij.codeInspection.ui.SingleIntegerFieldOptionsPanel;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiCatchSection;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiTryStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.ConstantExpressionUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;

public class CheckForOutOfMemoryOnLargeArrayAllocationInspection
extends BaseInspection {
    public int m_limit = 64;

    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("large.array.allocation.no.outofmemoryerror.display.name", new Object[0]);
        if (string == null) {
            CheckForOutOfMemoryOnLargeArrayAllocationInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos2) {
        String string = InspectionGadgetsBundle.message("large.array.allocation.no.outofmemoryerror.problem.descriptor", new Object[0]);
        if (string == null) {
            CheckForOutOfMemoryOnLargeArrayAllocationInspection.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Override
    public JComponent createOptionsPanel() {
        return new SingleIntegerFieldOptionsPanel(InspectionGadgetsBundle.message("large.array.allocation.no.outofmemoryerror.maximum.number.of.elements.option", new Object[0]), this, "m_limit", 5);
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new CheckForOutOfMemoryOnLargeArrayAllocationVisitor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/siyeh/ig/j2me/CheckForOutOfMemoryOnLargeArrayAllocationInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "buildErrorString";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    private class CheckForOutOfMemoryOnLargeArrayAllocationVisitor
    extends BaseInspectionVisitor {
        private CheckForOutOfMemoryOnLargeArrayAllocationVisitor() {
        }

        @Override
        public void visitNewExpression(@NotNull PsiNewExpression expression2) {
            PsiExpression[] dimensions;
            if (expression2 == null) {
                CheckForOutOfMemoryOnLargeArrayAllocationVisitor.$$$reportNull$$$0(0);
            }
            super.visitNewExpression(expression2);
            PsiType type2 = expression2.getType();
            if (!(type2 instanceof PsiArrayType)) {
                return;
            }
            int size = 1;
            for (PsiExpression dimension : dimensions = expression2.getArrayDimensions()) {
                Integer intValue = (Integer)ConstantExpressionUtil.computeCastTo(dimension, (PsiType)PsiType.INT);
                if (intValue == null) continue;
                size *= intValue.intValue();
            }
            if (size <= CheckForOutOfMemoryOnLargeArrayAllocationInspection.this.m_limit) {
                return;
            }
            if (this.outOfMemoryExceptionCaught(expression2)) {
                return;
            }
            this.registerNewExpressionError(expression2, new Object[0]);
        }

        private boolean outOfMemoryExceptionCaught(PsiElement element) {
            PsiElement currentElement = element;
            PsiTryStatement containingTryStatement;
            while ((containingTryStatement = PsiTreeUtil.getParentOfType(currentElement, PsiTryStatement.class)) != null) {
                if (this.catchesOutOfMemoryException(containingTryStatement)) {
                    return true;
                }
                currentElement = containingTryStatement;
            }
            return false;
        }

        private boolean catchesOutOfMemoryException(PsiTryStatement statement2) {
            PsiCatchSection[] sections;
            for (PsiCatchSection section : sections = statement2.getCatchSections()) {
                String typeText;
                PsiType catchType = section.getCatchType();
                if (catchType == null || !"java.lang.OutOfMemoryError".equals(typeText = catchType.getCanonicalText())) continue;
                return true;
            }
            return false;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/siyeh/ig/j2me/CheckForOutOfMemoryOnLargeArrayAllocationInspection$CheckForOutOfMemoryOnLargeArrayAllocationVisitor", "visitNewExpression"));
        }
    }
}

