/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.j2me;

import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaResolveResult;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.util.FileTypeUtils;
import com.intellij.psi.util.PsiTreeUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.psiutils.ClassUtils;
import com.siyeh.ig.psiutils.ExpressionUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PrivateMemberAccessBetweenOuterAndInnerClassInspection
extends BaseInspection {
    @Override
    @NotNull
    public String getID() {
        if ("SyntheticAccessorCall" == null) {
            PrivateMemberAccessBetweenOuterAndInnerClassInspection.$$$reportNull$$$0(0);
        }
        return "SyntheticAccessorCall";
    }

    @Override
    @Nullable
    public String getAlternativeID() {
        return "PrivateMemberAccessBetweenOuterAndInnerClass";
    }

    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("private.member.access.between.outer.and.inner.classes.display.name", new Object[0]);
        if (string == null) {
            PrivateMemberAccessBetweenOuterAndInnerClassInspection.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos2) {
        PsiClass aClass2 = (PsiClass)infos2[0];
        String string = InspectionGadgetsBundle.message("private.member.access.between.outer.and.inner.classes.problem.descriptor", aClass2.getName());
        if (string == null) {
            PrivateMemberAccessBetweenOuterAndInnerClassInspection.$$$reportNull$$$0(2);
        }
        return string;
    }

    @Override
    public InspectionGadgetsFix buildFix(Object ... infos2) {
        PsiClass aClass2 = (PsiClass)infos2[0];
        String className2 = aClass2.getName();
        if (infos2.length == 1) {
            return new MakePackagePrivateFix(className2, true);
        }
        PsiMember member = (PsiMember)infos2[1];
        String memberName = member instanceof PsiMethod ? member.getName() + "()" : member.getName();
        String elementName = className2 + '.' + memberName;
        return new MakePackagePrivateFix(elementName, false);
    }

    @Override
    public boolean shouldInspect(PsiFile file2) {
        return !FileTypeUtils.isInServerPageFile(file2);
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new PrivateMemberAccessFromInnerClassVisitor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/siyeh/ig/j2me/PrivateMemberAccessBetweenOuterAndInnerClassInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getID";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "buildErrorString";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    private static class PrivateMemberAccessFromInnerClassVisitor
    extends BaseInspectionVisitor {
        private PrivateMemberAccessFromInnerClassVisitor() {
        }

        @Override
        public void visitNewExpression(PsiNewExpression expression2) {
            super.visitNewExpression(expression2);
            if (expression2.getType() instanceof PsiArrayType) {
                return;
            }
            PsiClass containingClass = PrivateMemberAccessFromInnerClassVisitor.getContainingContextClass(expression2);
            if (containingClass == null) {
                return;
            }
            JavaResolveResult resolveResult = expression2.resolveMethodGenerics();
            if (!resolveResult.isAccessible()) {
                return;
            }
            PsiMethod constructor = (PsiMethod)resolveResult.getElement();
            if (constructor == null) {
                PsiJavaCodeReferenceElement classReference = expression2.getClassOrAnonymousClassReference();
                if (classReference == null) {
                    return;
                }
                PsiElement target = classReference.resolve();
                if (!(target instanceof PsiClass)) {
                    return;
                }
                PsiClass aClass2 = (PsiClass)target;
                if (!aClass2.hasModifierProperty("private")) {
                    return;
                }
                if (aClass2.equals(containingClass)) {
                    return;
                }
                this.registerNewExpressionError(expression2, aClass2);
            } else {
                if (!constructor.hasModifierProperty("private")) {
                    return;
                }
                PsiClass aClass3 = constructor.getContainingClass();
                if (containingClass.equals(aClass3)) {
                    return;
                }
                this.registerNewExpressionError(expression2, aClass3);
            }
        }

        @Override
        public void visitReferenceExpression(@NotNull PsiReferenceExpression expression2) {
            if (expression2 == null) {
                PrivateMemberAccessFromInnerClassVisitor.$$$reportNull$$$0(0);
            }
            super.visitReferenceExpression(expression2);
            PsiElement referenceNameElement = expression2.getReferenceNameElement();
            if (referenceNameElement == null) {
                return;
            }
            JavaResolveResult resolveResult = expression2.advancedResolve(false);
            if (!resolveResult.isAccessible()) {
                return;
            }
            PsiElement element = resolveResult.getElement();
            if (!(element instanceof PsiMethod) && !(element instanceof PsiField)) {
                return;
            }
            PsiMember member = (PsiMember)element;
            if (!member.hasModifierProperty("private")) {
                return;
            }
            Object value = ExpressionUtils.computeConstantExpression(expression2);
            if (value != null) {
                return;
            }
            PsiClass containingClass = PrivateMemberAccessFromInnerClassVisitor.getContainingContextClass(expression2);
            if (containingClass == null) {
                return;
            }
            PsiClass memberClass = ClassUtils.getContainingClass(member);
            if (memberClass == null || memberClass.equals(containingClass)) {
                return;
            }
            this.registerError(referenceNameElement, memberClass, member);
        }

        @Nullable
        private static PsiClass getContainingContextClass(PsiElement element) {
            PsiAnonymousClass anonymousClass;
            PsiExpressionList arguments2;
            PsiClass aClass2 = ClassUtils.getContainingClass(element);
            if (aClass2 instanceof PsiAnonymousClass && (arguments2 = (anonymousClass = (PsiAnonymousClass)aClass2).getArgumentList()) != null && PsiTreeUtil.isAncestor(arguments2, element, true)) {
                return ClassUtils.getContainingClass(aClass2);
            }
            return aClass2;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/siyeh/ig/j2me/PrivateMemberAccessBetweenOuterAndInnerClassInspection$PrivateMemberAccessFromInnerClassVisitor", "visitReferenceExpression"));
        }
    }

    private static class MakePackagePrivateFix
    extends InspectionGadgetsFix {
        private final String elementName;
        private final boolean constructor;

        private MakePackagePrivateFix(String elementName, boolean constructor) {
            this.elementName = elementName;
            this.constructor = constructor;
        }

        @Override
        @NotNull
        public String getName() {
            if (this.constructor) {
                String string = InspectionGadgetsBundle.message("private.member.access.between.outer.and.inner.classes.make.constructor.package.local.quickfix", this.elementName);
                if (string == null) {
                    MakePackagePrivateFix.$$$reportNull$$$0(0);
                }
                return string;
            }
            String string = InspectionGadgetsBundle.message("private.member.access.between.outer.and.inner.classes.make.local.quickfix", this.elementName);
            if (string == null) {
                MakePackagePrivateFix.$$$reportNull$$$0(1);
            }
            return string;
        }

        @Override
        @NotNull
        public String getFamilyName() {
            if ("Make package-private" == null) {
                MakePackagePrivateFix.$$$reportNull$$$0(2);
            }
            return "Make package-private";
        }

        @Override
        public void doFix(Project project, ProblemDescriptor descriptor2) {
            PsiElement element = descriptor2.getPsiElement();
            if (this.constructor) {
                MakePackagePrivateFix.makeConstructorPackageLocal(project, element);
            } else {
                MakePackagePrivateFix.makeMemberPackageLocal(element);
            }
        }

        private static void makeMemberPackageLocal(PsiElement element) {
            PsiElement parent2 = element.getParent();
            PsiReferenceExpression reference = (PsiReferenceExpression)parent2;
            PsiModifierListOwner member = (PsiModifierListOwner)reference.resolve();
            if (member == null) {
                return;
            }
            PsiModifierList modifiers2 = member.getModifierList();
            if (modifiers2 == null) {
                return;
            }
            modifiers2.setModifierProperty("public", false);
            modifiers2.setModifierProperty("protected", false);
            modifiers2.setModifierProperty("private", false);
        }

        private static void makeConstructorPackageLocal(Project project, PsiElement element) {
            PsiNewExpression newExpression = PsiTreeUtil.getParentOfType(element, PsiNewExpression.class);
            if (newExpression == null) {
                return;
            }
            PsiMethod constructor = newExpression.resolveConstructor();
            if (constructor != null) {
                PsiModifierList modifierList = constructor.getModifierList();
                modifierList.setModifierProperty("private", false);
                return;
            }
            PsiJavaCodeReferenceElement referenceElement = (PsiJavaCodeReferenceElement)element;
            PsiElement target = referenceElement.resolve();
            if (!(target instanceof PsiClass)) {
                return;
            }
            PsiClass aClass2 = (PsiClass)target;
            PsiElementFactory elementFactory = JavaPsiFacade.getElementFactory(project);
            PsiMethod newConstructor = elementFactory.createConstructor();
            PsiModifierList modifierList = newConstructor.getModifierList();
            modifierList.setModifierProperty("packageLocal", true);
            aClass2.add(newConstructor);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[2];
            objectArray2[0] = "com/siyeh/ig/j2me/PrivateMemberAccessBetweenOuterAndInnerClassInspection$MakePackagePrivateFix";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
            }
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
        }
    }
}

