/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.javabeans;

import com.intellij.codeInspection.ui.SingleCheckboxOptionsPanel;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.codeStyle.VariableKind;
import com.intellij.psi.util.PropertyUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import javax.swing.JComponent;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SuspiciousGetterSetterInspection
extends BaseInspection {
    public boolean onlyWarnWhenFieldPresent = false;

    @Override
    @Nls
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("suspicious.getter.setter.display.name", new Object[0]);
        if (string == null) {
            SuspiciousGetterSetterInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos2) {
        String string = (Boolean)infos2[0] != false ? InspectionGadgetsBundle.message("suspicious.setter.problem.descriptor", infos2[1]) : InspectionGadgetsBundle.message("suspicious.getter.problem.descriptor", infos2[1]);
        if (string == null) {
            SuspiciousGetterSetterInspection.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Override
    @Nullable
    public JComponent createOptionsPanel() {
        return new SingleCheckboxOptionsPanel("Only warn when field matching getter/setter name is present", this, "onlyWarnWhenFieldPresent");
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new SuspiciousGetterSetterVisitor();
    }

    private static boolean nameStartsWith(String name, String prefix) {
        return name.startsWith(prefix) && name.length() != prefix.length() && Character.isUpperCase(name.charAt(prefix.length()));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/siyeh/ig/javabeans/SuspiciousGetterSetterInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "buildErrorString";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    private class SuspiciousGetterSetterVisitor
    extends BaseInspectionVisitor {
        private SuspiciousGetterSetterVisitor() {
        }

        @Override
        public void visitMethod(PsiMethod method) {
            boolean setter2;
            String extractedFieldName;
            String fieldName;
            PsiField getterField;
            super.visitMethod(method);
            String name = method.getName();
            if (SuspiciousGetterSetterInspection.nameStartsWith(name, "get")) {
                getterField = PropertyUtil.getFieldOfGetter(method);
                if (getterField == null) {
                    return;
                }
                fieldName = getterField.getName();
                extractedFieldName = name.substring(3);
                setter2 = false;
            } else if (SuspiciousGetterSetterInspection.nameStartsWith(name, "is")) {
                getterField = PropertyUtil.getFieldOfGetter(method);
                if (getterField == null) {
                    return;
                }
                fieldName = getterField.getName();
                extractedFieldName = name.substring(2);
                setter2 = false;
            } else if (SuspiciousGetterSetterInspection.nameStartsWith(name, "set")) {
                PsiField setterField = PropertyUtil.getFieldOfSetter(method);
                if (setterField == null) {
                    return;
                }
                fieldName = setterField.getName();
                extractedFieldName = name.substring(3);
                setter2 = true;
            } else {
                return;
            }
            if (fieldName == null) {
                return;
            }
            JavaCodeStyleManager codeStyleManager = JavaCodeStyleManager.getInstance(method.getProject());
            String computedFieldName = codeStyleManager.propertyNameToVariableName(extractedFieldName, VariableKind.FIELD);
            String computedStaticFieldName = codeStyleManager.propertyNameToVariableName(extractedFieldName, VariableKind.STATIC_FINAL_FIELD);
            if (fieldName.equalsIgnoreCase(computedFieldName) || fieldName.equalsIgnoreCase(computedStaticFieldName)) {
                return;
            }
            if (SuspiciousGetterSetterInspection.this.onlyWarnWhenFieldPresent) {
                PsiClass aClass2 = method.getContainingClass();
                if (aClass2 == null) {
                    return;
                }
                if (aClass2.findFieldByName(computedFieldName, true) == null && aClass2.findFieldByName(computedStaticFieldName, true) == null) {
                    return;
                }
            }
            this.registerMethodError(method, setter2, fieldName);
        }
    }
}

