/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.javadoc;

import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ui.SingleCheckboxOptionsPanel;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaDocumentedElement;
import com.intellij.psi.PsiJavaModule;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.javadoc.PsiDocComment;
import com.intellij.psi.javadoc.PsiDocTag;
import com.intellij.psi.util.PsiUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.psiutils.MethodUtils;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MissingDeprecatedAnnotationInspection
extends BaseInspection {
    public boolean warnOnMissingJavadoc = false;

    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("missing.deprecated.annotation.display.name", new Object[0]);
        if (string == null) {
            MissingDeprecatedAnnotationInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos2) {
        boolean annotationWarning = (Boolean)infos2[0];
        String string = annotationWarning ? InspectionGadgetsBundle.message("missing.deprecated.annotation.problem.descriptor", new Object[0]) : InspectionGadgetsBundle.message("missing.deprecated.tag.problem.descriptor", new Object[0]);
        if (string == null) {
            MissingDeprecatedAnnotationInspection.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Override
    @Nullable
    public JComponent createOptionsPanel() {
        return new SingleCheckboxOptionsPanel(InspectionGadgetsBundle.message("missing.deprecated.tag.option", new Object[0]), this, "warnOnMissingJavadoc");
    }

    @Override
    public boolean runForWholeFile() {
        return true;
    }

    @Override
    protected InspectionGadgetsFix buildFix(Object ... infos2) {
        boolean annotationWarning = (Boolean)infos2[0];
        if (!annotationWarning) {
            return null;
        }
        return new MissingDeprecatedAnnotationFix();
    }

    @Override
    public boolean shouldInspect(PsiFile file2) {
        return PsiUtil.isLanguageLevel5OrHigher(file2);
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new MissingDeprecatedAnnotationVisitor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/siyeh/ig/javadoc/MissingDeprecatedAnnotationInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "buildErrorString";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    private class MissingDeprecatedAnnotationVisitor
    extends BaseInspectionVisitor {
        private MissingDeprecatedAnnotationVisitor() {
        }

        @Override
        public void visitModule(@NotNull PsiJavaModule module2) {
            if (module2 == null) {
                MissingDeprecatedAnnotationVisitor.$$$reportNull$$$0(0);
            }
            super.visitModule(module2);
            if (this.hasDeprecatedAnnotation(module2)) {
                if (MissingDeprecatedAnnotationInspection.this.warnOnMissingJavadoc && !this.hasDeprecatedComment(module2, true)) {
                    this.registerModuleError(module2, Boolean.FALSE);
                }
            } else if (this.hasDeprecatedComment(module2, false)) {
                this.registerModuleError(module2, Boolean.TRUE);
            }
        }

        @Override
        public void visitClass(@NotNull PsiClass aClass2) {
            if (aClass2 == null) {
                MissingDeprecatedAnnotationVisitor.$$$reportNull$$$0(1);
            }
            super.visitClass(aClass2);
            if (this.hasDeprecatedAnnotation(aClass2)) {
                if (MissingDeprecatedAnnotationInspection.this.warnOnMissingJavadoc && !this.hasDeprecatedComment(aClass2, true)) {
                    this.registerClassError(aClass2, Boolean.FALSE);
                }
            } else if (this.hasDeprecatedComment(aClass2, false)) {
                this.registerClassError(aClass2, Boolean.TRUE);
            }
        }

        @Override
        public void visitMethod(@NotNull PsiMethod method) {
            if (method == null) {
                MissingDeprecatedAnnotationVisitor.$$$reportNull$$$0(2);
            }
            if (method.getNameIdentifier() == null) {
                return;
            }
            if (this.hasDeprecatedAnnotation(method)) {
                if (MissingDeprecatedAnnotationInspection.this.warnOnMissingJavadoc) {
                    PsiMethod m = method;
                    while (m != null) {
                        if (this.hasDeprecatedComment(m, true)) {
                            return;
                        }
                        m = MethodUtils.getSuper(m);
                    }
                    this.registerMethodError(method, Boolean.FALSE);
                }
            } else if (this.hasDeprecatedComment(method, false)) {
                this.registerMethodError(method, Boolean.TRUE);
            }
        }

        @Override
        public void visitField(@NotNull PsiField field) {
            if (field == null) {
                MissingDeprecatedAnnotationVisitor.$$$reportNull$$$0(3);
            }
            if (this.hasDeprecatedAnnotation(field)) {
                if (MissingDeprecatedAnnotationInspection.this.warnOnMissingJavadoc && !this.hasDeprecatedComment(field, true)) {
                    this.registerFieldError(field, Boolean.FALSE);
                }
            } else if (this.hasDeprecatedComment(field, false)) {
                this.registerFieldError(field, Boolean.TRUE);
            }
        }

        private boolean hasDeprecatedAnnotation(PsiModifierListOwner element) {
            PsiModifierList modifierList = element.getModifierList();
            return modifierList != null && modifierList.findAnnotation("java.lang.Deprecated") != null;
        }

        private boolean hasDeprecatedComment(PsiJavaDocumentedElement element, boolean checkContent) {
            PsiDocComment comment = element.getDocComment();
            if (comment == null) {
                return false;
            }
            PsiDocTag deprecatedTag = comment.findTagByName("deprecated");
            if (deprecatedTag == null) {
                return false;
            }
            return !checkContent || deprecatedTag.getValueElement() != null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "module";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "aClass";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "method";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "field";
                    break;
                }
            }
            objectArray2[1] = "com/siyeh/ig/javadoc/MissingDeprecatedAnnotationInspection$MissingDeprecatedAnnotationVisitor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitModule";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitClass";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitMethod";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitField";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class MissingDeprecatedAnnotationFix
    extends InspectionGadgetsFix {
        private MissingDeprecatedAnnotationFix() {
        }

        @Override
        @NotNull
        public String getFamilyName() {
            String string = InspectionGadgetsBundle.message("missing.deprecated.annotation.add.quickfix", new Object[0]);
            if (string == null) {
                MissingDeprecatedAnnotationFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        @Override
        public void doFix(Project project, ProblemDescriptor descriptor2) {
            PsiElement identifier = descriptor2.getPsiElement();
            PsiModifierListOwner parent2 = (PsiModifierListOwner)identifier.getParent();
            if (parent2 == null) {
                return;
            }
            PsiElementFactory factory2 = JavaPsiFacade.getElementFactory(project);
            PsiAnnotation annotation2 = factory2.createAnnotationFromText("@java.lang.Deprecated", parent2);
            PsiModifierList modifierList = parent2.getModifierList();
            if (modifierList == null) {
                return;
            }
            modifierList.addAfter(annotation2, null);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/javadoc/MissingDeprecatedAnnotationInspection$MissingDeprecatedAnnotationFix", "getFamilyName"));
        }
    }
}

