/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.jdk;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.LambdaUtil;
import com.intellij.psi.PsiArrayAccessExpression;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiConditionalExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiMethodReferenceExpression;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiParenthesizedExpression;
import com.intellij.psi.PsiPostfixExpression;
import com.intellij.psi.PsiPrefixExpression;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeCastExpression;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.util.Query;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.PsiReplacementUtil;
import com.siyeh.ig.psiutils.ClassUtils;
import com.siyeh.ig.psiutils.ExpectedTypeUtils;
import com.siyeh.ig.psiutils.MethodCallUtils;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AutoUnboxingInspection
extends BaseInspection {
    @NonNls
    static final Map<String, String> s_unboxingMethods = new HashMap<String, String>(8);

    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("auto.unboxing.display.name", new Object[0]);
        if (string == null) {
            AutoUnboxingInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos2) {
        String string = InspectionGadgetsBundle.message("auto.unboxing.problem.descriptor", new Object[0]);
        if (string == null) {
            AutoUnboxingInspection.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Override
    @Nullable
    public InspectionGadgetsFix buildFix(Object ... infos2) {
        if (infos2.length == 0 || !AutoUnboxingInspection.isFixApplicable((PsiExpression)infos2[0])) {
            return null;
        }
        return new AutoUnboxingFix();
    }

    private static boolean isFixApplicable(PsiExpression location2) {
        PsiReferenceExpression reference;
        PsiElement parent2 = location2.getParent();
        if (!(parent2 instanceof PsiPostfixExpression)) {
            return true;
        }
        if (location2 instanceof PsiReferenceExpression) {
            reference = (PsiReferenceExpression)location2;
        } else if (location2 instanceof PsiArrayAccessExpression) {
            PsiArrayAccessExpression arrayAccessExpression = (PsiArrayAccessExpression)location2;
            PsiExpression expression2 = arrayAccessExpression.getArrayExpression();
            if (!(expression2 instanceof PsiReferenceExpression)) {
                return true;
            }
            reference = (PsiReferenceExpression)expression2;
        } else {
            return true;
        }
        PsiElement element = reference.resolve();
        if (element == null) {
            return true;
        }
        PsiStatement statement2 = PsiTreeUtil.getParentOfType(parent2, PsiStatement.class);
        LocalSearchScope scope = new LocalSearchScope(statement2);
        Query<PsiReference> query = ReferencesSearch.search(element, scope);
        Collection<PsiReference> references = query.findAll();
        return references.size() <= 1;
    }

    @Override
    public boolean shouldInspect(PsiFile file2) {
        return PsiUtil.isLanguageLevel5OrHigher(file2);
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new AutoUnboxingVisitor();
    }

    static {
        s_unboxingMethods.put("byte", "byteValue");
        s_unboxingMethods.put("short", "shortValue");
        s_unboxingMethods.put("int", "intValue");
        s_unboxingMethods.put("long", "longValue");
        s_unboxingMethods.put("float", "floatValue");
        s_unboxingMethods.put("double", "doubleValue");
        s_unboxingMethods.put("boolean", "booleanValue");
        s_unboxingMethods.put("char", "charValue");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/siyeh/ig/jdk/AutoUnboxingInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "buildErrorString";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    private static class AutoUnboxingVisitor
    extends BaseInspectionVisitor {
        private AutoUnboxingVisitor() {
        }

        @Override
        public void visitArrayAccessExpression(PsiArrayAccessExpression expression2) {
            super.visitArrayAccessExpression(expression2);
            this.checkExpression(expression2);
        }

        @Override
        public void visitConditionalExpression(PsiConditionalExpression expression2) {
            super.visitConditionalExpression(expression2);
            this.checkExpression(expression2);
        }

        @Override
        public void visitReferenceExpression(PsiReferenceExpression expression2) {
            super.visitReferenceExpression(expression2);
            if (expression2 instanceof PsiMethodReferenceExpression) {
                PsiMethodReferenceExpression methodReferenceExpression = (PsiMethodReferenceExpression)expression2;
                if (methodReferenceExpression.isConstructor()) {
                    return;
                }
                PsiElement referenceNameElement = methodReferenceExpression.getReferenceNameElement();
                if (referenceNameElement == null) {
                    return;
                }
                PsiElement target = methodReferenceExpression.resolve();
                if (!(target instanceof PsiMethod)) {
                    return;
                }
                PsiMethod method = (PsiMethod)target;
                PsiType returnType = method.getReturnType();
                if (!TypeConversionUtil.isAssignableFromPrimitiveWrapper(returnType)) {
                    return;
                }
                PsiPrimitiveType unboxedType = PsiPrimitiveType.getUnboxedType(returnType);
                if (unboxedType == null) {
                    return;
                }
                PsiType functionalInterfaceReturnType = LambdaUtil.getFunctionalInterfaceReturnType(methodReferenceExpression);
                if (functionalInterfaceReturnType == null || !ClassUtils.isPrimitive(functionalInterfaceReturnType) || !functionalInterfaceReturnType.isAssignableFrom(unboxedType)) {
                    return;
                }
                this.registerError(referenceNameElement, new Object[0]);
            } else {
                this.checkExpression(expression2);
            }
        }

        @Override
        public void visitNewExpression(PsiNewExpression expression2) {
            super.visitNewExpression(expression2);
            this.checkExpression(expression2);
        }

        @Override
        public void visitMethodCallExpression(PsiMethodCallExpression expression2) {
            super.visitMethodCallExpression(expression2);
            PsiMethod method = expression2.resolveMethod();
            if (method != null && AnnotationUtil.isAnnotated(method, Collections.singletonList("java.lang.invoke.MethodHandle.PolymorphicSignature"))) {
                return;
            }
            this.checkExpression(expression2);
        }

        @Override
        public void visitTypeCastExpression(PsiTypeCastExpression expression2) {
            super.visitTypeCastExpression(expression2);
            this.checkExpression(expression2);
        }

        @Override
        public void visitAssignmentExpression(PsiAssignmentExpression expression2) {
            super.visitAssignmentExpression(expression2);
            this.checkExpression(expression2);
        }

        @Override
        public void visitParenthesizedExpression(PsiParenthesizedExpression expression2) {
            super.visitParenthesizedExpression(expression2);
            this.checkExpression(expression2);
        }

        private void checkExpression(PsiExpression expression2) {
            PsiPrimitiveType unboxedType;
            if (expression2.getParent() instanceof PsiParenthesizedExpression) {
                return;
            }
            PsiType expressionType = expression2.getType();
            if (!TypeConversionUtil.isAssignableFromPrimitiveWrapper(expressionType)) {
                return;
            }
            PsiType expectedType2 = ExpectedTypeUtils.findExpectedType(expression2, false, true);
            if (!TypeConversionUtil.isPrimitiveAndNotNull(expectedType2)) {
                return;
            }
            if (!(expression2.getParent() instanceof PsiTypeCastExpression || (unboxedType = PsiPrimitiveType.getUnboxedType(expressionType)) != null && expectedType2.isAssignableFrom(unboxedType))) {
                return;
            }
            this.registerError((PsiElement)expression2, expression2);
        }
    }

    private static class AutoUnboxingFix
    extends InspectionGadgetsFix {
        private AutoUnboxingFix() {
        }

        @Override
        @NotNull
        public String getFamilyName() {
            String string = InspectionGadgetsBundle.message("auto.unboxing.make.unboxing.explicit.quickfix", new Object[0]);
            if (string == null) {
                AutoUnboxingFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        @Override
        public void doFix(Project project, ProblemDescriptor descriptor2) {
            PsiExpression expression2 = (PsiExpression)descriptor2.getPsiElement();
            PsiType type2 = expression2.getType();
            if (type2 == null) {
                return;
            }
            PsiPrimitiveType unboxedType = (PsiPrimitiveType)ExpectedTypeUtils.findExpectedType(expression2, false, true);
            if (unboxedType == null) {
                return;
            }
            String newExpressionText = AutoUnboxingFix.buildNewExpressionText(expression2, unboxedType);
            JavaPsiFacade psiFacade = JavaPsiFacade.getInstance(project);
            PsiElementFactory factory2 = psiFacade.getElementFactory();
            PsiElement parent2 = expression2.getParent();
            String expressionText = expression2.getText();
            if (parent2 instanceof PsiTypeCastExpression) {
                PsiTypeCastExpression typeCastExpression = (PsiTypeCastExpression)parent2;
                PsiReplacementUtil.replaceExpression(typeCastExpression, newExpressionText);
            } else if (parent2 instanceof PsiPrefixExpression && !unboxedType.equalsToText("boolean")) {
                PsiPrefixExpression prefixExpression = (PsiPrefixExpression)parent2;
                IElementType tokenType = prefixExpression.getOperationTokenType();
                if (JavaTokenType.PLUSPLUS.equals(tokenType)) {
                    PsiReplacementUtil.replaceExpression(prefixExpression, expressionText + '=' + newExpressionText + "+1");
                } else if (JavaTokenType.MINUSMINUS.equals(tokenType)) {
                    PsiReplacementUtil.replaceExpression(prefixExpression, expressionText + '=' + newExpressionText + "-1");
                } else {
                    PsiReplacementUtil.replaceExpression(prefixExpression, prefixExpression.getOperationSign().getText() + newExpressionText);
                }
            } else if (parent2 instanceof PsiPostfixExpression) {
                PsiPostfixExpression postfixExpression = (PsiPostfixExpression)parent2;
                IElementType tokenType = postfixExpression.getOperationTokenType();
                PsiElement grandParent = postfixExpression.getParent();
                if (grandParent instanceof PsiExpressionStatement) {
                    if (JavaTokenType.PLUSPLUS.equals(tokenType)) {
                        PsiReplacementUtil.replaceExpression(postfixExpression, expressionText + '=' + newExpressionText + "+1");
                    } else if (JavaTokenType.MINUSMINUS.equals(tokenType)) {
                        PsiReplacementUtil.replaceExpression(postfixExpression, expressionText + '=' + newExpressionText + "-1");
                    }
                } else {
                    PsiElement element = postfixExpression.replace(postfixExpression.getOperand());
                    PsiStatement statement2 = PsiTreeUtil.getParentOfType(element, PsiStatement.class);
                    if (statement2 == null) {
                        return;
                    }
                    PsiStatement newStatement = JavaTokenType.PLUSPLUS.equals(tokenType) ? factory2.createStatementFromText(expressionText + '=' + newExpressionText + "+1;", statement2) : factory2.createStatementFromText(expressionText + '=' + newExpressionText + "-1;", statement2);
                    PsiElement greatGrandParent = statement2.getParent();
                    greatGrandParent.addAfter(newStatement, statement2);
                }
            } else if (parent2 instanceof PsiAssignmentExpression) {
                PsiAssignmentExpression assignmentExpression = (PsiAssignmentExpression)parent2;
                PsiExpression lExpression = assignmentExpression.getLExpression();
                if (expression2.equals(lExpression)) {
                    PsiJavaToken operationSign = assignmentExpression.getOperationSign();
                    String operationSignText = operationSign.getText();
                    char sign = operationSignText.charAt(0);
                    PsiExpression rExpression = assignmentExpression.getRExpression();
                    if (rExpression == null) {
                        return;
                    }
                    String text2 = lExpression.getText() + '=' + newExpressionText + sign + rExpression.getText();
                    PsiExpression newExpression = factory2.createExpressionFromText(text2, assignmentExpression);
                    assignmentExpression.replace(newExpression);
                } else {
                    PsiReplacementUtil.replaceExpression(expression2, newExpressionText);
                }
            } else {
                PsiReplacementUtil.replaceExpression(expression2, newExpressionText);
            }
        }

        private static String buildNewExpressionText(PsiExpression expression2, PsiPrimitiveType unboxedType) {
            PsiMethodCallExpression methodCallExpression;
            String unboxedTypeText = unboxedType.getCanonicalText();
            String expressionText = expression2.getText();
            String boxMethodName = s_unboxingMethods.get(unboxedTypeText);
            if (expression2 instanceof PsiTypeCastExpression) {
                return '(' + expressionText + ")." + boxMethodName + "()";
            }
            String constantText = AutoUnboxingFix.computeConstantBooleanText(expression2);
            if (constantText != null) {
                return constantText;
            }
            if (expression2 instanceof PsiMethodCallExpression && AutoUnboxingFix.isValueOfCall(methodCallExpression = (PsiMethodCallExpression)expression2)) {
                PsiExpressionList argumentList2 = methodCallExpression.getArgumentList();
                PsiExpression[] arguments2 = argumentList2.getExpressions();
                PsiExpression argument = arguments2[0];
                return argument.getText();
            }
            PsiType type2 = expression2.getType();
            if (type2 != null && type2.equalsToText("java.lang.Object")) {
                return "((" + unboxedType.getBoxedTypeName() + ')' + expressionText + ")." + boxMethodName + "()";
            }
            return expressionText + '.' + boxMethodName + "()";
        }

        private static boolean isValueOfCall(PsiMethodCallExpression methodCallExpression) {
            PsiExpressionList argumentList2 = methodCallExpression.getArgumentList();
            PsiExpression[] arguments2 = argumentList2.getExpressions();
            if (arguments2.length != 1) {
                return false;
            }
            PsiExpression argument = arguments2[0];
            PsiType type2 = argument.getType();
            return MethodCallUtils.isCallToMethod(methodCallExpression, "java.lang.Integer", null, "valueOf", PsiType.INT) && PsiType.INT.equals(type2) || MethodCallUtils.isCallToMethod(methodCallExpression, "java.lang.Short", null, "valueOf", PsiType.SHORT) && PsiType.SHORT.equals(type2) || MethodCallUtils.isCallToMethod(methodCallExpression, "java.lang.Byte", null, "valueOf", PsiType.BYTE) && PsiType.BYTE.equals(type2) || MethodCallUtils.isCallToMethod(methodCallExpression, "java.lang.Long", null, "valueOf", PsiType.LONG) && PsiType.LONG.equals(type2) || MethodCallUtils.isCallToMethod(methodCallExpression, "java.lang.Character", null, "valueOf", PsiType.CHAR) && PsiType.CHAR.equals(type2) || MethodCallUtils.isCallToMethod(methodCallExpression, "java.lang.Double", null, "valueOf", PsiType.DOUBLE) && PsiType.DOUBLE.equals(type2) || MethodCallUtils.isCallToMethod(methodCallExpression, "java.lang.Float", null, "valueOf", PsiType.FLOAT) && PsiType.FLOAT.equals(type2);
        }

        @NonNls
        private static String computeConstantBooleanText(PsiExpression expression2) {
            if (!(expression2 instanceof PsiReferenceExpression)) {
                return null;
            }
            PsiReferenceExpression referenceExpression = (PsiReferenceExpression)expression2;
            PsiElement target = referenceExpression.resolve();
            if (!(target instanceof PsiField)) {
                return null;
            }
            PsiField field = (PsiField)target;
            PsiClass containingClass = field.getContainingClass();
            if (containingClass == null) {
                return null;
            }
            String qualifiedName2 = containingClass.getQualifiedName();
            if (!"java.lang.Boolean".equals(qualifiedName2)) {
                return null;
            }
            String name = field.getName();
            if ("TRUE".equals(name)) {
                return "true";
            }
            if ("FALSE".equals(name)) {
                return "false";
            }
            return null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/jdk/AutoUnboxingInspection$AutoUnboxingFix", "getFamilyName"));
        }
    }
}

