/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.jdk;

import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.GenericsUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiBlockStatement;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiForeachStatement;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.codeStyle.JavaCodeStyleSettingsFacade;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.util.IncorrectOperationException;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.PsiReplacementUtil;
import com.siyeh.ig.psiutils.ParenthesesUtils;
import org.jetbrains.annotations.NotNull;

public class ForeachStatementInspection
extends BaseInspection {
    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("extended.for.statement.display.name", new Object[0]);
        if (string == null) {
            ForeachStatementInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos2) {
        String string = InspectionGadgetsBundle.message("extended.for.statement.problem.descriptor", new Object[0]);
        if (string == null) {
            ForeachStatementInspection.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Override
    protected InspectionGadgetsFix buildFix(Object ... infos2) {
        return new ForEachFix();
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new ForeachStatementVisitor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/siyeh/ig/jdk/ForeachStatementInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "buildErrorString";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    private static class ForeachStatementVisitor
    extends BaseInspectionVisitor {
        private ForeachStatementVisitor() {
        }

        @Override
        public void visitForeachStatement(@NotNull PsiForeachStatement statement2) {
            if (statement2 == null) {
                ForeachStatementVisitor.$$$reportNull$$$0(0);
            }
            super.visitForeachStatement(statement2);
            PsiExpression iteratedValue = statement2.getIteratedValue();
            if (iteratedValue == null || !InheritanceUtil.isInheritor(iteratedValue.getType(), "java.lang.Iterable")) {
                return;
            }
            this.registerStatementError(statement2, new Object[0]);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "statement", "com/siyeh/ig/jdk/ForeachStatementInspection$ForeachStatementVisitor", "visitForeachStatement"));
        }
    }

    private static class ForEachFix
    extends InspectionGadgetsFix {
        private ForEachFix() {
        }

        @Override
        @NotNull
        public String getFamilyName() {
            String string = InspectionGadgetsBundle.message("extended.for.statement.replace.quickfix", new Object[0]);
            if (string == null) {
                ForEachFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        @Override
        public void doFix(Project project, ProblemDescriptor descriptor2) throws IncorrectOperationException {
            PsiElement element = descriptor2.getPsiElement();
            PsiForeachStatement statement2 = (PsiForeachStatement)element.getParent();
            JavaCodeStyleManager codeStyleManager = JavaCodeStyleManager.getInstance(project);
            assert (statement2 != null);
            PsiExpression iteratedValue = statement2.getIteratedValue();
            if (iteratedValue == null) {
                return;
            }
            StringBuilder newStatement = new StringBuilder();
            PsiParameter iterationParameter = statement2.getIterationParameter();
            boolean generateFinalLocals = JavaCodeStyleSettingsFacade.getInstance(project).isGenerateFinalLocals();
            if (iteratedValue.getType() instanceof PsiArrayType) {
                PsiType type2 = iterationParameter.getType();
                String index2 = codeStyleManager.suggestUniqueVariableName("i", (PsiElement)statement2, true);
                newStatement.append("for(int ").append(index2).append(" = 0;");
                newStatement.append(index2).append('<').append(iteratedValue.getText()).append(".length;");
                newStatement.append(index2).append("++)").append("{ ");
                if (generateFinalLocals) {
                    newStatement.append("final ");
                }
                newStatement.append(type2.getCanonicalText()).append(' ').append(iterationParameter.getName());
                newStatement.append(" = ").append(iteratedValue.getText()).append('[').append(index2).append("];");
            } else {
                StringBuilder methodCall = new StringBuilder();
                if (ParenthesesUtils.getPrecedence(iteratedValue) > 1) {
                    methodCall.append('(').append(iteratedValue.getText()).append(')');
                } else {
                    methodCall.append(iteratedValue.getText());
                }
                methodCall.append(".iterator()");
                PsiElementFactory factory2 = JavaPsiFacade.getInstance(project).getElementFactory();
                PsiExpression iteratorCall = factory2.createExpressionFromText(methodCall.toString(), iteratedValue);
                PsiType variableType = GenericsUtil.getVariableTypeByExpressionType(iteratorCall.getType());
                if (variableType == null) {
                    return;
                }
                PsiType parameterType = iterationParameter.getType();
                String typeText = parameterType.getCanonicalText();
                newStatement.append("for(").append(variableType.getCanonicalText()).append(' ');
                String iterator2 = codeStyleManager.suggestUniqueVariableName("iterator", (PsiElement)statement2, true);
                newStatement.append(iterator2).append("=").append(iteratorCall.getText()).append(';');
                newStatement.append(iterator2).append(".hasNext();){");
                if (generateFinalLocals) {
                    newStatement.append("final ");
                }
                newStatement.append(typeText).append(' ').append(iterationParameter.getName()).append(" = ").append(iterator2).append(".next();");
            }
            PsiStatement body = statement2.getBody();
            if (body instanceof PsiBlockStatement) {
                PsiBlockStatement blockStatement = (PsiBlockStatement)body;
                PsiCodeBlock block = blockStatement.getCodeBlock();
                PsiElement[] children2 = block.getChildren();
                for (int i = 1; i < children2.length - 1; ++i) {
                    newStatement.append(children2[i].getText());
                }
            } else {
                String bodyText = body == null ? "" : body.getText();
                newStatement.append(bodyText);
            }
            newStatement.append('}');
            PsiReplacementUtil.replaceStatementAndShortenClassNames(statement2, newStatement.toString());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/jdk/ForeachStatementInspection$ForEachFix", "getFamilyName"));
        }
    }
}

