/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.junit;

import com.intellij.codeInspection.AnnotateMethodFix;
import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.DelegatingFix;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.psiutils.TestUtils;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JUnit3StyleTestMethodInJUnit4ClassInspection
extends BaseInspection {
    @Override
    @Nls
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("junit3.style.test.method.in.junit4.class.display.name", new Object[0]);
        if (string == null) {
            JUnit3StyleTestMethodInJUnit4ClassInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos2) {
        String string = InspectionGadgetsBundle.message("junit3.style.test.method.in.junit4.class.problem.descriptor", new Object[0]);
        if (string == null) {
            JUnit3StyleTestMethodInJUnit4ClassInspection.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Override
    @Nullable
    protected InspectionGadgetsFix buildFix(Object ... infos2) {
        return new DelegatingFix(new AnnotateMethodFix("org.junit.Test", new String[0]));
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new JUnit3StyleTestMethodInJUnit4ClassInspectionVisitor();
    }

    public static boolean containsJUnit4Annotation(PsiElement element) {
        JUnit4AnnotationVisitor visitor2 = new JUnit4AnnotationVisitor();
        element.accept(visitor2);
        return visitor2.isJUnit4AnnotationFound();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/siyeh/ig/junit/JUnit3StyleTestMethodInJUnit4ClassInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "buildErrorString";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    private static class JUnit4AnnotationVisitor
    extends JavaRecursiveElementWalkingVisitor {
        private boolean myJUnit4AnnotationFound = false;

        private JUnit4AnnotationVisitor() {
        }

        @Override
        public void visitAnnotation(PsiAnnotation annotation2) {
            super.visitAnnotation(annotation2);
            String qualifiedName2 = annotation2.getQualifiedName();
            if (qualifiedName2 == null || !qualifiedName2.startsWith("org.junit.")) {
                return;
            }
            this.myJUnit4AnnotationFound = true;
        }

        public boolean isJUnit4AnnotationFound() {
            return this.myJUnit4AnnotationFound;
        }
    }

    private static class JUnit3StyleTestMethodInJUnit4ClassInspectionVisitor
    extends BaseInspectionVisitor {
        private JUnit3StyleTestMethodInJUnit4ClassInspectionVisitor() {
        }

        @Override
        public void visitMethod(PsiMethod method) {
            super.visitMethod(method);
            String name = method.getName();
            if (!name.startsWith("test")) {
                return;
            }
            if (!TestUtils.isRunnable(method)) {
                return;
            }
            if (TestUtils.isAnnotatedTestMethod(method)) {
                return;
            }
            PsiClass containingClass = method.getContainingClass();
            if (TestUtils.isJUnitTestClass(containingClass)) {
                return;
            }
            if (!JUnit3StyleTestMethodInJUnit4ClassInspection.containsJUnit4Annotation(containingClass)) {
                return;
            }
            this.registerMethodError(method, new Object[0]);
        }
    }
}

