/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.junit;

import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.util.InheritanceUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import org.jetbrains.annotations.NotNull;

public class StaticSuiteInspection
extends BaseInspection {
    @Override
    @NotNull
    public String getID() {
        if ("SuiteNotDeclaredStatic" == null) {
            StaticSuiteInspection.$$$reportNull$$$0(0);
        }
        return "SuiteNotDeclaredStatic";
    }

    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("static.suite.display.name", new Object[0]);
        if (string == null) {
            StaticSuiteInspection.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos2) {
        String string = InspectionGadgetsBundle.message("static.suite.problem.descriptor", new Object[0]);
        if (string == null) {
            StaticSuiteInspection.$$$reportNull$$$0(2);
        }
        return string;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new StaticSuiteVisitor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/siyeh/ig/junit/StaticSuiteInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getID";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "buildErrorString";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    private static class StaticSuiteVisitor
    extends BaseInspectionVisitor {
        private StaticSuiteVisitor() {
        }

        @Override
        public void visitMethod(@NotNull PsiMethod method) {
            String methodName;
            if (method == null) {
                StaticSuiteVisitor.$$$reportNull$$$0(0);
            }
            if (!"suite".equals(methodName = method.getName())) {
                return;
            }
            PsiClass aClass2 = method.getContainingClass();
            if (aClass2 == null) {
                return;
            }
            if (!InheritanceUtil.isInheritor(aClass2, "junit.framework.TestCase")) {
                return;
            }
            PsiParameterList parameterList = method.getParameterList();
            if (parameterList.getParametersCount() != 0) {
                return;
            }
            if (method.hasModifierProperty("static")) {
                return;
            }
            this.registerMethodError(method, new Object[0]);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "com/siyeh/ig/junit/StaticSuiteInspection$StaticSuiteVisitor", "visitMethod"));
        }
    }
}

