/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.methodmetrics;

import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiType;
import com.intellij.util.ui.CheckBox;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.methodmetrics.MethodMetricInspection;
import com.siyeh.ig.methodmetrics.ReturnPointCountVisitor;
import com.siyeh.ig.psiutils.ControlFlowUtils;
import com.siyeh.ig.psiutils.MethodUtils;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import javax.swing.JComponent;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;

public class MultipleReturnPointsPerMethodInspection
extends MethodMetricInspection {
    public boolean ignoreGuardClauses = false;
    public boolean ignoreEqualsMethod = false;

    @Override
    @NotNull
    public String getID() {
        if ("MethodWithMultipleReturnPoints" == null) {
            MultipleReturnPointsPerMethodInspection.$$$reportNull$$$0(0);
        }
        return "MethodWithMultipleReturnPoints";
    }

    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("multiple.return.points.per.method.display.name", new Object[0]);
        if (string == null) {
            MultipleReturnPointsPerMethodInspection.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Override
    protected int getDefaultLimit() {
        return 1;
    }

    @Override
    protected String getConfigurationLabel() {
        return InspectionGadgetsBundle.message("return.point.limit.option", new Object[0]);
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos2) {
        Integer returnPointCount = (Integer)infos2[0];
        String string = InspectionGadgetsBundle.message("multiple.return.points.per.method.problem.descriptor", returnPointCount);
        if (string == null) {
            MultipleReturnPointsPerMethodInspection.$$$reportNull$$$0(2);
        }
        return string;
    }

    @Override
    public JComponent createOptionsPanel() {
        JPanel panel = new JPanel(new GridBagLayout());
        JLabel label = new JLabel(InspectionGadgetsBundle.message("return.point.limit.option", new Object[0]));
        JFormattedTextField termLimitTextField = this.prepareNumberEditor("m_limit");
        CheckBox ignoreGuardClausesCheckBox = new CheckBox(InspectionGadgetsBundle.message("ignore.guard.clauses.option", new Object[0]), this, "ignoreGuardClauses");
        CheckBox ignoreEqualsMethodCheckBox = new CheckBox(InspectionGadgetsBundle.message("ignore.for.equals.methods.option", new Object[0]), this, "ignoreEqualsMethod");
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.anchor = 512;
        constraints.fill = 2;
        constraints.gridx = 0;
        constraints.gridy = 0;
        panel.add((Component)label, constraints);
        constraints.fill = 0;
        constraints.gridx = 1;
        panel.add((Component)termLimitTextField, constraints);
        constraints.gridx = 0;
        constraints.gridy = 1;
        constraints.gridwidth = 2;
        constraints.weightx = 1.0;
        panel.add((Component)ignoreGuardClausesCheckBox, constraints);
        constraints.gridy = 2;
        constraints.weighty = 1.0;
        panel.add((Component)ignoreEqualsMethodCheckBox, constraints);
        return panel;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new MultipleReturnPointsPerMethodVisitor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/siyeh/ig/methodmetrics/MultipleReturnPointsPerMethodInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getID";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "buildErrorString";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    private class MultipleReturnPointsPerMethodVisitor
    extends BaseInspectionVisitor {
        private MultipleReturnPointsPerMethodVisitor() {
        }

        @Override
        public void visitMethod(@NotNull PsiMethod method) {
            if (method == null) {
                MultipleReturnPointsPerMethodVisitor.$$$reportNull$$$0(0);
            }
            if (method.getNameIdentifier() == null) {
                return;
            }
            if (MultipleReturnPointsPerMethodInspection.this.ignoreEqualsMethod && MethodUtils.isEquals(method)) {
                return;
            }
            int returnPointCount = this.calculateReturnPointCount(method);
            if (returnPointCount <= MultipleReturnPointsPerMethodInspection.this.getLimit()) {
                return;
            }
            this.registerMethodError(method, returnPointCount);
        }

        private int calculateReturnPointCount(PsiMethod method) {
            ReturnPointCountVisitor visitor2 = new ReturnPointCountVisitor(MultipleReturnPointsPerMethodInspection.this.ignoreGuardClauses);
            method.accept(visitor2);
            int count2 = visitor2.getCount();
            if (!this.mayFallThroughBottom(method)) {
                return count2;
            }
            PsiStatement lastStatement = ControlFlowUtils.getLastStatementInBlock(method.getBody());
            if (ControlFlowUtils.statementMayCompleteNormally(lastStatement)) {
                return count2 + 1;
            }
            return count2;
        }

        private boolean mayFallThroughBottom(PsiMethod method) {
            if (method.isConstructor()) {
                return true;
            }
            PsiType returnType = method.getReturnType();
            return PsiType.VOID.equals(returnType);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "com/siyeh/ig/methodmetrics/MultipleReturnPointsPerMethodInspection$MultipleReturnPointsPerMethodVisitor", "visitMethod"));
        }
    }
}

