/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.methodmetrics;

import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiBlockStatement;
import com.intellij.psi.PsiDoWhileStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiForStatement;
import com.intellij.psi.PsiIfStatement;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiSwitchStatement;
import com.intellij.psi.PsiSynchronizedStatement;
import com.intellij.psi.PsiTryStatement;
import com.intellij.psi.PsiWhileStatement;
import gnu.trove.THashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

class NestingDepthVisitor
extends JavaRecursiveElementWalkingVisitor {
    private final int myLimit;
    private int m_maximumDepth;
    private int m_currentDepth;
    private final Set<PsiElement> scopeEntered = new THashSet<PsiElement>();

    public NestingDepthVisitor(int limit) {
        this.myLimit = limit;
    }

    @Override
    public void visitAnonymousClass(@NotNull PsiAnonymousClass aClass2) {
        if (aClass2 == null) {
            NestingDepthVisitor.$$$reportNull$$$0(0);
        }
    }

    @Override
    public void visitBlockStatement(PsiBlockStatement statement2) {
        boolean isAlreadyCounted;
        PsiElement parent2 = statement2.getParent();
        boolean bl = isAlreadyCounted = parent2 instanceof PsiDoWhileStatement || parent2 instanceof PsiWhileStatement || parent2 instanceof PsiForStatement || parent2 instanceof PsiIfStatement || parent2 instanceof PsiSynchronizedStatement;
        if (!isAlreadyCounted) {
            this.enterScope(statement2);
        }
        super.visitBlockStatement(statement2);
    }

    @Override
    public void visitDoWhileStatement(@NotNull PsiDoWhileStatement statement2) {
        if (statement2 == null) {
            NestingDepthVisitor.$$$reportNull$$$0(1);
        }
        this.enterScope(statement2);
        super.visitDoWhileStatement(statement2);
    }

    @Override
    public void visitForStatement(@NotNull PsiForStatement statement2) {
        if (statement2 == null) {
            NestingDepthVisitor.$$$reportNull$$$0(2);
        }
        this.enterScope(statement2);
        super.visitForStatement(statement2);
    }

    @Override
    public void visitIfStatement(@NotNull PsiIfStatement statement2) {
        PsiStatement elseBranch;
        if (statement2 == null) {
            NestingDepthVisitor.$$$reportNull$$$0(3);
        }
        boolean isAlreadyCounted = false;
        PsiElement parent2 = statement2.getParent();
        if (parent2 instanceof PsiIfStatement && statement2.equals(elseBranch = ((PsiIfStatement)parent2).getElseBranch())) {
            isAlreadyCounted = true;
        }
        if (!isAlreadyCounted) {
            this.enterScope(statement2);
        }
        super.visitIfStatement(statement2);
    }

    @Override
    public void visitSynchronizedStatement(@NotNull PsiSynchronizedStatement statement2) {
        if (statement2 == null) {
            NestingDepthVisitor.$$$reportNull$$$0(4);
        }
        this.enterScope(statement2);
        super.visitSynchronizedStatement(statement2);
    }

    @Override
    public void visitTryStatement(@NotNull PsiTryStatement statement2) {
        if (statement2 == null) {
            NestingDepthVisitor.$$$reportNull$$$0(5);
        }
        this.enterScope(statement2);
        super.visitTryStatement(statement2);
    }

    @Override
    public void visitSwitchStatement(@NotNull PsiSwitchStatement statement2) {
        if (statement2 == null) {
            NestingDepthVisitor.$$$reportNull$$$0(6);
        }
        this.enterScope(statement2);
        super.visitSwitchStatement(statement2);
    }

    @Override
    public void visitWhileStatement(@NotNull PsiWhileStatement statement2) {
        if (statement2 == null) {
            NestingDepthVisitor.$$$reportNull$$$0(7);
        }
        this.enterScope(statement2);
        super.visitWhileStatement(statement2);
    }

    @Override
    protected void elementFinished(@NotNull PsiElement element) {
        if (element == null) {
            NestingDepthVisitor.$$$reportNull$$$0(8);
        }
        this.exitScope(element);
    }

    private void enterScope(PsiElement element) {
        this.scopeEntered.add(element);
        ++this.m_currentDepth;
        this.m_maximumDepth = Math.max(this.m_maximumDepth, this.m_currentDepth);
        if (this.m_maximumDepth > this.myLimit) {
            this.stopWalking();
        }
    }

    private void exitScope(PsiElement element) {
        if (this.scopeEntered.remove(element)) {
            --this.m_currentDepth;
        }
    }

    int getMaximumDepth() {
        return this.m_maximumDepth;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aClass";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "statement";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        objectArray2[1] = "com/siyeh/ig/methodmetrics/NestingDepthVisitor";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "visitAnonymousClass";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "visitDoWhileStatement";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "visitForStatement";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "visitIfStatement";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "visitSynchronizedStatement";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "visitTryStatement";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "visitSwitchStatement";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "visitWhileStatement";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "elementFinished";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

