/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.methodmetrics;

import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameterList;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.methodmetrics.MethodMetricInspection;
import org.jetbrains.annotations.NotNull;

public class ParametersPerMethodInspection
extends MethodMetricInspection {
    @Override
    @NotNull
    public String getID() {
        if ("MethodWithTooManyParameters" == null) {
            ParametersPerMethodInspection.$$$reportNull$$$0(0);
        }
        return "MethodWithTooManyParameters";
    }

    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("parameters.per.method.display.name", new Object[0]);
        if (string == null) {
            ParametersPerMethodInspection.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos2) {
        Integer parameterCount = (Integer)infos2[0];
        String string = InspectionGadgetsBundle.message("parameters.per.method.problem.descriptor", parameterCount);
        if (string == null) {
            ParametersPerMethodInspection.$$$reportNull$$$0(2);
        }
        return string;
    }

    @Override
    protected int getDefaultLimit() {
        return 5;
    }

    @Override
    protected String getConfigurationLabel() {
        return InspectionGadgetsBundle.message("parameter.limit.option", new Object[0]);
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new ParametersPerMethodVisitor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/siyeh/ig/methodmetrics/ParametersPerMethodInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getID";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "buildErrorString";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    private class ParametersPerMethodVisitor
    extends BaseInspectionVisitor {
        private ParametersPerMethodVisitor() {
        }

        @Override
        public void visitMethod(@NotNull PsiMethod method) {
            if (method == null) {
                ParametersPerMethodVisitor.$$$reportNull$$$0(0);
            }
            if (method.getNameIdentifier() == null) {
                return;
            }
            if (method.isConstructor()) {
                return;
            }
            PsiParameterList parameterList = method.getParameterList();
            int parametersCount = parameterList.getParametersCount();
            if (parametersCount <= ParametersPerMethodInspection.this.getLimit()) {
                return;
            }
            if (method.findDeepestSuperMethods().length > 0) {
                return;
            }
            this.registerMethodError(method, parametersCount);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "com/siyeh/ig/methodmetrics/ParametersPerMethodInspection$ParametersPerMethodVisitor", "visitMethod"));
        }
    }
}

