/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.methodmetrics;

import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiReferenceList;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.methodmetrics.MethodMetricInspection;
import org.jetbrains.annotations.NotNull;

public class ThrownExceptionsPerMethodInspection
extends MethodMetricInspection {
    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("thrown.exceptions.per.method.display.name", new Object[0]);
        if (string == null) {
            ThrownExceptionsPerMethodInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    @NotNull
    public String getID() {
        if ("MethodWithTooExceptionsDeclared" == null) {
            ThrownExceptionsPerMethodInspection.$$$reportNull$$$0(1);
        }
        return "MethodWithTooExceptionsDeclared";
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos2) {
        Integer exceptionCount = (Integer)infos2[0];
        String string = InspectionGadgetsBundle.message("thrown.exceptions.per.method.problem.descriptor", exceptionCount);
        if (string == null) {
            ThrownExceptionsPerMethodInspection.$$$reportNull$$$0(2);
        }
        return string;
    }

    @Override
    protected int getDefaultLimit() {
        return 3;
    }

    @Override
    protected String getConfigurationLabel() {
        return InspectionGadgetsBundle.message("thrown.exceptions.per.method.limit.option", new Object[0]);
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new ThrownExceptionsPerMethodVisitor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/siyeh/ig/methodmetrics/ThrownExceptionsPerMethodInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getID";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "buildErrorString";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    private class ThrownExceptionsPerMethodVisitor
    extends BaseInspectionVisitor {
        private ThrownExceptionsPerMethodVisitor() {
        }

        @Override
        public void visitMethod(@NotNull PsiMethod method) {
            if (method == null) {
                ThrownExceptionsPerMethodVisitor.$$$reportNull$$$0(0);
            }
            if (method.getNameIdentifier() == null) {
                return;
            }
            PsiReferenceList throwList = method.getThrowsList();
            PsiJavaCodeReferenceElement[] thrownExceptions = throwList.getReferenceElements();
            int exceptionCount = thrownExceptions.length;
            if (exceptionCount <= ThrownExceptionsPerMethodInspection.this.getLimit()) {
                return;
            }
            this.registerMethodError(method, exceptionCount);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "com/siyeh/ig/methodmetrics/ThrownExceptionsPerMethodInspection$ThrownExceptionsPerMethodVisitor", "visitMethod"));
        }
    }
}

