/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.migration;

import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.psiutils.TypeUtils;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class EnumerationCanBeIterationInspectionBase
extends BaseInspection {
    static final int KEEP_NOTHING = 0;
    static final int KEEP_INITIALIZATION = 1;
    static final int KEEP_DECLARATION = 2;
    @NonNls
    static final String ITERATOR_TEXT = "iterator()";
    @NonNls
    static final String KEY_SET_ITERATOR_TEXT = "keySet().iterator()";
    @NonNls
    static final String VALUES_ITERATOR_TEXT = "values().iterator()";

    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("enumeration.can.be.iteration.display.name", new Object[0]);
        if (string == null) {
            EnumerationCanBeIterationInspectionBase.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos2) {
        String string = InspectionGadgetsBundle.message("enumeration.can.be.iteration.problem.descriptor", infos2[0]);
        if (string == null) {
            EnumerationCanBeIterationInspectionBase.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new EnumerationCanBeIterationVisitor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/siyeh/ig/migration/EnumerationCanBeIterationInspectionBase";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "buildErrorString";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    private static class EnumerationCanBeIterationVisitor
    extends BaseInspectionVisitor {
        private EnumerationCanBeIterationVisitor() {
        }

        @Override
        public void visitMethodCallExpression(PsiMethodCallExpression expression2) {
            PsiClass containingClass;
            PsiMethod method;
            PsiVariable variable2;
            boolean isElements;
            super.visitMethodCallExpression(expression2);
            PsiReferenceExpression methodExpression = expression2.getMethodExpression();
            String methodName = methodExpression.getReferenceName();
            if ("elements".equals(methodName)) {
                isElements = true;
            } else if ("keys".equals(methodName)) {
                isElements = false;
            } else {
                return;
            }
            if (!TypeUtils.expressionHasTypeOrSubtype((PsiExpression)expression2, "java.util.Enumeration")) {
                return;
            }
            PsiElement parent2 = expression2.getParent();
            if (parent2 instanceof PsiLocalVariable) {
                variable2 = (PsiVariable)parent2;
            } else if (parent2 instanceof PsiAssignmentExpression) {
                PsiAssignmentExpression assignmentExpression = (PsiAssignmentExpression)parent2;
                PsiExpression lhs = assignmentExpression.getLExpression();
                if (!(lhs instanceof PsiReferenceExpression)) {
                    return;
                }
                PsiReferenceExpression referenceExpression = (PsiReferenceExpression)lhs;
                PsiElement element = referenceExpression.resolve();
                if (!(element instanceof PsiVariable)) {
                    return;
                }
                variable2 = (PsiVariable)element;
            } else {
                return;
            }
            PsiMethod containingMethod = PsiTreeUtil.getParentOfType((PsiElement)expression2, PsiMethod.class);
            if (containingMethod == null) {
                return;
            }
            if (!EnumerationCanBeIterationVisitor.isEnumerationMethodCalled(variable2, containingMethod)) {
                return;
            }
            if (isElements) {
                method = expression2.resolveMethod();
                if (method == null) {
                    return;
                }
                containingClass = method.getContainingClass();
                if (InheritanceUtil.isInheritor(containingClass, "java.util.Vector")) {
                    this.registerMethodCallError(expression2, EnumerationCanBeIterationInspectionBase.ITERATOR_TEXT);
                } else if (InheritanceUtil.isInheritor(containingClass, "java.util.Hashtable")) {
                    this.registerMethodCallError(expression2, EnumerationCanBeIterationInspectionBase.VALUES_ITERATOR_TEXT);
                }
            } else {
                method = expression2.resolveMethod();
                if (method == null) {
                    return;
                }
                containingClass = method.getContainingClass();
                if (InheritanceUtil.isInheritor(containingClass, "java.util.Hashtable")) {
                    this.registerMethodCallError(expression2, EnumerationCanBeIterationInspectionBase.KEY_SET_ITERATOR_TEXT);
                }
            }
        }

        private static boolean isEnumerationMethodCalled(@NotNull PsiVariable variable2, @NotNull PsiElement context) {
            if (variable2 == null) {
                EnumerationCanBeIterationVisitor.$$$reportNull$$$0(0);
            }
            if (context == null) {
                EnumerationCanBeIterationVisitor.$$$reportNull$$$0(1);
            }
            EnumerationMethodCalledVisitor visitor2 = new EnumerationMethodCalledVisitor(variable2);
            context.accept(visitor2);
            return visitor2.isEnumerationMethodCalled();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "variable";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "context";
                    break;
                }
            }
            objectArray[1] = "com/siyeh/ig/migration/EnumerationCanBeIterationInspectionBase$EnumerationCanBeIterationVisitor";
            objectArray[2] = "isEnumerationMethodCalled";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }

        private static class EnumerationMethodCalledVisitor
        extends JavaRecursiveElementWalkingVisitor {
            private final PsiVariable variable;
            private boolean enumerationMethodCalled;

            private EnumerationMethodCalledVisitor(@NotNull PsiVariable variable2) {
                if (variable2 == null) {
                    EnumerationMethodCalledVisitor.$$$reportNull$$$0(0);
                }
                this.variable = variable2;
            }

            @Override
            public void visitMethodCallExpression(PsiMethodCallExpression expression2) {
                if (this.enumerationMethodCalled) {
                    return;
                }
                super.visitMethodCallExpression(expression2);
                PsiReferenceExpression methodExpression = expression2.getMethodExpression();
                String methodName = methodExpression.getReferenceName();
                if (!"hasMoreElements".equals(methodName) && !"nextElement".equals(methodName)) {
                    return;
                }
                PsiExpression qualifierExpression = methodExpression.getQualifierExpression();
                if (!(qualifierExpression instanceof PsiReferenceExpression)) {
                    return;
                }
                PsiReferenceExpression referenceExpression = (PsiReferenceExpression)qualifierExpression;
                PsiElement element = referenceExpression.resolve();
                if (!(element instanceof PsiVariable)) {
                    return;
                }
                PsiVariable variable2 = (PsiVariable)element;
                this.enumerationMethodCalled = this.variable.equals(variable2);
            }

            private boolean isEnumerationMethodCalled() {
                return this.enumerationMethodCalled;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "variable", "com/siyeh/ig/migration/EnumerationCanBeIterationInspectionBase$EnumerationCanBeIterationVisitor$EnumerationMethodCalledVisitor", "<init>"));
            }
        }
    }
}

