/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.migration;

import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ui.SingleCheckboxOptionsPanel;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiArrayInitializerExpression;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiBinaryExpression;
import com.intellij.psi.PsiClassObjectAccessExpression;
import com.intellij.psi.PsiConditionalExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiParenthesizedExpression;
import com.intellij.psi.PsiPostfixExpression;
import com.intellij.psi.PsiPrefixExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiSuperExpression;
import com.intellij.psi.PsiThisExpression;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.PsiReplacementUtil;
import com.siyeh.ig.psiutils.EquivalenceChecker;
import com.siyeh.ig.psiutils.ExpressionUtils;
import com.siyeh.ig.psiutils.ParenthesesUtils;
import javax.swing.JComponent;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EqualsReplaceableByObjectsCallInspection
extends BaseInspection {
    public boolean checkNotNull;
    private static final EquivalenceChecker EQUIVALENCE = new NoSideEffectExpressionEquivalenceChecker();

    @Override
    @NotNull
    public JComponent createOptionsPanel() {
        SingleCheckboxOptionsPanel singleCheckboxOptionsPanel = new SingleCheckboxOptionsPanel(InspectionGadgetsBundle.message("equals.replaceable.by.objects.check.not.null.option", new Object[0]), this, "checkNotNull");
        if (singleCheckboxOptionsPanel == null) {
            EqualsReplaceableByObjectsCallInspection.$$$reportNull$$$0(0);
        }
        return singleCheckboxOptionsPanel;
    }

    @Override
    @Nls
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("equals.replaceable.by.objects.call.display.name", new Object[0]);
        if (string == null) {
            EqualsReplaceableByObjectsCallInspection.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos2) {
        String string = InspectionGadgetsBundle.message("equals.replaceable.by.objects.call.problem.descriptor", new Object[0]);
        if (string == null) {
            EqualsReplaceableByObjectsCallInspection.$$$reportNull$$$0(2);
        }
        return string;
    }

    @Override
    @Nullable
    protected InspectionGadgetsFix buildFix(Object ... infos2) {
        return new EqualsReplaceableByObjectsCallFix((String)infos2[0], (String)infos2[1], (Boolean)infos2[2]);
    }

    @Override
    public boolean shouldInspect(PsiFile file2) {
        return PsiUtil.isLanguageLevel7OrHigher(file2);
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new EqualsReplaceableByObjectsCallVisitor();
    }

    private static boolean isNotNullExpressionOrConstant(PsiExpression expression2) {
        int preventEndlessLoop = 5;
        expression2 = ParenthesesUtils.stripParentheses(expression2);
        while (expression2 instanceof PsiReferenceExpression) {
            if (--preventEndlessLoop == 0) {
                return false;
            }
            expression2 = EqualsReplaceableByObjectsCallInspection.findFinalVariableDefinition((PsiReferenceExpression)expression2);
        }
        if (expression2 instanceof PsiNewExpression || expression2 instanceof PsiArrayInitializerExpression || expression2 instanceof PsiClassObjectAccessExpression) {
            return true;
        }
        return PsiUtil.isConstantExpression(expression2);
    }

    @Nullable
    private static PsiExpression findFinalVariableDefinition(@NotNull PsiReferenceExpression expression2) {
        PsiVariable variable2;
        PsiElement resolved;
        if (expression2 == null) {
            EqualsReplaceableByObjectsCallInspection.$$$reportNull$$$0(3);
        }
        if ((resolved = expression2.resolve()) instanceof PsiVariable && (variable2 = (PsiVariable)resolved).hasModifierProperty("final")) {
            return ParenthesesUtils.stripParentheses(variable2.getInitializer());
        }
        return null;
    }

    private static PsiExpression getArgumentExpression(PsiMethodCallExpression callExpression) {
        PsiExpression[] expressions = callExpression.getArgumentList().getExpressions();
        return expressions.length == 1 ? ParenthesesUtils.stripParentheses(expressions[0]) : null;
    }

    private static PsiExpression getQualifierExpression(PsiMethodCallExpression expression2) {
        return ParenthesesUtils.stripParentheses(expression2.getMethodExpression().getQualifierExpression());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 3: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 3: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/siyeh/ig/migration/EqualsReplaceableByObjectsCallInspection";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "createOptionsPanel";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "buildErrorString";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "com/siyeh/ig/migration/EqualsReplaceableByObjectsCallInspection";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "findFinalVariableDefinition";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 3: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class NoSideEffectExpressionEquivalenceChecker
    extends EquivalenceChecker {
        private NoSideEffectExpressionEquivalenceChecker() {
        }

        @Override
        protected EquivalenceChecker.Match newExpressionsMatch(@NotNull PsiNewExpression newExpression1, @NotNull PsiNewExpression newExpression2) {
            if (newExpression1 == null) {
                NoSideEffectExpressionEquivalenceChecker.$$$reportNull$$$0(0);
            }
            if (newExpression2 == null) {
                NoSideEffectExpressionEquivalenceChecker.$$$reportNull$$$0(1);
            }
            return EXACT_MISMATCH;
        }

        @Override
        protected EquivalenceChecker.Match methodCallExpressionsMatch(@NotNull PsiMethodCallExpression methodCallExpression1, @NotNull PsiMethodCallExpression methodCallExpression2) {
            if (methodCallExpression1 == null) {
                NoSideEffectExpressionEquivalenceChecker.$$$reportNull$$$0(2);
            }
            if (methodCallExpression2 == null) {
                NoSideEffectExpressionEquivalenceChecker.$$$reportNull$$$0(3);
            }
            return EXACT_MISMATCH;
        }

        @Override
        protected EquivalenceChecker.Match assignmentExpressionsMatch(@NotNull PsiAssignmentExpression assignmentExpression1, @NotNull PsiAssignmentExpression assignmentExpression2) {
            if (assignmentExpression1 == null) {
                NoSideEffectExpressionEquivalenceChecker.$$$reportNull$$$0(4);
            }
            if (assignmentExpression2 == null) {
                NoSideEffectExpressionEquivalenceChecker.$$$reportNull$$$0(5);
            }
            return EXACT_MISMATCH;
        }

        @Override
        protected EquivalenceChecker.Match arrayInitializerExpressionsMatch(@NotNull PsiArrayInitializerExpression arrayInitializerExpression1, @NotNull PsiArrayInitializerExpression arrayInitializerExpression2) {
            if (arrayInitializerExpression1 == null) {
                NoSideEffectExpressionEquivalenceChecker.$$$reportNull$$$0(6);
            }
            if (arrayInitializerExpression2 == null) {
                NoSideEffectExpressionEquivalenceChecker.$$$reportNull$$$0(7);
            }
            return EXACT_MISMATCH;
        }

        @Override
        protected EquivalenceChecker.Match prefixExpressionsMatch(@NotNull PsiPrefixExpression prefixExpression1, @NotNull PsiPrefixExpression prefixExpression2) {
            if (prefixExpression1 == null) {
                NoSideEffectExpressionEquivalenceChecker.$$$reportNull$$$0(8);
            }
            if (prefixExpression2 == null) {
                NoSideEffectExpressionEquivalenceChecker.$$$reportNull$$$0(9);
            }
            if (NoSideEffectExpressionEquivalenceChecker.isSideEffectUnaryOperator(prefixExpression1.getOperationTokenType())) {
                return EXACT_MISMATCH;
            }
            return super.prefixExpressionsMatch(prefixExpression1, prefixExpression2);
        }

        @Override
        protected EquivalenceChecker.Match postfixExpressionsMatch(@NotNull PsiPostfixExpression postfixExpression1, @NotNull PsiPostfixExpression postfixExpression2) {
            if (postfixExpression1 == null) {
                NoSideEffectExpressionEquivalenceChecker.$$$reportNull$$$0(10);
            }
            if (postfixExpression2 == null) {
                NoSideEffectExpressionEquivalenceChecker.$$$reportNull$$$0(11);
            }
            if (NoSideEffectExpressionEquivalenceChecker.isSideEffectUnaryOperator(postfixExpression1.getOperationTokenType())) {
                return EXACT_MISMATCH;
            }
            return super.postfixExpressionsMatch(postfixExpression1, postfixExpression2);
        }

        private static boolean isSideEffectUnaryOperator(IElementType tokenType) {
            return JavaTokenType.PLUSPLUS.equals(tokenType) || JavaTokenType.MINUSMINUS.equals(tokenType);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "newExpression1";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "newExpression2";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "methodCallExpression1";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "methodCallExpression2";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "assignmentExpression1";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "assignmentExpression2";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "arrayInitializerExpression1";
                    break;
                }
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "arrayInitializerExpression2";
                    break;
                }
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "prefixExpression1";
                    break;
                }
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "prefixExpression2";
                    break;
                }
                case 10: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "postfixExpression1";
                    break;
                }
                case 11: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "postfixExpression2";
                    break;
                }
            }
            objectArray2[1] = "com/siyeh/ig/migration/EqualsReplaceableByObjectsCallInspection$NoSideEffectExpressionEquivalenceChecker";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "newExpressionsMatch";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "methodCallExpressionsMatch";
                    break;
                }
                case 4: 
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[2] = "assignmentExpressionsMatch";
                    break;
                }
                case 6: 
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[2] = "arrayInitializerExpressionsMatch";
                    break;
                }
                case 8: 
                case 9: {
                    objectArray = objectArray2;
                    objectArray2[2] = "prefixExpressionsMatch";
                    break;
                }
                case 10: 
                case 11: {
                    objectArray = objectArray2;
                    objectArray2[2] = "postfixExpressionsMatch";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class EqualsCheck {
        @NotNull
        final PsiExpression argument;
        @NotNull
        final PsiExpression qualifier;
        final boolean isEqual;

        public EqualsCheck(@NotNull PsiExpression argument, @NotNull PsiExpression qualifier, boolean isEqual) {
            if (argument == null) {
                EqualsCheck.$$$reportNull$$$0(0);
            }
            if (qualifier == null) {
                EqualsCheck.$$$reportNull$$$0(1);
            }
            this.argument = argument;
            this.qualifier = qualifier;
            this.isEqual = isEqual;
        }

        @Nullable
        private static EqualsCheck create(@Nullable PsiExpression maybeEqualsCheckExpression) {
            PsiMethodCallExpression callExpression;
            Negated n = Negated.create(maybeEqualsCheckExpression);
            if (n != null && n.expression instanceof PsiMethodCallExpression && "equals".equals((callExpression = (PsiMethodCallExpression)n.expression).getMethodExpression().getReferenceName())) {
                PsiExpression argument = EqualsReplaceableByObjectsCallInspection.getArgumentExpression(callExpression);
                PsiExpression qualifier = EqualsReplaceableByObjectsCallInspection.getQualifierExpression(callExpression);
                if (argument != null && qualifier != null) {
                    return new EqualsCheck(argument, qualifier, n.isEqual);
                }
            }
            return null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "argument";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "qualifier";
                    break;
                }
            }
            objectArray[1] = "com/siyeh/ig/migration/EqualsReplaceableByObjectsCallInspection$EqualsCheck";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class NullCheck {
        @NotNull
        final PsiExpression compared;
        final boolean isEqual;

        public NullCheck(@NotNull PsiExpression compared, boolean isEqual) {
            if (compared == null) {
                NullCheck.$$$reportNull$$$0(0);
            }
            this.compared = compared;
            this.isEqual = isEqual;
        }

        @Nullable
        private static NullCheck create(@Nullable PsiExpression maybeNullCheckExpression) {
            PsiBinaryExpression binaryExpression;
            PsiExpression comparedWithNull;
            Negated n = Negated.create(maybeNullCheckExpression);
            if (n != null && n.expression instanceof PsiBinaryExpression && (comparedWithNull = ParenthesesUtils.stripParentheses(ExpressionUtils.getValueComparedWithNull(binaryExpression = (PsiBinaryExpression)n.expression))) != null) {
                boolean equal = JavaTokenType.EQEQ.equals(binaryExpression.getOperationTokenType());
                return new NullCheck(comparedWithNull, equal == n.isEqual);
            }
            return null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "compared", "com/siyeh/ig/migration/EqualsReplaceableByObjectsCallInspection$NullCheck", "<init>"));
        }
    }

    private static class Negated {
        @NotNull
        final PsiExpression expression;
        final boolean isEqual;

        public Negated(@NotNull PsiExpression expression2, boolean isEqual) {
            if (expression2 == null) {
                Negated.$$$reportNull$$$0(0);
            }
            this.expression = expression2;
            this.isEqual = isEqual;
        }

        @Nullable
        static Negated create(@Nullable PsiExpression maybeNegatedExpression) {
            PsiPrefixExpression prefixExpression;
            boolean equal = true;
            PsiExpression expression2 = ParenthesesUtils.stripParentheses(maybeNegatedExpression);
            if (expression2 instanceof PsiPrefixExpression && JavaTokenType.EXCL.equals((prefixExpression = (PsiPrefixExpression)expression2).getOperationTokenType())) {
                equal = false;
                expression2 = ParenthesesUtils.stripParentheses(prefixExpression.getOperand());
            }
            return expression2 != null ? new Negated(expression2, equal) : null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/siyeh/ig/migration/EqualsReplaceableByObjectsCallInspection$Negated", "<init>"));
        }
    }

    private class EqualsReplaceableByObjectsCallVisitor
    extends BaseInspectionVisitor {
        private EqualsReplaceableByObjectsCallVisitor() {
        }

        @Override
        public void visitMethodCallExpression(PsiMethodCallExpression expression2) {
            String methodName = expression2.getMethodExpression().getReferenceName();
            if (!"equals".equals(methodName)) {
                return;
            }
            PsiExpression qualifierExpression = EqualsReplaceableByObjectsCallInspection.getQualifierExpression(expression2);
            if (qualifierExpression instanceof PsiThisExpression || qualifierExpression instanceof PsiSuperExpression) {
                return;
            }
            if (EqualsReplaceableByObjectsCallInspection.isNotNullExpressionOrConstant(qualifierExpression)) {
                return;
            }
            PsiElement parentExpression = PsiTreeUtil.skipParentsOfType(expression2, PsiParenthesizedExpression.class, PsiPrefixExpression.class);
            if (parentExpression instanceof PsiBinaryExpression ? this.processNotNullCheck((PsiBinaryExpression)parentExpression) : parentExpression instanceof PsiConditionalExpression && this.processNotNullCondition((PsiConditionalExpression)parentExpression)) {
                return;
            }
            if (!EqualsReplaceableByObjectsCallInspection.this.checkNotNull) {
                if (qualifierExpression == null) {
                    return;
                }
                PsiExpression argumentExpression = EqualsReplaceableByObjectsCallInspection.getArgumentExpression(expression2);
                if (argumentExpression == null) {
                    return;
                }
                this.registerError((PsiElement)expression2, qualifierExpression.getText(), argumentExpression.getText(), true);
            }
        }

        private boolean processNotNullCheck(PsiBinaryExpression expression2) {
            IElementType tokenType = expression2.getOperationTokenType();
            PsiExpression rightOperand = ParenthesesUtils.stripParentheses(expression2.getROperand());
            if (JavaTokenType.ANDAND.equals(tokenType)) {
                return this.registerProblem(expression2, rightOperand, true);
            }
            if (JavaTokenType.OROR.equals(tokenType) && rightOperand instanceof PsiPrefixExpression && JavaTokenType.EXCL.equals(((PsiPrefixExpression)rightOperand).getOperationTokenType())) {
                PsiExpression negatedRightOperand = ParenthesesUtils.stripParentheses(((PsiPrefixExpression)rightOperand).getOperand());
                return this.registerProblem(expression2, negatedRightOperand, false);
            }
            return true;
        }

        private boolean processNotNullCondition(@NotNull PsiConditionalExpression expression2) {
            NullCheck conditionNullCheck;
            if (expression2 == null) {
                EqualsReplaceableByObjectsCallVisitor.$$$reportNull$$$0(0);
            }
            if ((conditionNullCheck = NullCheck.create(expression2.getCondition())) == null) {
                return false;
            }
            PsiExpression nullBranch = conditionNullCheck.isEqual ? expression2.getThenExpression() : expression2.getElseExpression();
            PsiExpression nonNullBranch = conditionNullCheck.isEqual ? expression2.getElseExpression() : expression2.getThenExpression();
            NullCheck otherNullCheck = NullCheck.create(nullBranch);
            EqualsCheck equalsCheck = EqualsCheck.create(nonNullBranch);
            if (otherNullCheck == null || equalsCheck == null || otherNullCheck.isEqual != equalsCheck.isEqual) {
                return false;
            }
            if (EQUIVALENCE.expressionsAreEquivalent(conditionNullCheck.compared, equalsCheck.qualifier) && EQUIVALENCE.expressionsAreEquivalent(otherNullCheck.compared, equalsCheck.argument)) {
                this.registerError((PsiElement)expression2, equalsCheck.qualifier.getText(), equalsCheck.argument.getText(), equalsCheck.isEqual);
                return true;
            }
            return false;
        }

        private boolean registerProblem(@NotNull PsiBinaryExpression expression2, PsiExpression rightOperand, boolean equal) {
            if (expression2 == null) {
                EqualsReplaceableByObjectsCallVisitor.$$$reportNull$$$0(1);
            }
            if (rightOperand instanceof PsiMethodCallExpression) {
                PsiMethodCallExpression methodCallExpression = (PsiMethodCallExpression)rightOperand;
                NullCheck nullCheck = NullCheck.create(expression2.getLOperand());
                if (nullCheck != null && nullCheck.isEqual != equal) {
                    PsiExpression argumentExpression;
                    PsiExpression nullCheckedExpression = nullCheck.compared;
                    PsiExpression qualifierExpression = EqualsReplaceableByObjectsCallInspection.getQualifierExpression(methodCallExpression);
                    if (EQUIVALENCE.expressionsAreEquivalent(qualifierExpression, nullCheckedExpression) && (argumentExpression = EqualsReplaceableByObjectsCallInspection.getArgumentExpression(methodCallExpression)) != null) {
                        PsiExpression expressionToReplace = this.checkEqualityBefore(expression2, equal, qualifierExpression, argumentExpression);
                        this.registerError((PsiElement)expressionToReplace, nullCheckedExpression.getText(), argumentExpression.getText(), equal);
                        return true;
                    }
                }
            }
            return false;
        }

        @NotNull
        private PsiExpression checkEqualityBefore(@NotNull PsiExpression expression2, boolean equal, PsiExpression part1, PsiExpression part2) {
            PsiElement parent2;
            if (expression2 == null) {
                EqualsReplaceableByObjectsCallVisitor.$$$reportNull$$$0(2);
            }
            if ((parent2 = PsiTreeUtil.skipParentsOfType(expression2, PsiParenthesizedExpression.class)) instanceof PsiBinaryExpression) {
                PsiExpression lhs;
                PsiBinaryExpression binaryExpression = (PsiBinaryExpression)parent2;
                IElementType tokenType = binaryExpression.getOperationTokenType();
                if ((equal && JavaTokenType.OROR.equals(tokenType) || !equal && JavaTokenType.ANDAND.equals(tokenType)) && PsiTreeUtil.isAncestor(binaryExpression.getROperand(), expression2, false) && this.isEquality(lhs = binaryExpression.getLOperand(), equal, part1, part2)) {
                    PsiBinaryExpression psiBinaryExpression = binaryExpression;
                    if (psiBinaryExpression == null) {
                        EqualsReplaceableByObjectsCallVisitor.$$$reportNull$$$0(3);
                    }
                    return psiBinaryExpression;
                }
            }
            PsiExpression psiExpression = expression2;
            if (psiExpression == null) {
                EqualsReplaceableByObjectsCallVisitor.$$$reportNull$$$0(4);
            }
            return psiExpression;
        }

        private boolean isEquality(PsiExpression expression2, boolean equals, PsiExpression part1, PsiExpression part2) {
            if (!((expression2 = ParenthesesUtils.stripParentheses(expression2)) instanceof PsiBinaryExpression)) {
                return false;
            }
            PsiBinaryExpression binaryExpression = (PsiBinaryExpression)expression2;
            if (equals ? !JavaTokenType.EQEQ.equals(binaryExpression.getOperationTokenType()) : !JavaTokenType.NE.equals(binaryExpression.getOperationTokenType())) {
                return false;
            }
            PsiExpression leftOperand = binaryExpression.getLOperand();
            PsiExpression rightOperand = binaryExpression.getROperand();
            return EQUIVALENCE.expressionsAreEquivalent(leftOperand, part1) && EQUIVALENCE.expressionsAreEquivalent(rightOperand, part2) || EQUIVALENCE.expressionsAreEquivalent(leftOperand, part2) && EQUIVALENCE.expressionsAreEquivalent(rightOperand, part1);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 3: 
                case 4: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 3: 
                case 4: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "expression";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/siyeh/ig/migration/EqualsReplaceableByObjectsCallInspection$EqualsReplaceableByObjectsCallVisitor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/siyeh/ig/migration/EqualsReplaceableByObjectsCallInspection$EqualsReplaceableByObjectsCallVisitor";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "checkEqualityBefore";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "processNotNullCondition";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "registerProblem";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "checkEqualityBefore";
                    break;
                }
                case 3: 
                case 4: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 3: 
                case 4: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class EqualsReplaceableByObjectsCallFix
    extends InspectionGadgetsFix {
        private final String myName1;
        private final String myName2;
        private final Boolean myEquals;

        public EqualsReplaceableByObjectsCallFix(String name1, String name2, Boolean equals) {
            this.myName1 = name1;
            this.myName2 = name2;
            this.myEquals = equals;
        }

        @Override
        @Nls
        @NotNull
        public String getFamilyName() {
            String string = InspectionGadgetsBundle.message("equals.replaceable.by.objects.call.quickfix", new Object[0]);
            if (string == null) {
                EqualsReplaceableByObjectsCallFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        @Override
        protected void doFix(Project project, ProblemDescriptor descriptor2) {
            PsiElement element = descriptor2.getPsiElement();
            if (!(element instanceof PsiBinaryExpression || element instanceof PsiMethodCallExpression || element instanceof PsiConditionalExpression)) {
                return;
            }
            PsiExpression expression2 = (PsiExpression)element;
            String expressionText = "java.util.Objects.equals(" + this.myName1 + "," + this.myName2 + ")";
            PsiReplacementUtil.replaceExpressionAndShorten(expression2, this.myEquals != false ? expressionText : "!" + expressionText);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/migration/EqualsReplaceableByObjectsCallInspection$EqualsReplaceableByObjectsCallFix", "getFamilyName"));
        }
    }
}

