/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.naming;

import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.util.MethodSignatureUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import org.jetbrains.annotations.NotNull;

public class OverloadedVarargsMethodInspection
extends BaseInspection {
    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("overloaded.vararg.method.display.name", new Object[0]);
        if (string == null) {
            OverloadedVarargsMethodInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos2) {
        PsiMethod element = (PsiMethod)infos2[0];
        if (element.isConstructor()) {
            String string = InspectionGadgetsBundle.message("overloaded.vararg.constructor.problem.descriptor", new Object[0]);
            if (string == null) {
                OverloadedVarargsMethodInspection.$$$reportNull$$$0(1);
            }
            return string;
        }
        String string = InspectionGadgetsBundle.message("overloaded.vararg.method.problem.descriptor", new Object[0]);
        if (string == null) {
            OverloadedVarargsMethodInspection.$$$reportNull$$$0(2);
        }
        return string;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new OverloadedVarargMethodVisitor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/siyeh/ig/naming/OverloadedVarargsMethodInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "buildErrorString";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    private static class OverloadedVarargMethodVisitor
    extends BaseInspectionVisitor {
        private OverloadedVarargMethodVisitor() {
        }

        @Override
        public void visitMethod(@NotNull PsiMethod method) {
            PsiMethod[] sameNameMethods;
            if (method == null) {
                OverloadedVarargMethodVisitor.$$$reportNull$$$0(0);
            }
            if (!method.isVarArgs()) {
                return;
            }
            PsiClass aClass2 = method.getContainingClass();
            if (aClass2 == null) {
                return;
            }
            String methodName = method.getName();
            for (PsiMethod sameNameMethod : sameNameMethods = aClass2.findMethodsByName(methodName, true)) {
                PsiSubstitutor substitutor2;
                PsiClass superClass = sameNameMethod.getContainingClass();
                PsiSubstitutor psiSubstitutor = substitutor2 = superClass != null ? TypeConversionUtil.getSuperClassSubstitutor(superClass, aClass2, PsiSubstitutor.EMPTY) : PsiSubstitutor.EMPTY;
                if (MethodSignatureUtil.areSignaturesEqual(sameNameMethod.getSignature(substitutor2), method.getSignature(PsiSubstitutor.EMPTY))) continue;
                this.registerMethodError(method, method);
                return;
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "com/siyeh/ig/naming/OverloadedVarargsMethodInspection$OverloadedVarargMethodVisitor", "visitMethod"));
        }
    }
}

