/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.naming;

import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.util.PsiUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class StandardVariableNamesInspectionBase
extends BaseInspection {
    @NonNls
    static final Map<String, String> s_expectedTypes = new HashMap<String, String>(13);
    @NonNls
    static final Map<String, String> s_boxingClasses = new HashMap<String, String>(8);
    public boolean ignoreParameterNameSameAsSuper = false;

    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("standard.variable.names.display.name", new Object[0]);
        if (string == null) {
            StandardVariableNamesInspectionBase.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    protected boolean buildQuickFixesOnlyForOnTheFlyErrors() {
        return true;
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos2) {
        String boxedType;
        PsiVariable variable2 = (PsiVariable)infos2[0];
        String name = variable2.getName();
        String expectedType2 = s_expectedTypes.get(name);
        if (PsiUtil.isLanguageLevel5OrHigher(variable2) && (boxedType = s_boxingClasses.get(expectedType2)) != null) {
            String string = InspectionGadgetsBundle.message("standard.variable.names.problem.descriptor2", expectedType2, boxedType);
            if (string == null) {
                StandardVariableNamesInspectionBase.$$$reportNull$$$0(1);
            }
            return string;
        }
        String string = InspectionGadgetsBundle.message("standard.variable.names.problem.descriptor", expectedType2);
        if (string == null) {
            StandardVariableNamesInspectionBase.$$$reportNull$$$0(2);
        }
        return string;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new StandardVariableNamesVisitor();
    }

    static {
        s_expectedTypes.put("b", "byte");
        s_expectedTypes.put("c", "char");
        s_expectedTypes.put("ch", "char");
        s_expectedTypes.put("d", "double");
        s_expectedTypes.put("f", "float");
        s_expectedTypes.put("i", "int");
        s_expectedTypes.put("j", "int");
        s_expectedTypes.put("k", "int");
        s_expectedTypes.put("m", "int");
        s_expectedTypes.put("n", "int");
        s_expectedTypes.put("l", "long");
        s_expectedTypes.put("s", "java.lang.String");
        s_expectedTypes.put("str", "java.lang.String");
        s_boxingClasses.put("int", "java.lang.Integer");
        s_boxingClasses.put("short", "java.lang.Short");
        s_boxingClasses.put("boolean", "java.lang.Boolean");
        s_boxingClasses.put("long", "java.lang.Long");
        s_boxingClasses.put("byte", "java.lang.Byte");
        s_boxingClasses.put("float", "java.lang.Float");
        s_boxingClasses.put("double", "java.lang.Double");
        s_boxingClasses.put("char", "java.lang.Character");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/siyeh/ig/naming/StandardVariableNamesInspectionBase";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "buildErrorString";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    private class StandardVariableNamesVisitor
    extends BaseInspectionVisitor {
        private StandardVariableNamesVisitor() {
        }

        @Override
        public void visitVariable(@NotNull PsiVariable variable2) {
            String unboxedTypeText;
            PsiPrimitiveType unboxedType;
            if (variable2 == null) {
                StandardVariableNamesVisitor.$$$reportNull$$$0(0);
            }
            super.visitVariable(variable2);
            String variableName = variable2.getName();
            String expectedType2 = s_expectedTypes.get(variableName);
            if (expectedType2 == null) {
                return;
            }
            PsiType type2 = variable2.getType();
            String typeText = type2.getCanonicalText();
            if (expectedType2.equals(typeText)) {
                return;
            }
            if (PsiUtil.isLanguageLevel5OrHigher(variable2) && (unboxedType = PsiPrimitiveType.getUnboxedType(type2)) != null && expectedType2.equals(unboxedTypeText = unboxedType.getCanonicalText())) {
                return;
            }
            if (StandardVariableNamesInspectionBase.this.ignoreParameterNameSameAsSuper && this.isVariableNamedSameAsSuper(variable2)) {
                return;
            }
            this.registerVariableError(variable2, variable2);
        }

        private boolean isVariableNamedSameAsSuper(PsiVariable variable2) {
            PsiMethod[] superMethods;
            if (!(variable2 instanceof PsiParameter)) {
                return false;
            }
            PsiParameter parameter = (PsiParameter)variable2;
            PsiElement scope = parameter.getDeclarationScope();
            if (!(scope instanceof PsiMethod)) {
                return false;
            }
            String variableName = variable2.getName();
            PsiMethod method = (PsiMethod)scope;
            int index2 = method.getParameterList().getParameterIndex(parameter);
            for (PsiMethod superMethod : superMethods = method.findSuperMethods()) {
                PsiParameter[] parameters2 = superMethod.getParameterList().getParameters();
                PsiParameter overriddenParameter = parameters2[index2];
                if (!variableName.equals(overriddenParameter.getName())) continue;
                return true;
            }
            return false;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "variable", "com/siyeh/ig/naming/StandardVariableNamesInspectionBase$StandardVariableNamesVisitor", "visitVariable"));
        }
    }
}

