/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.numeric;

import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ui.SingleCheckboxOptionsPanel;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiType;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.PsiReplacementUtil;
import javax.swing.JComponent;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ConfusingFloatingPointLiteralInspection
extends BaseInspection {
    public boolean ignoreScientificNotation = false;

    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("confusing.floating.point.literal.display.name", new Object[0]);
        if (string == null) {
            ConfusingFloatingPointLiteralInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos2) {
        String string = InspectionGadgetsBundle.message("confusing.floating.point.literal.problem.descriptor", new Object[0]);
        if (string == null) {
            ConfusingFloatingPointLiteralInspection.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Override
    @Nullable
    public JComponent createOptionsPanel() {
        return new SingleCheckboxOptionsPanel(InspectionGadgetsBundle.message("confusing.floating.point.literal.option", new Object[0]), this, "ignoreScientificNotation");
    }

    @Override
    public void writeSettings(@NotNull Element node) throws WriteExternalException {
        if (node == null) {
            ConfusingFloatingPointLiteralInspection.$$$reportNull$$$0(2);
        }
        if (this.ignoreScientificNotation) {
            node.addContent(new Element("option").setAttribute("name", "ignoreScientificNotation").setAttribute("value", "true"));
        }
    }

    @Override
    public InspectionGadgetsFix buildFix(Object ... infos2) {
        return new ConfusingFloatingPointLiteralFix();
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new ConfusingFloatingPointLiteralVisitor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/siyeh/ig/numeric/ConfusingFloatingPointLiteralInspection";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "buildErrorString";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "com/siyeh/ig/numeric/ConfusingFloatingPointLiteralInspection";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "writeSettings";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class ConfusingFloatingPointLiteralVisitor
    extends BaseInspectionVisitor {
        private ConfusingFloatingPointLiteralVisitor() {
        }

        @Override
        public void visitLiteralExpression(@NotNull PsiLiteralExpression literal) {
            if (literal == null) {
                ConfusingFloatingPointLiteralVisitor.$$$reportNull$$$0(0);
            }
            super.visitLiteralExpression(literal);
            PsiType type2 = literal.getType();
            String literalText = literal.getText();
            if (!PsiType.FLOAT.equals(type2) && !PsiType.DOUBLE.equals(type2) || !this.isConfusing(literalText)) {
                return;
            }
            if (ConfusingFloatingPointLiteralInspection.this.ignoreScientificNotation && StringUtil.containsAnyChar(literalText, "EePp")) {
                return;
            }
            this.registerError((PsiElement)literal, new Object[0]);
        }

        private boolean isConfusing(@Nullable CharSequence text2) {
            if (text2 == null) {
                return false;
            }
            int length = text2.length();
            if (length < 3) {
                return true;
            }
            boolean hex = true;
            char firstChar = text2.charAt(0);
            if (firstChar != '0') {
                if (!StringUtil.isDecimalDigit(firstChar)) {
                    return true;
                }
                hex = false;
            }
            char secondChar = text2.charAt(1);
            if (hex && secondChar != 'x' && secondChar != 'X') {
                hex = false;
            }
            int index2 = hex ? 2 : 1;
            char nextChar = text2.charAt(index2);
            if (hex && !StringUtil.isHexDigit(nextChar)) {
                return true;
            }
            while (hex && StringUtil.isHexDigit(nextChar) || StringUtil.isDecimalDigit(nextChar) || nextChar == '_') {
                if (++index2 >= length) {
                    return true;
                }
                nextChar = text2.charAt(index2);
            }
            if (nextChar != '.') {
                return true;
            }
            if (++index2 >= length) {
                return true;
            }
            nextChar = text2.charAt(index2);
            return hex ? !StringUtil.isHexDigit(nextChar) : !StringUtil.isDecimalDigit(nextChar);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "literal", "com/siyeh/ig/numeric/ConfusingFloatingPointLiteralInspection$ConfusingFloatingPointLiteralVisitor", "visitLiteralExpression"));
        }
    }

    private static class ConfusingFloatingPointLiteralFix
    extends InspectionGadgetsFix {
        private ConfusingFloatingPointLiteralFix() {
        }

        @Override
        @NotNull
        public String getFamilyName() {
            String string = InspectionGadgetsBundle.message("confusing.floating.point.literal.change.quickfix", new Object[0]);
            if (string == null) {
                ConfusingFloatingPointLiteralFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        @Override
        public void doFix(Project project, ProblemDescriptor descriptor2) {
            PsiExpression literalExpression = (PsiExpression)descriptor2.getPsiElement();
            String text2 = literalExpression.getText();
            String newText = ConfusingFloatingPointLiteralFix.getCanonicalForm(text2);
            PsiReplacementUtil.replaceExpression(literalExpression, newText);
        }

        private static String getCanonicalForm(@NonNls String text2) {
            String prefix;
            String suffix;
            boolean isHexadecimal = text2.startsWith("0x") || text2.startsWith("0X");
            int breakPoint = text2.indexOf(101);
            if (breakPoint < 0) {
                breakPoint = text2.indexOf(69);
            }
            if (breakPoint < 0) {
                breakPoint = text2.indexOf(102);
            }
            if (breakPoint < 0) {
                breakPoint = text2.indexOf(70);
            }
            if (breakPoint < 0) {
                breakPoint = text2.indexOf(112);
            }
            if (breakPoint < 0) {
                breakPoint = text2.indexOf(80);
            }
            if (breakPoint < 0) {
                breakPoint = text2.indexOf(100);
            }
            if (breakPoint < 0) {
                breakPoint = text2.indexOf(68);
            }
            if (breakPoint < 0) {
                suffix = "";
                prefix = text2;
            } else {
                suffix = text2.substring(breakPoint);
                prefix = text2.substring(0, breakPoint);
            }
            int indexPoint = prefix.indexOf(46);
            if (indexPoint < 0) {
                return prefix + ".0" + suffix;
            }
            if (isHexadecimal && indexPoint == 2) {
                return prefix.substring(0, 2) + '0' + prefix.substring(2) + suffix;
            }
            if (indexPoint == 0) {
                return '0' + prefix + suffix;
            }
            return prefix + '0' + suffix;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/numeric/ConfusingFloatingPointLiteralInspection$ConfusingFloatingPointLiteralFix", "getFamilyName"));
        }
    }
}

