/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.numeric;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiType;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class SuspiciousLiteralUnderscoreInspection
extends BaseInspection {
    @Override
    @Nls
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("suspicious.literal.underscore.display.name", new Object[0]);
        if (string == null) {
            SuspiciousLiteralUnderscoreInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos2) {
        String string = InspectionGadgetsBundle.message("suspicious.literal.underscore.problem.descriptor", new Object[0]);
        if (string == null) {
            SuspiciousLiteralUnderscoreInspection.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new SuspiciousLiteralUnderscoreVisitor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/siyeh/ig/numeric/SuspiciousLiteralUnderscoreInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "buildErrorString";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    private static class SuspiciousLiteralUnderscoreVisitor
    extends BaseInspectionVisitor {
        private SuspiciousLiteralUnderscoreVisitor() {
        }

        @Override
        public void visitLiteralExpression(PsiLiteralExpression expression2) {
            super.visitLiteralExpression(expression2);
            PsiType type2 = expression2.getType();
            if (!(PsiType.SHORT.equals(type2) || PsiType.INT.equals(type2) || PsiType.LONG.equals(type2) || PsiType.FLOAT.equals(type2) || PsiType.DOUBLE.equals(type2))) {
                return;
            }
            String text2 = expression2.getText();
            if (text2.startsWith("0") && !text2.startsWith("0.")) {
                return;
            }
            if (!text2.contains("_")) {
                return;
            }
            boolean underscore = false;
            boolean group = false;
            boolean dot = false;
            int digit = 0;
            int index2 = StringUtil.indexOfAny(text2, "fledFLED");
            int length = index2 > 0 ? index2 : text2.length();
            for (int i = 0; i < length; ++i) {
                char c = text2.charAt(i);
                if (c == '_' || c == '.') {
                    if (underscore) {
                        return;
                    }
                    underscore = true;
                    if (digit != 3 && group || digit > 3) {
                        this.registerErrorAtOffset((PsiElement)expression2, i - digit, digit, new Object[0]);
                    }
                    group = true;
                    digit = 0;
                    if (c != '.') continue;
                    dot = true;
                    continue;
                }
                if (Character.isDigit(c)) {
                    underscore = false;
                    ++digit;
                    continue;
                }
                return;
            }
            if (digit == 0) {
                return;
            }
            if (dot ? digit > 3 : digit != 3) {
                this.registerErrorAtOffset((PsiElement)expression2, length - digit, digit, new Object[0]);
            }
        }
    }
}

