/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.numeric;

import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiParenthesizedExpression;
import com.intellij.psi.PsiPolyadicExpression;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeCastExpression;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.psiutils.ClassUtils;
import com.siyeh.ig.psiutils.ExpectedTypeUtils;
import com.siyeh.ig.psiutils.ExpressionUtils;
import com.siyeh.ig.psiutils.MethodCallUtils;
import com.siyeh.ig.psiutils.TypeUtils;
import gnu.trove.THashSet;
import java.util.Set;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class UnnecessaryExplicitNumericCastInspection
extends BaseInspection {
    private static final Set<IElementType> binaryPromotionOperators = new THashSet<IElementType>();

    @Override
    @Nls
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("unnecessary.explicit.numeric.cast.display.name", new Object[0]);
        if (string == null) {
            UnnecessaryExplicitNumericCastInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos2) {
        PsiExpression expression2 = (PsiExpression)infos2[0];
        String string = InspectionGadgetsBundle.message("unnecessary.explicit.numeric.cast.problem.descriptor", expression2.getText());
        if (string == null) {
            UnnecessaryExplicitNumericCastInspection.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Override
    protected InspectionGadgetsFix buildFix(Object ... infos2) {
        return new UnnecessaryExplicitNumericCastFix();
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new UnnecessaryExplicitNumericCastVisitor();
    }

    public static boolean isPrimitiveNumericCastNecessary(PsiTypeCastExpression expression2) {
        PsiType castType = expression2.getType();
        if (castType == null) {
            return true;
        }
        PsiExpression operand = expression2.getOperand();
        if (operand == null) {
            return true;
        }
        PsiType operandType = operand.getType();
        if (!(operandType instanceof PsiPrimitiveType)) {
            return true;
        }
        PsiElement parent2 = expression2.getParent();
        while (parent2 instanceof PsiParenthesizedExpression) {
            parent2 = parent2.getParent();
        }
        if (parent2 instanceof PsiPolyadicExpression) {
            PsiPolyadicExpression polyadicExpression = (PsiPolyadicExpression)parent2;
            IElementType tokenType = polyadicExpression.getOperationTokenType();
            if (binaryPromotionOperators.contains(tokenType)) {
                if (TypeUtils.isNarrowingConversion(operandType, castType)) {
                    return true;
                }
                if (PsiType.INT.equals(castType)) {
                    if (PsiType.CHAR.equals(operandType) && TypeUtils.getStringType(polyadicExpression).equals(polyadicExpression.getType())) {
                        return true;
                    }
                    return PsiType.LONG.equals(operandType) || PsiType.FLOAT.equals(operandType) || PsiType.DOUBLE.equals(operandType);
                }
                if (PsiType.LONG.equals(castType) || PsiType.FLOAT.equals(castType) || PsiType.DOUBLE.equals(castType)) {
                    PsiExpression[] operands = polyadicExpression.getOperands();
                    int expressionIndex = -1;
                    for (int i = 0; i < operands.length; ++i) {
                        if (expressionIndex == 0 && i > 1) {
                            return true;
                        }
                        PsiExpression operand1 = operands[i];
                        if (PsiTreeUtil.isAncestor(operand1, expression2, false)) {
                            if (i > 0) {
                                return true;
                            }
                            expressionIndex = i;
                            continue;
                        }
                        PsiType type2 = operand1.getType();
                        if (!castType.equals(type2)) continue;
                        return false;
                    }
                }
            } else if (JavaTokenType.GTGT.equals(tokenType) || JavaTokenType.GTGTGT.equals(tokenType) || JavaTokenType.LTLT.equals(tokenType)) {
                PsiExpression firstOperand = polyadicExpression.getOperands()[0];
                if (!PsiTreeUtil.isAncestor(firstOperand, expression2, false)) {
                    return false;
                }
                return PsiType.LONG.equals(castType) || !UnnecessaryExplicitNumericCastInspection.isLegalWideningConversion(operand, PsiType.INT);
            }
            return true;
        }
        if (parent2 instanceof PsiAssignmentExpression) {
            PsiAssignmentExpression assignmentExpression = (PsiAssignmentExpression)parent2;
            PsiType lhsType = assignmentExpression.getType();
            return !castType.equals(lhsType) || !UnnecessaryExplicitNumericCastInspection.isLegalAssignmentConversion(operand, lhsType);
        }
        if (parent2 instanceof PsiVariable) {
            PsiVariable variable2 = (PsiVariable)parent2;
            PsiType lhsType = variable2.getType();
            return !castType.equals(lhsType) || !UnnecessaryExplicitNumericCastInspection.isLegalAssignmentConversion(operand, lhsType);
        }
        if (MethodCallUtils.isNecessaryForSurroundingMethodCall(expression2, operand)) {
            return true;
        }
        PsiType expectedType2 = ExpectedTypeUtils.findExpectedType(expression2, false);
        return !castType.equals(expectedType2) || !UnnecessaryExplicitNumericCastInspection.isLegalWideningConversion(operand, castType);
    }

    static boolean isLegalWideningConversion(PsiExpression expression2, PsiType requiredType) {
        PsiType operandType = expression2.getType();
        return PsiType.DOUBLE.equals(requiredType) ? PsiType.FLOAT.equals(operandType) || PsiType.LONG.equals(operandType) || PsiType.INT.equals(operandType) || PsiType.CHAR.equals(operandType) || PsiType.SHORT.equals(operandType) || PsiType.BYTE.equals(operandType) : (PsiType.FLOAT.equals(requiredType) ? PsiType.LONG.equals(operandType) || PsiType.INT.equals(operandType) || PsiType.CHAR.equals(operandType) || PsiType.SHORT.equals(operandType) || PsiType.BYTE.equals(operandType) : (PsiType.LONG.equals(requiredType) ? PsiType.INT.equals(operandType) || PsiType.CHAR.equals(operandType) || PsiType.SHORT.equals(operandType) || PsiType.BYTE.equals(operandType) : PsiType.INT.equals(requiredType) && (PsiType.CHAR.equals(operandType) || PsiType.SHORT.equals(operandType) || PsiType.BYTE.equals(operandType))));
    }

    static boolean isLegalAssignmentConversion(PsiExpression expression2, PsiType assignmentType) {
        if (UnnecessaryExplicitNumericCastInspection.isLegalWideningConversion(expression2, assignmentType)) {
            return true;
        }
        if (PsiType.SHORT.equals(assignmentType)) {
            return UnnecessaryExplicitNumericCastInspection.canValueBeContained(expression2, Short.MIN_VALUE, Short.MAX_VALUE);
        }
        if (PsiType.CHAR.equals(assignmentType)) {
            return UnnecessaryExplicitNumericCastInspection.canValueBeContained(expression2, 0, 65535);
        }
        if (PsiType.BYTE.equals(assignmentType)) {
            return UnnecessaryExplicitNumericCastInspection.canValueBeContained(expression2, -128, 127);
        }
        return false;
    }

    private static boolean canValueBeContained(PsiExpression expression2, int lowerBound, int upperBound) {
        PsiType expressionType = expression2.getType();
        if (!PsiType.INT.equals(expressionType)) {
            return false;
        }
        Object constant = ExpressionUtils.computeConstantExpression(expression2);
        if (!(constant instanceof Integer)) {
            return false;
        }
        int i = (Integer)constant;
        return i >= lowerBound && i <= upperBound;
    }

    static {
        binaryPromotionOperators.add(JavaTokenType.ASTERISK);
        binaryPromotionOperators.add(JavaTokenType.DIV);
        binaryPromotionOperators.add(JavaTokenType.PERC);
        binaryPromotionOperators.add(JavaTokenType.PLUS);
        binaryPromotionOperators.add(JavaTokenType.MINUS);
        binaryPromotionOperators.add(JavaTokenType.LT);
        binaryPromotionOperators.add(JavaTokenType.LE);
        binaryPromotionOperators.add(JavaTokenType.GT);
        binaryPromotionOperators.add(JavaTokenType.GE);
        binaryPromotionOperators.add(JavaTokenType.EQEQ);
        binaryPromotionOperators.add(JavaTokenType.NE);
        binaryPromotionOperators.add(JavaTokenType.AND);
        binaryPromotionOperators.add(JavaTokenType.XOR);
        binaryPromotionOperators.add(JavaTokenType.OR);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/siyeh/ig/numeric/UnnecessaryExplicitNumericCastInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "buildErrorString";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    private static class UnnecessaryExplicitNumericCastVisitor
    extends BaseInspectionVisitor {
        private UnnecessaryExplicitNumericCastVisitor() {
        }

        @Override
        public void visitTypeCastExpression(PsiTypeCastExpression expression2) {
            super.visitTypeCastExpression(expression2);
            PsiType castType = expression2.getType();
            if (!ClassUtils.isPrimitiveNumericType(castType)) {
                return;
            }
            PsiExpression operand = expression2.getOperand();
            if (operand == null) {
                return;
            }
            PsiType operandType = operand.getType();
            if (castType.equals(operandType) || UnnecessaryExplicitNumericCastInspection.isPrimitiveNumericCastNecessary(expression2)) {
                return;
            }
            PsiTypeElement typeElement = expression2.getCastType();
            if (typeElement != null) {
                this.registerError((PsiElement)typeElement, ProblemHighlightType.LIKE_UNUSED_SYMBOL, operand);
            }
        }
    }

    private static class UnnecessaryExplicitNumericCastFix
    extends InspectionGadgetsFix {
        private UnnecessaryExplicitNumericCastFix() {
        }

        @Override
        @NotNull
        public String getFamilyName() {
            String string = InspectionGadgetsBundle.message("unnecessary.explicit.numeric.cast.quickfix", new Object[0]);
            if (string == null) {
                UnnecessaryExplicitNumericCastFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        @Override
        protected void doFix(Project project, ProblemDescriptor descriptor2) {
            PsiElement element = descriptor2.getPsiElement();
            PsiElement parent2 = element.getParent();
            if (!(parent2 instanceof PsiTypeCastExpression)) {
                return;
            }
            PsiTypeCastExpression typeCastExpression = (PsiTypeCastExpression)parent2;
            if (UnnecessaryExplicitNumericCastInspection.isPrimitiveNumericCastNecessary(typeCastExpression)) {
                return;
            }
            PsiElement grandParent = parent2.getParent();
            while (grandParent instanceof PsiParenthesizedExpression) {
                parent2 = grandParent;
                grandParent = parent2.getParent();
            }
            PsiExpression operand = typeCastExpression.getOperand();
            if (operand == null) {
                parent2.delete();
            } else {
                parent2.replace(operand);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/numeric/UnnecessaryExplicitNumericCastInspection$UnnecessaryExplicitNumericCastFix", "getFamilyName"));
        }
    }
}

