/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.performance;

import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiReferenceParameterList;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.util.PsiTreeUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CollectionContainsUrlInspection
extends BaseInspection {
    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("collection.contains.url.display.name", new Object[0]);
        if (string == null) {
            CollectionContainsUrlInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos2) {
        ClassType type2 = (ClassType)((Object)infos2[0]);
        String string = InspectionGadgetsBundle.message("collection.contains.url.problem.decriptor", new Object[]{type2});
        if (string == null) {
            CollectionContainsUrlInspection.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new CollectionContainsUrlVisitor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/siyeh/ig/performance/CollectionContainsUrlInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "buildErrorString";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    static enum ClassType {
        SET,
        MAP,
        OTHER;


        @NotNull
        public String toString() {
            String string = super.toString();
            String string2 = string.charAt(0) + string.substring(1).toLowerCase();
            if (string2 == null) {
                ClassType.$$$reportNull$$$0(0);
            }
            return string2;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/performance/CollectionContainsUrlInspection$ClassType", "toString"));
        }
    }

    private static class UrlAddedVisitor
    extends JavaRecursiveElementWalkingVisitor {
        private boolean urlAdded;
        private final PsiVariable variable;
        private final ClassType collectionType;

        UrlAddedVisitor(PsiVariable variable2, ClassType collectionType) {
            this.variable = variable2;
            this.collectionType = collectionType;
        }

        @Override
        public void visitMethodCallExpression(PsiMethodCallExpression expression2) {
            if (this.urlAdded) {
                return;
            }
            super.visitMethodCallExpression(expression2);
            PsiReferenceExpression methodExpression = expression2.getMethodExpression();
            PsiExpression qualifierExpression = methodExpression.getQualifierExpression();
            if (!(qualifierExpression instanceof PsiReferenceExpression)) {
                return;
            }
            PsiReferenceExpression referenceExpression = (PsiReferenceExpression)qualifierExpression;
            String methodName = methodExpression.getReferenceName();
            if (this.collectionType == ClassType.SET && !"add".equals(methodName)) {
                return;
            }
            if (this.collectionType == ClassType.MAP && !"put".equals(methodName)) {
                return;
            }
            PsiExpressionList argumentList2 = expression2.getArgumentList();
            PsiExpression[] arguments2 = argumentList2.getExpressions();
            if (arguments2.length != 1) {
                return;
            }
            PsiExpression argument = arguments2[0];
            PsiType argumentType = argument.getType();
            if (argumentType == null || !argumentType.equalsToText("java.net.URL")) {
                return;
            }
            PsiElement element = referenceExpression.resolve();
            if (!this.variable.equals(element)) {
                return;
            }
            this.urlAdded = true;
        }

        boolean isUrlAdded() {
            return this.urlAdded;
        }
    }

    private static class CollectionContainsUrlVisitor
    extends BaseInspectionVisitor {
        private CollectionContainsUrlVisitor() {
        }

        @Override
        public void visitVariable(PsiVariable variable2) {
            super.visitVariable(variable2);
            PsiTypeElement typeElement = variable2.getTypeElement();
            if (typeElement == null) {
                return;
            }
            PsiType type2 = typeElement.getType();
            if (!(type2 instanceof PsiClassType)) {
                return;
            }
            PsiJavaCodeReferenceElement referenceElement = typeElement.getInnermostComponentReferenceElement();
            if (referenceElement == null) {
                return;
            }
            PsiClassType classType = (PsiClassType)type2;
            PsiClass aClass2 = classType.resolve();
            ClassType collectionType = CollectionContainsUrlVisitor.getClassType(aClass2);
            if (collectionType == ClassType.OTHER) {
                return;
            }
            PsiReferenceParameterList parameterList = referenceElement.getParameterList();
            if (parameterList == null || parameterList.getTypeParameterElements().length == 0) {
                PsiMember member = PsiTreeUtil.getParentOfType((PsiElement)variable2, PsiMember.class);
                if (member == null) {
                    return;
                }
                UrlAddedVisitor visitor2 = new UrlAddedVisitor(variable2, collectionType);
                member.accept(visitor2);
                if (visitor2.isUrlAdded()) {
                    this.registerVariableError(variable2, new Object[]{collectionType});
                }
                return;
            }
            PsiType[] typeArguments2 = parameterList.getTypeArguments();
            boolean containsUrl = false;
            for (PsiType typeArgument : typeArguments2) {
                if (!typeArgument.equalsToText("java.net.URL")) continue;
                containsUrl = true;
                break;
            }
            if (!containsUrl) {
                return;
            }
            this.registerVariableError(variable2, new Object[]{collectionType});
        }

        private static ClassType getClassType(@Nullable PsiClass aClass2) {
            return CollectionContainsUrlVisitor.isMapOrSet(aClass2, new HashSet<PsiClass>());
        }

        private static ClassType isMapOrSet(@Nullable PsiClass aClass2, Set<PsiClass> visitedClasses) {
            PsiClass[] supers;
            if (aClass2 == null) {
                return ClassType.OTHER;
            }
            if (!visitedClasses.add(aClass2)) {
                return ClassType.OTHER;
            }
            String className2 = aClass2.getQualifiedName();
            if ("java.util.Set".equals(className2)) {
                return ClassType.SET;
            }
            if ("java.util.Map".equals(className2)) {
                return ClassType.MAP;
            }
            for (PsiClass aSuper : supers = aClass2.getSupers()) {
                ClassType classType = CollectionContainsUrlVisitor.isMapOrSet(aSuper, visitedClasses);
                if (classType == ClassType.OTHER) continue;
                return classType;
            }
            return ClassType.OTHER;
        }
    }
}

