/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.performance;

import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiDeclarationStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiForeachStatement;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeCastExpression;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.codeStyle.SuggestedNameInfo;
import com.intellij.psi.codeStyle.VariableKind;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.RedundantCastUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.PsiReplacementUtil;
import com.siyeh.ig.psiutils.EquivalenceChecker;
import com.siyeh.ig.psiutils.ParenthesesUtils;
import com.siyeh.ig.psiutils.TypeUtils;
import com.siyeh.ig.psiutils.VariableAccessUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class KeySetIterationMayUseEntrySetInspection
extends BaseInspection {
    @Override
    @NotNull
    @Nls
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("key.set.iteration.may.use.entry.set.display.name", new Object[0]);
        if (string == null) {
            KeySetIterationMayUseEntrySetInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos2) {
        String string = InspectionGadgetsBundle.message("key.set.iteration.may.use.entry.set.problem.descriptor", new Object[0]);
        if (string == null) {
            KeySetIterationMayUseEntrySetInspection.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Override
    protected InspectionGadgetsFix buildFix(Object ... infos2) {
        return new KeySetIterationMapUseEntrySetFix();
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new KeySetIterationMayUseEntrySetVisitor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/siyeh/ig/performance/KeySetIterationMayUseEntrySetInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "buildErrorString";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    private static class GetValueFromMapChecker
    extends JavaRecursiveElementWalkingVisitor {
        private final PsiVariable key;
        private final PsiReferenceExpression mapReference;
        private boolean getValueFromMap;
        private boolean tainted;

        GetValueFromMapChecker(@NotNull PsiReferenceExpression mapReference, @NotNull PsiVariable key) {
            if (mapReference == null) {
                GetValueFromMapChecker.$$$reportNull$$$0(0);
            }
            if (key == null) {
                GetValueFromMapChecker.$$$reportNull$$$0(1);
            }
            this.mapReference = mapReference;
            this.key = key;
        }

        @Override
        public void visitReferenceExpression(PsiReferenceExpression expression2) {
            if (this.tainted) {
                return;
            }
            super.visitReferenceExpression(expression2);
            PsiElement parent2 = ParenthesesUtils.getParentSkipParentheses(expression2);
            if (parent2 instanceof PsiAssignmentExpression) {
                PsiElement target = expression2.resolve();
                if (this.key.equals(target) || EquivalenceChecker.getCanonicalPsiEquivalence().expressionsAreEquivalent(this.mapReference, expression2)) {
                    this.tainted = true;
                }
            } else if (!(parent2 instanceof PsiReferenceExpression)) {
                return;
            }
            PsiElement grandParent = parent2.getParent();
            if (!(grandParent instanceof PsiMethodCallExpression)) {
                return;
            }
            PsiMethodCallExpression methodCallExpression = (PsiMethodCallExpression)grandParent;
            PsiReferenceExpression methodExpression = (PsiReferenceExpression)parent2;
            if (!EquivalenceChecker.getCanonicalPsiEquivalence().expressionsAreEquivalent(this.mapReference, expression2)) {
                return;
            }
            String methodName = methodExpression.getReferenceName();
            if (!"get".equals(methodName)) {
                return;
            }
            PsiExpressionList argumentList2 = methodCallExpression.getArgumentList();
            PsiExpression[] arguments2 = argumentList2.getExpressions();
            if (arguments2.length != 1) {
                return;
            }
            PsiExpression argument = ParenthesesUtils.stripParentheses(arguments2[0]);
            if (!(argument instanceof PsiReferenceExpression)) {
                return;
            }
            PsiReferenceExpression referenceExpression = (PsiReferenceExpression)argument;
            PsiElement argumentTarget = referenceExpression.resolve();
            if (!this.key.equals(argumentTarget)) {
                return;
            }
            this.getValueFromMap = true;
        }

        boolean isGetValueFromMap() {
            return this.getValueFromMap && !this.tainted;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "mapReference";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "key";
                    break;
                }
            }
            objectArray[1] = "com/siyeh/ig/performance/KeySetIterationMayUseEntrySetInspection$GetValueFromMapChecker";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class KeySetIterationMayUseEntrySetVisitor
    extends BaseInspectionVisitor {
        private KeySetIterationMayUseEntrySetVisitor() {
        }

        @Override
        public void visitForeachStatement(PsiForeachStatement statement2) {
            PsiExpression iteratedExpression;
            super.visitForeachStatement(statement2);
            PsiExpression iteratedValue = ParenthesesUtils.stripParentheses(statement2.getIteratedValue());
            if (iteratedValue == null) {
                return;
            }
            if (iteratedValue instanceof PsiReferenceExpression) {
                PsiReferenceExpression referenceExpression = (PsiReferenceExpression)iteratedValue;
                PsiElement target = referenceExpression.resolve();
                if (!(target instanceof PsiLocalVariable)) {
                    return;
                }
                PsiVariable variable2 = (PsiVariable)target;
                PsiMethod containingMethod = PsiTreeUtil.getParentOfType((PsiElement)variable2, PsiMethod.class);
                if (VariableAccessUtils.variableIsAssignedAtPoint(variable2, containingMethod, statement2)) {
                    return;
                }
                iteratedExpression = variable2.getInitializer();
            } else {
                iteratedExpression = iteratedValue;
            }
            PsiParameter parameter = statement2.getIterationParameter();
            if (!KeySetIterationMayUseEntrySetVisitor.isMapKeySetIteration(iteratedExpression, parameter, statement2.getBody())) {
                return;
            }
            this.registerError((PsiElement)iteratedValue, new Object[0]);
        }

        private static boolean isMapKeySetIteration(PsiExpression iteratedExpression, PsiVariable key, @Nullable PsiElement context) {
            if (context == null) {
                return false;
            }
            if (!(iteratedExpression instanceof PsiMethodCallExpression)) {
                return false;
            }
            PsiMethodCallExpression methodCallExpression = (PsiMethodCallExpression)iteratedExpression;
            PsiReferenceExpression methodExpression = methodCallExpression.getMethodExpression();
            String methodName = methodExpression.getReferenceName();
            if (!"keySet".equals(methodName)) {
                return false;
            }
            PsiExpression expression2 = methodExpression.getQualifierExpression();
            if (!(expression2 instanceof PsiReferenceExpression)) {
                return false;
            }
            PsiReferenceExpression referenceExpression = (PsiReferenceExpression)expression2;
            if (!TypeUtils.expressionHasTypeOrSubtype((PsiExpression)referenceExpression, "java.util.Map")) {
                return false;
            }
            GetValueFromMapChecker checker = new GetValueFromMapChecker(referenceExpression, key);
            context.accept(checker);
            return checker.isGetValueFromMap();
        }
    }

    private static class KeySetIterationMapUseEntrySetFix
    extends InspectionGadgetsFix {
        private KeySetIterationMapUseEntrySetFix() {
        }

        @Override
        @NotNull
        public String getFamilyName() {
            String string = InspectionGadgetsBundle.message("key.set.iteration.may.use.entry.set.quickfix", new Object[0]);
            if (string == null) {
                KeySetIterationMapUseEntrySetFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        @Override
        protected void doFix(Project project, ProblemDescriptor descriptor2) {
            PsiModifierList modifierList;
            PsiExpression keySetExpression;
            PsiVariable toRemove;
            PsiElement element = descriptor2.getPsiElement();
            PsiElement parent2 = ParenthesesUtils.getParentSkipParentheses(element);
            if (!(parent2 instanceof PsiForeachStatement)) {
                return;
            }
            if (element instanceof PsiReferenceExpression) {
                PsiReferenceExpression referenceExpression = (PsiReferenceExpression)element;
                PsiElement target = referenceExpression.resolve();
                if (!(target instanceof PsiLocalVariable)) {
                    return;
                }
                toRemove = (PsiVariable)target;
                keySetExpression = toRemove.getInitializer();
            } else {
                toRemove = null;
                keySetExpression = (PsiExpression)element;
            }
            if (!(keySetExpression instanceof PsiMethodCallExpression)) {
                return;
            }
            PsiMethodCallExpression methodCallExpression = (PsiMethodCallExpression)keySetExpression;
            PsiReferenceExpression methodExpression = methodCallExpression.getMethodExpression();
            PsiExpression qualifier = methodExpression.getQualifierExpression();
            if (!(qualifier instanceof PsiReferenceExpression)) {
                return;
            }
            PsiReplacementUtil.replaceExpression((PsiExpression)element, qualifier.getText() + ".entrySet()");
            PsiForeachStatement foreachStatement = (PsiForeachStatement)parent2;
            PsiMethodCallExpression iteratedValue = (PsiMethodCallExpression)ParenthesesUtils.stripParentheses(foreachStatement.getIteratedValue());
            if (iteratedValue == null) {
                return;
            }
            PsiReferenceExpression expression2 = iteratedValue.getMethodExpression();
            PsiReferenceExpression mapReference = (PsiReferenceExpression)expression2.getQualifierExpression();
            PsiType type2 = iteratedValue.getType();
            if (!(type2 instanceof PsiClassType)) {
                return;
            }
            PsiClassType classType = (PsiClassType)type2;
            PsiType[] parameterTypes = classType.getParameters();
            PsiType newParameterType = parameterTypes.length == 1 ? parameterTypes[0] : null;
            boolean insertCast = false;
            if (newParameterType == null) {
                newParameterType = TypeUtils.getObjectType(foreachStatement);
                insertCast = true;
            }
            PsiParameter oldParameter = foreachStatement.getIterationParameter();
            String oldParameterName = oldParameter.getName();
            String oldParameterTypeText = oldParameter.getType().getCanonicalText();
            String variableName = KeySetIterationMapUseEntrySetFix.createNewVariableName(foreachStatement, newParameterType);
            PsiParameter newParameter = JavaPsiFacade.getElementFactory(project).createParameter(variableName, newParameterType);
            if (oldParameter.hasModifierProperty("final") && (modifierList = newParameter.getModifierList()) != null) {
                modifierList.setModifierProperty("final", true);
            }
            oldParameter.replace(newParameter);
            if (insertCast) {
                KeySetIterationMapUseEntrySetFix.replaceParameterAccess(oldParameterName, oldParameterTypeText, "((Map.Entry)" + variableName + ')', mapReference, foreachStatement.getBody());
            } else {
                KeySetIterationMapUseEntrySetFix.replaceParameterAccess(oldParameterName, oldParameterTypeText, variableName, mapReference, foreachStatement.getBody());
            }
            if (toRemove != null && ReferencesSearch.search(toRemove).findFirst() == null) {
                PsiElement statement2 = toRemove.getParent();
                if (statement2 instanceof PsiDeclarationStatement && ((PsiDeclarationStatement)statement2).getDeclaredElements().length == 1) {
                    statement2.delete();
                } else {
                    toRemove.delete();
                }
            }
        }

        private static void replaceParameterAccess(String parameterName, String typeText, @NonNls String variableName, PsiReferenceExpression mapReference, PsiElement body) {
            ParameterAccessCollector collector2 = new ParameterAccessCollector(parameterName, mapReference);
            body.accept(collector2);
            List<PsiExpression> accesses = collector2.getParameterAccesses();
            String keyAccess = '(' + typeText + ')' + variableName + ".getKey()";
            for (PsiExpression access : accesses) {
                if (access instanceof PsiMethodCallExpression) {
                    PsiReplacementUtil.replaceExpression(access, variableName + ".getValue()");
                    continue;
                }
                PsiTypeCastExpression typeCastExpression = (PsiTypeCastExpression)PsiReplacementUtil.replaceExpressionAndShorten(access, keyAccess);
                if (!RedundantCastUtil.isCastRedundant(typeCastExpression)) continue;
                PsiExpression operand = typeCastExpression.getOperand();
                assert (operand != null);
                typeCastExpression.replace(operand);
            }
        }

        private static String createNewVariableName(@NotNull PsiElement scope, @NotNull PsiType type2) {
            String baseName;
            if (scope == null) {
                KeySetIterationMapUseEntrySetFix.$$$reportNull$$$0(1);
            }
            if (type2 == null) {
                KeySetIterationMapUseEntrySetFix.$$$reportNull$$$0(2);
            }
            JavaCodeStyleManager codeStyleManager = JavaCodeStyleManager.getInstance(scope.getProject());
            SuggestedNameInfo suggestions = codeStyleManager.suggestVariableName(VariableKind.LOCAL_VARIABLE, null, null, type2);
            String string = baseName = suggestions.names != null && suggestions.names.length > 0 ? suggestions.names[0] : "entry";
            if (baseName == null || baseName.isEmpty()) {
                baseName = "entry";
            }
            return codeStyleManager.suggestUniqueVariableName(baseName, scope, true);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 1: 
                case 2: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 1: 
                case 2: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/siyeh/ig/performance/KeySetIterationMayUseEntrySetInspection$KeySetIterationMapUseEntrySetFix";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "scope";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "type";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/siyeh/ig/performance/KeySetIterationMayUseEntrySetInspection$KeySetIterationMapUseEntrySetFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "createNewVariableName";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 1: 
                case 2: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }

        private static class ParameterAccessCollector
        extends JavaRecursiveElementWalkingVisitor {
            private final PsiReferenceExpression mapReference;
            private final String parameterName;
            private final List<PsiExpression> parameterAccesses = new ArrayList<PsiExpression>();

            ParameterAccessCollector(String parameterName, PsiReferenceExpression mapReference) {
                this.parameterName = parameterName;
                this.mapReference = mapReference;
            }

            @Override
            public void visitReferenceExpression(PsiReferenceExpression expression2) {
                super.visitReferenceExpression(expression2);
                if (expression2.getQualifierExpression() != null || !expression2.getText().equals(this.parameterName)) {
                    return;
                }
                if (!this.collectValueUsage(expression2)) {
                    this.parameterAccesses.add(expression2);
                }
            }

            private boolean collectValueUsage(PsiReferenceExpression expression2) {
                PsiElement parent2 = ParenthesesUtils.getParentSkipParentheses(expression2);
                if (!(parent2 instanceof PsiExpressionList)) {
                    return false;
                }
                PsiElement grandParent = parent2.getParent();
                if (!(grandParent instanceof PsiMethodCallExpression)) {
                    return false;
                }
                PsiMethodCallExpression methodCallExpression = (PsiMethodCallExpression)grandParent;
                PsiReferenceExpression methodExpression = methodCallExpression.getMethodExpression();
                String methodName = methodExpression.getReferenceName();
                if (!"get".equals(methodName)) {
                    return false;
                }
                PsiExpression qualifier = ParenthesesUtils.stripParentheses(methodExpression.getQualifierExpression());
                if (!(qualifier instanceof PsiReferenceExpression)) {
                    return false;
                }
                PsiReferenceExpression referenceExpression = (PsiReferenceExpression)qualifier;
                if (!EquivalenceChecker.getCanonicalPsiEquivalence().expressionsAreEquivalent(this.mapReference, referenceExpression)) {
                    return false;
                }
                this.parameterAccesses.add(methodCallExpression);
                return true;
            }

            List<PsiExpression> getParameterAccesses() {
                Collections.reverse(this.parameterAccesses);
                return this.parameterAccesses;
            }
        }
    }
}

