/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.performance;

import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiArrayAccessExpression;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiBinaryExpression;
import com.intellij.psi.PsiBlockStatement;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiDeclarationStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiForStatement;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.IncorrectOperationException;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.PsiReplacementUtil;
import com.siyeh.ig.psiutils.ExpressionUtils;
import com.siyeh.ig.psiutils.ParenthesesUtils;
import com.siyeh.ig.psiutils.SideEffectChecker;
import com.siyeh.ig.psiutils.VariableAccessUtils;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ManualArrayCopyInspection
extends BaseInspection {
    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("manual.array.copy.display.name", new Object[0]);
        if (string == null) {
            ManualArrayCopyInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    public boolean isEnabledByDefault() {
        return true;
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos2) {
        String string = InspectionGadgetsBundle.message("manual.array.copy.problem.descriptor", new Object[0]);
        if (string == null) {
            ManualArrayCopyInspection.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new ManualArrayCopyVisitor();
    }

    @Override
    public InspectionGadgetsFix buildFix(Object ... infos2) {
        Boolean decrement = (Boolean)infos2[0];
        return new ManualArrayCopyFix(decrement);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/siyeh/ig/performance/ManualArrayCopyInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "buildErrorString";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    private static class ManualArrayCopyVisitor
    extends BaseInspectionVisitor {
        private ManualArrayCopyVisitor() {
        }

        @Override
        public void visitForStatement(@NotNull PsiForStatement statement2) {
            boolean decrement;
            if (statement2 == null) {
                ManualArrayCopyVisitor.$$$reportNull$$$0(0);
            }
            super.visitForStatement(statement2);
            PsiStatement initialization = statement2.getInitialization();
            if (!(initialization instanceof PsiDeclarationStatement)) {
                return;
            }
            PsiDeclarationStatement declaration = (PsiDeclarationStatement)initialization;
            PsiElement[] declaredElements = declaration.getDeclaredElements();
            if (declaredElements.length != 1) {
                return;
            }
            PsiElement declaredElement = declaredElements[0];
            if (!(declaredElement instanceof PsiLocalVariable)) {
                return;
            }
            PsiLocalVariable variable2 = (PsiLocalVariable)declaredElement;
            PsiExpression initialValue = variable2.getInitializer();
            if (initialValue == null) {
                return;
            }
            PsiStatement update = statement2.getUpdate();
            if (VariableAccessUtils.variableIsIncremented(variable2, update)) {
                decrement = false;
            } else if (VariableAccessUtils.variableIsDecremented(variable2, update)) {
                decrement = true;
            } else {
                return;
            }
            PsiExpression condition = statement2.getCondition();
            if (decrement ? !ExpressionUtils.isVariableGreaterThanComparison(condition, variable2) : !ExpressionUtils.isVariableLessThanComparison(condition, variable2)) {
                return;
            }
            PsiStatement body = statement2.getBody();
            if (!ManualArrayCopyVisitor.bodyIsArrayCopy(body, variable2, null)) {
                return;
            }
            this.registerStatementError(statement2, decrement);
        }

        private static boolean bodyIsArrayCopy(PsiStatement body, PsiVariable variable2, @Nullable PsiVariable variable22) {
            if (body instanceof PsiExpressionStatement) {
                PsiExpressionStatement exp = (PsiExpressionStatement)body;
                PsiExpression expression2 = exp.getExpression();
                return ManualArrayCopyVisitor.expressionIsArrayCopy(expression2, variable2, variable22);
            }
            if (body instanceof PsiBlockStatement) {
                PsiBlockStatement blockStatement = (PsiBlockStatement)body;
                PsiCodeBlock codeBlock = blockStatement.getCodeBlock();
                PsiStatement[] statements = codeBlock.getStatements();
                if (statements.length == 1) {
                    return ManualArrayCopyVisitor.bodyIsArrayCopy(statements[0], variable2, variable22);
                }
                if (statements.length == 2) {
                    PsiStatement statement2 = statements[0];
                    if (!(statement2 instanceof PsiDeclarationStatement)) {
                        return false;
                    }
                    PsiDeclarationStatement declarationStatement = (PsiDeclarationStatement)statement2;
                    PsiElement[] declaredElements = declarationStatement.getDeclaredElements();
                    if (declaredElements.length != 1) {
                        return false;
                    }
                    PsiElement declaredElement = declaredElements[0];
                    if (!(declaredElement instanceof PsiVariable)) {
                        return false;
                    }
                    PsiVariable localVariable = (PsiVariable)declaredElement;
                    PsiExpression initializer2 = localVariable.getInitializer();
                    if (!ExpressionUtils.isOffsetArrayAccess(initializer2, variable2)) {
                        return false;
                    }
                    return ManualArrayCopyVisitor.bodyIsArrayCopy(statements[1], variable2, localVariable);
                }
            }
            return false;
        }

        private static boolean expressionIsArrayCopy(@Nullable PsiExpression expression2, @NotNull PsiVariable variable2, @Nullable PsiVariable variable22) {
            PsiExpression strippedRhs;
            PsiExpression strippedLhs;
            PsiExpression strippedExpression;
            if (variable2 == null) {
                ManualArrayCopyVisitor.$$$reportNull$$$0(1);
            }
            if ((strippedExpression = ParenthesesUtils.stripParentheses(expression2)) == null) {
                return false;
            }
            if (!(strippedExpression instanceof PsiAssignmentExpression)) {
                return false;
            }
            PsiAssignmentExpression assignment = (PsiAssignmentExpression)strippedExpression;
            IElementType tokenType = assignment.getOperationTokenType();
            if (!tokenType.equals(JavaTokenType.EQ)) {
                return false;
            }
            PsiExpression lhs = assignment.getLExpression();
            if (SideEffectChecker.mayHaveSideEffects(lhs)) {
                return false;
            }
            if (!ExpressionUtils.isOffsetArrayAccess(lhs, variable2)) {
                return false;
            }
            PsiExpression rhs = assignment.getRExpression();
            if (rhs == null) {
                return false;
            }
            if (SideEffectChecker.mayHaveSideEffects(rhs)) {
                return false;
            }
            if (!ManualArrayCopyVisitor.areExpressionsCopyable(lhs, rhs)) {
                return false;
            }
            PsiType type2 = lhs.getType();
            if (type2 instanceof PsiPrimitiveType && !ManualArrayCopyVisitor.areExpressionsCopyable(strippedLhs = ParenthesesUtils.stripParentheses(lhs), strippedRhs = ParenthesesUtils.stripParentheses(rhs))) {
                return false;
            }
            if (variable22 == null) {
                return ExpressionUtils.isOffsetArrayAccess(rhs, variable2);
            }
            return VariableAccessUtils.evaluatesToVariable(rhs, variable22);
        }

        private static boolean areExpressionsCopyable(@Nullable PsiExpression lhs, @Nullable PsiExpression rhs) {
            if (lhs == null || rhs == null) {
                return false;
            }
            PsiType lhsType = lhs.getType();
            if (lhsType == null) {
                return false;
            }
            PsiType rhsType = rhs.getType();
            if (rhsType == null) {
                return false;
            }
            return !(lhsType instanceof PsiPrimitiveType ? !lhsType.equals(rhsType) : !lhsType.isAssignableFrom(rhsType) || rhsType instanceof PsiPrimitiveType);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "statement";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "variable";
                    break;
                }
            }
            objectArray2[1] = "com/siyeh/ig/performance/ManualArrayCopyInspection$ManualArrayCopyVisitor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitForStatement";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "expressionIsArrayCopy";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class ManualArrayCopyFix
    extends InspectionGadgetsFix {
        private final boolean decrement;

        public ManualArrayCopyFix(boolean decrement) {
            this.decrement = decrement;
        }

        @Override
        @NotNull
        public String getFamilyName() {
            String string = InspectionGadgetsBundle.message("manual.array.copy.replace.quickfix", new Object[0]);
            if (string == null) {
                ManualArrayCopyFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        @Override
        public void doFix(Project project, ProblemDescriptor descriptor2) throws IncorrectOperationException {
            PsiElement forElement2 = descriptor2.getPsiElement();
            PsiForStatement forStatement = (PsiForStatement)forElement2.getParent();
            String newExpression = this.buildSystemArrayCopyText(forStatement);
            if (newExpression == null) {
                return;
            }
            PsiReplacementUtil.replaceStatement(forStatement, newExpression);
        }

        @Nullable
        private String buildSystemArrayCopyText(PsiForStatement forStatement) throws IncorrectOperationException {
            PsiExpression condition = forStatement.getCondition();
            PsiBinaryExpression binaryExpression = (PsiBinaryExpression)ParenthesesUtils.stripParentheses(condition);
            if (binaryExpression == null) {
                return null;
            }
            IElementType tokenType = binaryExpression.getOperationTokenType();
            PsiExpression limit = this.decrement ^ JavaTokenType.LT.equals(tokenType) || JavaTokenType.LE.equals(tokenType) ? binaryExpression.getROperand() : binaryExpression.getLOperand();
            if (limit == null) {
                return null;
            }
            PsiStatement initialization = forStatement.getInitialization();
            if (initialization == null) {
                return null;
            }
            if (!(initialization instanceof PsiDeclarationStatement)) {
                return null;
            }
            PsiDeclarationStatement declaration = (PsiDeclarationStatement)initialization;
            PsiElement[] declaredElements = declaration.getDeclaredElements();
            if (declaredElements.length != 1) {
                return null;
            }
            PsiElement declaredElement = declaredElements[0];
            if (!(declaredElement instanceof PsiLocalVariable)) {
                return null;
            }
            PsiLocalVariable variable2 = (PsiLocalVariable)declaredElement;
            PsiExpression initializer2 = variable2.getInitializer();
            String lengthText = this.decrement ? ManualArrayCopyFix.buildLengthText(initializer2, limit, JavaTokenType.LE.equals(tokenType) || JavaTokenType.GE.equals(tokenType)) : ManualArrayCopyFix.buildLengthText(limit, initializer2, JavaTokenType.LE.equals(tokenType) || JavaTokenType.GE.equals(tokenType));
            if (lengthText == null) {
                return null;
            }
            PsiArrayAccessExpression lhs = ManualArrayCopyFix.getLhsArrayAccessExpression(forStatement);
            if (lhs == null) {
                return null;
            }
            PsiExpression lArray = lhs.getArrayExpression();
            String toArrayText = lArray.getText();
            PsiArrayAccessExpression rhs = ManualArrayCopyFix.getRhsArrayAccessExpression(forStatement);
            if (rhs == null) {
                return null;
            }
            PsiExpression rArray = rhs.getArrayExpression();
            String fromArrayText = rArray.getText();
            PsiExpression rhsIndexExpression = rhs.getIndexExpression();
            PsiExpression strippedRhsIndexExpression = ParenthesesUtils.stripParentheses(rhsIndexExpression);
            PsiExpression limitExpression = this.decrement ? limit : initializer2;
            String fromOffsetText = ManualArrayCopyFix.buildOffsetText(strippedRhsIndexExpression, variable2, limitExpression, this.decrement && (JavaTokenType.LT.equals(tokenType) || JavaTokenType.GT.equals(tokenType)));
            PsiExpression lhsIndexExpression = lhs.getIndexExpression();
            PsiExpression strippedLhsIndexExpression = ParenthesesUtils.stripParentheses(lhsIndexExpression);
            String toOffsetText = ManualArrayCopyFix.buildOffsetText(strippedLhsIndexExpression, variable2, limitExpression, this.decrement && (JavaTokenType.LT.equals(tokenType) || JavaTokenType.GT.equals(tokenType)));
            StringBuilder buffer = new StringBuilder(60);
            buffer.append("System.arraycopy(");
            buffer.append(fromArrayText);
            buffer.append(", ");
            buffer.append(fromOffsetText);
            buffer.append(", ");
            buffer.append(toArrayText);
            buffer.append(", ");
            buffer.append(toOffsetText);
            buffer.append(", ");
            buffer.append(lengthText);
            buffer.append(");");
            return buffer.toString();
        }

        @Nullable
        private static PsiArrayAccessExpression getLhsArrayAccessExpression(PsiForStatement forStatement) {
            PsiStatement body = forStatement.getBody();
            while (body instanceof PsiBlockStatement) {
                PsiBlockStatement blockStatement = (PsiBlockStatement)body;
                PsiCodeBlock codeBlock = blockStatement.getCodeBlock();
                PsiStatement[] statements = codeBlock.getStatements();
                if (statements.length == 2) {
                    body = statements[1];
                    continue;
                }
                if (statements.length == 1) {
                    body = statements[0];
                    continue;
                }
                return null;
            }
            if (!(body instanceof PsiExpressionStatement)) {
                return null;
            }
            PsiExpressionStatement expressionStatement = (PsiExpressionStatement)body;
            PsiExpression expression2 = expressionStatement.getExpression();
            if (!(expression2 instanceof PsiAssignmentExpression)) {
                return null;
            }
            PsiAssignmentExpression assignmentExpression = (PsiAssignmentExpression)expression2;
            PsiExpression lhs = assignmentExpression.getLExpression();
            PsiExpression deparenthesizedExpression = ParenthesesUtils.stripParentheses(lhs);
            if (!(deparenthesizedExpression instanceof PsiArrayAccessExpression)) {
                return null;
            }
            return (PsiArrayAccessExpression)deparenthesizedExpression;
        }

        @Nullable
        private static PsiArrayAccessExpression getRhsArrayAccessExpression(PsiForStatement forStatement) {
            PsiExpression arrayAccessExpression;
            PsiStatement body = forStatement.getBody();
            while (body instanceof PsiBlockStatement) {
                PsiBlockStatement blockStatement = (PsiBlockStatement)body;
                PsiCodeBlock codeBlock = blockStatement.getCodeBlock();
                PsiStatement[] statements = codeBlock.getStatements();
                if (statements.length == 1 || statements.length == 2) {
                    body = statements[0];
                    continue;
                }
                return null;
            }
            if (body instanceof PsiDeclarationStatement) {
                PsiDeclarationStatement declarationStatement = (PsiDeclarationStatement)body;
                PsiElement[] declaredElements = declarationStatement.getDeclaredElements();
                if (declaredElements.length != 1) {
                    return null;
                }
                PsiElement declaredElement = declaredElements[0];
                if (!(declaredElement instanceof PsiVariable)) {
                    return null;
                }
                PsiVariable variable2 = (PsiVariable)declaredElement;
                arrayAccessExpression = variable2.getInitializer();
            } else if (body instanceof PsiExpressionStatement) {
                PsiExpressionStatement expressionStatement = (PsiExpressionStatement)body;
                PsiExpression expression2 = expressionStatement.getExpression();
                if (!(expression2 instanceof PsiAssignmentExpression)) {
                    return null;
                }
                PsiAssignmentExpression assignmentExpression = (PsiAssignmentExpression)expression2;
                arrayAccessExpression = assignmentExpression.getRExpression();
            } else {
                return null;
            }
            PsiExpression unparenthesizedExpression = ParenthesesUtils.stripParentheses(arrayAccessExpression);
            if (!(unparenthesizedExpression instanceof PsiArrayAccessExpression)) {
                return null;
            }
            return (PsiArrayAccessExpression)unparenthesizedExpression;
        }

        @NonNls
        @Nullable
        private static String buildLengthText(PsiExpression max, PsiExpression min, boolean plusOne) {
            if ((max = ParenthesesUtils.stripParentheses(max)) == null) {
                return null;
            }
            if ((min = ParenthesesUtils.stripParentheses(min)) == null) {
                return ManualArrayCopyFix.buildExpressionText(max, plusOne, false);
            }
            Object minConstant = ExpressionUtils.computeConstantExpression(min);
            if (minConstant instanceof Number) {
                Object maxConstant;
                Number minNumber = (Number)minConstant;
                int minValue = plusOne ? minNumber.intValue() - 1 : minNumber.intValue();
                if (minValue == 0) {
                    return ManualArrayCopyFix.buildExpressionText(max, false, false);
                }
                if (max instanceof PsiLiteralExpression && (maxConstant = ExpressionUtils.computeConstantExpression(max)) instanceof Number) {
                    Number number = (Number)maxConstant;
                    return String.valueOf(number.intValue() - minValue);
                }
                String maxText = ManualArrayCopyFix.buildExpressionText(max, false, false);
                if (minValue > 0) {
                    return maxText + '-' + minValue;
                }
                return maxText + '+' + -minValue;
            }
            int precedence = ParenthesesUtils.getPrecedence(min);
            String minText = precedence >= 6 ? '(' + min.getText() + ')' : min.getText();
            String maxText = ManualArrayCopyFix.buildExpressionText(max, plusOne, false);
            return maxText + '-' + minText;
        }

        private static String buildExpressionText(PsiExpression expression2, boolean plusOne, boolean parenthesize) {
            int precedence;
            PsiLiteralExpression literalExpression;
            Object value;
            if (!plusOne) {
                int precedence2 = ParenthesesUtils.getPrecedence(expression2);
                if (precedence2 > 6) {
                    return '(' + expression2.getText() + ')';
                }
                if (parenthesize && precedence2 >= 6) {
                    return '(' + expression2.getText() + ')';
                }
                return expression2.getText();
            }
            if (expression2 instanceof PsiBinaryExpression) {
                PsiExpression rhs;
                PsiBinaryExpression binaryExpression = (PsiBinaryExpression)expression2;
                IElementType tokenType = binaryExpression.getOperationTokenType();
                if (tokenType == JavaTokenType.MINUS && ExpressionUtils.isOne(rhs = binaryExpression.getROperand())) {
                    return binaryExpression.getLOperand().getText();
                }
            } else if (expression2 instanceof PsiLiteralExpression && (value = (literalExpression = (PsiLiteralExpression)expression2).getValue()) instanceof Integer) {
                Integer integer = (Integer)value;
                return String.valueOf(integer + 1);
            }
            String result2 = (precedence = ParenthesesUtils.getPrecedence(expression2)) > 6 ? '(' + expression2.getText() + ")+1" : expression2.getText() + "+1";
            if (parenthesize) {
                return '(' + result2 + ')';
            }
            return result2;
        }

        @NonNls
        @Nullable
        private static String buildOffsetText(PsiExpression expression2, PsiLocalVariable variable2, PsiExpression limitExpression, boolean plusOne) throws IncorrectOperationException {
            String variableName;
            if (expression2 == null) {
                return null;
            }
            String expressionText = expression2.getText();
            if (expressionText.equals(variableName = variable2.getName())) {
                PsiExpression initialValue = ParenthesesUtils.stripParentheses(limitExpression);
                if (initialValue == null) {
                    return null;
                }
                return ManualArrayCopyFix.buildExpressionText(initialValue, plusOne, false);
            }
            if (expression2 instanceof PsiBinaryExpression) {
                PsiBinaryExpression binaryExpression = (PsiBinaryExpression)expression2;
                PsiExpression lhs = binaryExpression.getLOperand();
                PsiExpression rhs = binaryExpression.getROperand();
                String rhsText = ManualArrayCopyFix.buildOffsetText(rhs, variable2, limitExpression, plusOne);
                PsiJavaToken sign = binaryExpression.getOperationSign();
                IElementType tokenType = sign.getTokenType();
                if (ExpressionUtils.isZero(lhs)) {
                    if (tokenType.equals(JavaTokenType.MINUS)) {
                        return '-' + rhsText;
                    }
                    return rhsText;
                }
                if (plusOne && tokenType.equals(JavaTokenType.MINUS) && ExpressionUtils.isOne(rhs)) {
                    return ManualArrayCopyFix.buildOffsetText(lhs, variable2, limitExpression, false);
                }
                String lhsText = ManualArrayCopyFix.buildOffsetText(lhs, variable2, limitExpression, plusOne);
                if (ExpressionUtils.isZero(rhs)) {
                    return lhsText;
                }
                return ManualArrayCopyFix.collapseConstant(lhsText + sign.getText() + rhsText, variable2);
            }
            return ManualArrayCopyFix.collapseConstant(expression2.getText(), variable2);
        }

        private static String collapseConstant(@NonNls String expressionText, PsiElement context) throws IncorrectOperationException {
            Project project = context.getProject();
            JavaPsiFacade psiFacade = JavaPsiFacade.getInstance(project);
            PsiElementFactory factory2 = psiFacade.getElementFactory();
            PsiExpression fromOffsetExpression = factory2.createExpressionFromText(expressionText, context);
            Object fromOffsetConstant = ExpressionUtils.computeConstantExpression(fromOffsetExpression);
            if (fromOffsetConstant != null) {
                return fromOffsetConstant.toString();
            }
            return expressionText;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/performance/ManualArrayCopyInspection$ManualArrayCopyFix", "getFamilyName"));
        }
    }
}

