/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.performance;

import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ui.SingleCheckboxOptionsPanel;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiType;
import com.intellij.util.IncorrectOperationException;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.PsiReplacementUtil;
import com.siyeh.ig.psiutils.TypeUtils;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StringConstructorInspection
extends BaseInspection {
    public boolean ignoreSubstringArguments = false;

    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("string.constructor.display.name", new Object[0]);
        if (string == null) {
            StringConstructorInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    @NotNull
    public String getID() {
        if ("RedundantStringConstructorCall" == null) {
            StringConstructorInspection.$$$reportNull$$$0(1);
        }
        return "RedundantStringConstructorCall";
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos2) {
        String string = InspectionGadgetsBundle.message("string.constructor.problem.descriptor", new Object[0]);
        if (string == null) {
            StringConstructorInspection.$$$reportNull$$$0(2);
        }
        return string;
    }

    @Override
    @Nullable
    public JComponent createOptionsPanel() {
        return new SingleCheckboxOptionsPanel(InspectionGadgetsBundle.message("string.constructor.substring.parameter.option", new Object[0]), this, "ignoreSubstringArguments");
    }

    @Override
    public boolean isEnabledByDefault() {
        return true;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new StringConstructorVisitor();
    }

    @Override
    public InspectionGadgetsFix buildFix(Object ... infos2) {
        Boolean noArguments = (Boolean)infos2[0];
        return new StringConstructorFix(noArguments);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/siyeh/ig/performance/StringConstructorInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getID";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "buildErrorString";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    private class StringConstructorVisitor
    extends BaseInspectionVisitor {
        private StringConstructorVisitor() {
        }

        @Override
        public void visitNewExpression(@NotNull PsiNewExpression expression2) {
            if (expression2 == null) {
                StringConstructorVisitor.$$$reportNull$$$0(0);
            }
            super.visitNewExpression(expression2);
            PsiType type2 = expression2.getType();
            if (!TypeUtils.isJavaLangString(type2)) {
                return;
            }
            PsiExpressionList argumentList2 = expression2.getArgumentList();
            if (argumentList2 == null) {
                return;
            }
            PsiExpression[] arguments2 = argumentList2.getExpressions();
            if (arguments2.length > 1) {
                return;
            }
            if (arguments2.length == 1) {
                PsiExpression argument = arguments2[0];
                PsiType parameterType = argument.getType();
                if (!TypeUtils.isJavaLangString(parameterType)) {
                    return;
                }
                if (StringConstructorInspection.this.ignoreSubstringArguments && this.hasSubstringArgument(argument)) {
                    return;
                }
            }
            this.registerError((PsiElement)expression2, arguments2.length == 0);
        }

        private boolean hasSubstringArgument(PsiExpression argument) {
            if (!(argument instanceof PsiMethodCallExpression)) {
                return false;
            }
            PsiMethodCallExpression methodCallExpression = (PsiMethodCallExpression)argument;
            PsiReferenceExpression methodExpression = methodCallExpression.getMethodExpression();
            PsiElement element = methodExpression.resolve();
            if (!(element instanceof PsiMethod)) {
                return false;
            }
            PsiMethod method = (PsiMethod)element;
            PsiClass aClass2 = method.getContainingClass();
            if (aClass2 == null) {
                return true;
            }
            String className2 = aClass2.getQualifiedName();
            String methodName = method.getName();
            return "java.lang.String".equals(className2) && methodName.equals("substring");
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/siyeh/ig/performance/StringConstructorInspection$StringConstructorVisitor", "visitNewExpression"));
        }
    }

    private static class StringConstructorFix
    extends InspectionGadgetsFix {
        private final String m_name;

        private StringConstructorFix(boolean noArguments) {
            this.m_name = noArguments ? InspectionGadgetsBundle.message("string.constructor.replace.empty.quickfix", new Object[0]) : InspectionGadgetsBundle.message("string.constructor.replace.arg.quickfix", new Object[0]);
        }

        @Override
        @NotNull
        public String getName() {
            String string = this.m_name;
            if (string == null) {
                StringConstructorFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        @Override
        @NotNull
        public String getFamilyName() {
            if ("Simplify" == null) {
                StringConstructorFix.$$$reportNull$$$0(1);
            }
            return "Simplify";
        }

        @Override
        public void doFix(Project project, ProblemDescriptor descriptor2) throws IncorrectOperationException {
            PsiNewExpression expression2 = (PsiNewExpression)descriptor2.getPsiElement();
            PsiExpressionList argList = expression2.getArgumentList();
            assert (argList != null);
            PsiExpression[] args = argList.getExpressions();
            String argText = args.length == 1 ? args[0].getText() : "\"\"";
            PsiReplacementUtil.replaceExpression(expression2, argText);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[2];
            objectArray2[0] = "com/siyeh/ig/performance/StringConstructorInspection$StringConstructorFix";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
            }
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
        }
    }
}

