/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.psiutils;

import com.intellij.codeInsight.ExceptionUtil;
import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.JavaResolveResult;
import com.intellij.psi.PsiAssertStatement;
import com.intellij.psi.PsiBlockStatement;
import com.intellij.psi.PsiBreakStatement;
import com.intellij.psi.PsiCallExpression;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiContinueStatement;
import com.intellij.psi.PsiDeclarationStatement;
import com.intellij.psi.PsiDisjunctionType;
import com.intellij.psi.PsiDoWhileStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiEmptyStatement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionListStatement;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiForStatement;
import com.intellij.psi.PsiForeachStatement;
import com.intellij.psi.PsiIfStatement;
import com.intellij.psi.PsiLabeledStatement;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiResourceList;
import com.intellij.psi.PsiResourceListElement;
import com.intellij.psi.PsiReturnStatement;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiSwitchLabelStatement;
import com.intellij.psi.PsiSwitchStatement;
import com.intellij.psi.PsiSynchronizedStatement;
import com.intellij.psi.PsiThrowStatement;
import com.intellij.psi.PsiTryStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiWhileStatement;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.refactoring.util.RefactoringChangeUtil;
import com.siyeh.ig.psiutils.BoolUtils;
import com.siyeh.ig.psiutils.ControlFlowUtils;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ExceptionUtils {
    private static final Set<String> s_genericExceptionTypes = new HashSet<String>(4);

    private ExceptionUtils() {
    }

    @NotNull
    public static Set<PsiClassType> calculateExceptionsThrown(@Nullable PsiElement element) {
        Set<PsiClassType> set = ExceptionUtils.calculateExceptionsThrown(element, new LinkedHashSet<PsiClassType>(5));
        if (set == null) {
            ExceptionUtils.$$$reportNull$$$0(0);
        }
        return set;
    }

    @NotNull
    public static Set<PsiClassType> calculateExceptionsThrown(@Nullable PsiElement element, @NotNull Set<PsiClassType> out) {
        if (out == null) {
            ExceptionUtils.$$$reportNull$$$0(1);
        }
        if (element == null) {
            Set<PsiClassType> set = out;
            if (set == null) {
                ExceptionUtils.$$$reportNull$$$0(2);
            }
            return set;
        }
        if (element instanceof PsiResourceList) {
            PsiResourceList resourceList = (PsiResourceList)element;
            for (PsiResourceListElement resource : resourceList) {
                out.addAll(ExceptionUtil.getCloserExceptions(resource));
            }
        }
        ExceptionsThrownVisitor visitor2 = new ExceptionsThrownVisitor(out);
        element.accept(visitor2);
        Set<PsiClassType> set = out;
        if (set == null) {
            ExceptionUtils.$$$reportNull$$$0(3);
        }
        return set;
    }

    public static boolean isGenericExceptionClass(@Nullable PsiType exceptionType) {
        if (!(exceptionType instanceof PsiClassType)) {
            return false;
        }
        PsiClassType classType = (PsiClassType)exceptionType;
        String className2 = classType.getCanonicalText();
        return s_genericExceptionTypes.contains(className2);
    }

    public static boolean isThrowableRethrown(PsiParameter throwable, PsiCodeBlock catchBlock) {
        PsiStatement lastStatement = ControlFlowUtils.getLastStatementInBlock(catchBlock);
        if (!(lastStatement instanceof PsiThrowStatement)) {
            return false;
        }
        PsiThrowStatement throwStatement = (PsiThrowStatement)lastStatement;
        PsiExpression expression2 = throwStatement.getException();
        if (!(expression2 instanceof PsiReferenceExpression)) {
            return false;
        }
        PsiReferenceExpression referenceExpression = (PsiReferenceExpression)expression2;
        PsiElement element = referenceExpression.resolve();
        return throwable.equals(element);
    }

    static boolean statementThrowsException(PsiStatement statement2) {
        if (statement2 == null) {
            return false;
        }
        if (statement2 instanceof PsiBreakStatement || statement2 instanceof PsiContinueStatement || statement2 instanceof PsiAssertStatement || statement2 instanceof PsiReturnStatement || statement2 instanceof PsiExpressionStatement || statement2 instanceof PsiExpressionListStatement || statement2 instanceof PsiForeachStatement || statement2 instanceof PsiDeclarationStatement || statement2 instanceof PsiEmptyStatement || statement2 instanceof PsiSwitchLabelStatement) {
            return false;
        }
        if (statement2 instanceof PsiThrowStatement) {
            return true;
        }
        if (statement2 instanceof PsiForStatement) {
            return ExceptionUtils.forStatementThrowsException((PsiForStatement)statement2);
        }
        if (statement2 instanceof PsiWhileStatement) {
            return ExceptionUtils.whileStatementThrowsException((PsiWhileStatement)statement2);
        }
        if (statement2 instanceof PsiDoWhileStatement) {
            return ExceptionUtils.doWhileThrowsException((PsiDoWhileStatement)statement2);
        }
        if (statement2 instanceof PsiSynchronizedStatement) {
            PsiSynchronizedStatement synchronizedStatement = (PsiSynchronizedStatement)statement2;
            PsiCodeBlock body = synchronizedStatement.getBody();
            return ExceptionUtils.blockThrowsException(body);
        }
        if (statement2 instanceof PsiBlockStatement) {
            PsiBlockStatement blockStatement = (PsiBlockStatement)statement2;
            PsiCodeBlock codeBlock = blockStatement.getCodeBlock();
            return ExceptionUtils.blockThrowsException(codeBlock);
        }
        if (statement2 instanceof PsiLabeledStatement) {
            PsiLabeledStatement labeledStatement = (PsiLabeledStatement)statement2;
            PsiStatement statementLabeled = labeledStatement.getStatement();
            return ExceptionUtils.statementThrowsException(statementLabeled);
        }
        if (statement2 instanceof PsiIfStatement) {
            return ExceptionUtils.ifStatementThrowsException((PsiIfStatement)statement2);
        }
        if (statement2 instanceof PsiTryStatement) {
            return ExceptionUtils.tryStatementThrowsException((PsiTryStatement)statement2);
        }
        if (statement2 instanceof PsiSwitchStatement) {
            return false;
        }
        return false;
    }

    static boolean blockThrowsException(@Nullable PsiCodeBlock block) {
        PsiStatement[] statements;
        if (block == null) {
            return false;
        }
        for (PsiStatement statement2 : statements = block.getStatements()) {
            if (!ExceptionUtils.statementThrowsException(statement2)) continue;
            return true;
        }
        return false;
    }

    private static boolean tryStatementThrowsException(PsiTryStatement tryStatement) {
        PsiCodeBlock tryBlock;
        PsiCodeBlock[] catchBlocks = tryStatement.getCatchBlocks();
        if (catchBlocks.length == 0 && ExceptionUtils.blockThrowsException(tryBlock = tryStatement.getTryBlock())) {
            return true;
        }
        PsiCodeBlock finallyBlock = tryStatement.getFinallyBlock();
        return ExceptionUtils.blockThrowsException(finallyBlock);
    }

    private static boolean ifStatementThrowsException(PsiIfStatement ifStatement) {
        return ExceptionUtils.statementThrowsException(ifStatement.getThenBranch()) && ExceptionUtils.statementThrowsException(ifStatement.getElseBranch());
    }

    private static boolean doWhileThrowsException(PsiDoWhileStatement doWhileStatement) {
        return ExceptionUtils.statementThrowsException(doWhileStatement.getBody());
    }

    private static boolean whileStatementThrowsException(PsiWhileStatement whileStatement) {
        PsiStatement body;
        PsiExpression condition = whileStatement.getCondition();
        return BoolUtils.isTrue(condition) && ExceptionUtils.statementThrowsException(body = whileStatement.getBody());
    }

    private static boolean forStatementThrowsException(PsiForStatement forStatement) {
        PsiStatement initialization = forStatement.getInitialization();
        if (ExceptionUtils.statementThrowsException(initialization)) {
            return true;
        }
        PsiExpression test = forStatement.getCondition();
        if (BoolUtils.isTrue(test)) {
            PsiStatement body = forStatement.getBody();
            if (ExceptionUtils.statementThrowsException(body)) {
                return true;
            }
            PsiStatement update = forStatement.getUpdate();
            if (ExceptionUtils.statementThrowsException(update)) {
                return true;
            }
        }
        return false;
    }

    public static Set<PsiType> getExceptionTypesHandled(PsiTryStatement statement2) {
        HashSet<PsiType> out = new HashSet<PsiType>(5);
        for (PsiParameter parameter : statement2.getCatchBlockParameters()) {
            PsiType type2 = parameter.getType();
            if (type2 instanceof PsiDisjunctionType) {
                PsiDisjunctionType disjunctionType = (PsiDisjunctionType)type2;
                out.addAll(disjunctionType.getDisjunctions());
                continue;
            }
            out.add(type2);
        }
        return out;
    }

    public static boolean isExceptionArgument(@NotNull PsiExpression expression2) {
        PsiMethodCallExpression methodCallExpression;
        PsiType newExpressionType;
        PsiNewExpression newExpression;
        if (expression2 == null) {
            ExceptionUtils.$$$reportNull$$$0(4);
        }
        return (newExpression = PsiTreeUtil.getParentOfType((PsiElement)expression2, PsiNewExpression.class, true, PsiCodeBlock.class, PsiClass.class)) != null ? InheritanceUtil.isInheritor(newExpressionType = newExpression.getType(), "java.lang.Throwable") : RefactoringChangeUtil.isSuperOrThisMethodCall(methodCallExpression = PsiTreeUtil.getParentOfType((PsiElement)expression2, PsiMethodCallExpression.class, true, PsiCodeBlock.class, PsiClass.class));
    }

    static {
        s_genericExceptionTypes.add("java.lang.Throwable");
        s_genericExceptionTypes.add("java.lang.Exception");
        s_genericExceptionTypes.add("java.lang.RuntimeException");
        s_genericExceptionTypes.add("java.lang.Error");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 4: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 4: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/siyeh/ig/psiutils/ExceptionUtils";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "out";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "calculateExceptionsThrown";
                break;
            }
            case 1: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "com/siyeh/ig/psiutils/ExceptionUtils";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "calculateExceptionsThrown";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "isExceptionArgument";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 4: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class ExceptionsThrownVisitor
    extends JavaRecursiveElementWalkingVisitor {
        private final Set<PsiClassType> m_exceptionsThrown;

        private ExceptionsThrownVisitor(Set<PsiClassType> thrownTypes) {
            this.m_exceptionsThrown = thrownTypes;
        }

        @Override
        public void visitClass(PsiClass aClass2) {
        }

        @Override
        public void visitLambdaExpression(PsiLambdaExpression expression2) {
        }

        @Override
        public void visitCallExpression(PsiCallExpression callExpression) {
            super.visitCallExpression(callExpression);
            JavaResolveResult resolveResult = callExpression.resolveMethodGenerics();
            PsiElement target = resolveResult.getElement();
            if (!(target instanceof PsiMethod)) {
                return;
            }
            PsiClassType[] referencedTypes = ((PsiMethod)target).getThrowsList().getReferencedTypes();
            this.m_exceptionsThrown.addAll(ExceptionUtil.collectSubstituted(resolveResult.getSubstitutor(), referencedTypes, callExpression.getResolveScope()));
        }

        @Override
        public void visitThrowStatement(PsiThrowStatement statement2) {
            super.visitThrowStatement(statement2);
            PsiExpression exception = statement2.getException();
            if (exception == null) {
                return;
            }
            PsiType type2 = exception.getType();
            if (type2 instanceof PsiClassType) {
                this.m_exceptionsThrown.add((PsiClassType)type2);
            }
        }

        @Override
        public void visitTryStatement(@NotNull PsiTryStatement statement2) {
            if (statement2 == null) {
                ExceptionsThrownVisitor.$$$reportNull$$$0(0);
            }
            Set<PsiType> exceptionsHandled = ExceptionUtils.getExceptionTypesHandled(statement2);
            for (PsiClassType resourceException : ExceptionUtils.calculateExceptionsThrown(statement2.getResourceList())) {
                if (ExceptionsThrownVisitor.isExceptionHandled(exceptionsHandled, resourceException)) continue;
                this.m_exceptionsThrown.add(resourceException);
            }
            for (PsiClassType tryException : ExceptionUtils.calculateExceptionsThrown(statement2.getTryBlock())) {
                if (ExceptionsThrownVisitor.isExceptionHandled(exceptionsHandled, tryException)) continue;
                this.m_exceptionsThrown.add(tryException);
            }
            ExceptionUtils.calculateExceptionsThrown(statement2.getFinallyBlock(), this.m_exceptionsThrown);
            for (PsiCodeBlock catchBlock : statement2.getCatchBlocks()) {
                ExceptionUtils.calculateExceptionsThrown(catchBlock, this.m_exceptionsThrown);
            }
        }

        private static boolean isExceptionHandled(Set<PsiType> exceptionsHandled, @NotNull PsiType thrownType) {
            if (thrownType == null) {
                ExceptionsThrownVisitor.$$$reportNull$$$0(1);
            }
            if (exceptionsHandled.contains(thrownType)) {
                return true;
            }
            for (PsiType exceptionHandled : exceptionsHandled) {
                if (!exceptionHandled.isAssignableFrom(thrownType)) continue;
                return true;
            }
            return false;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "statement";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "thrownType";
                    break;
                }
            }
            objectArray2[1] = "com/siyeh/ig/psiutils/ExceptionUtils$ExceptionsThrownVisitor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitTryStatement";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isExceptionHandled";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

