/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.psiutils;

import com.intellij.codeInsight.PsiEquivalenceUtil;
import com.intellij.psi.GenericsUtil;
import com.intellij.psi.PsiArrayAccessExpression;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiMethodReferenceExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.ObjectUtils;
import com.siyeh.ig.psiutils.ExpressionUtils;
import com.siyeh.ig.psiutils.MethodCallUtils;
import com.siyeh.ig.psiutils.MethodUtils;
import org.jetbrains.annotations.Nullable;

public abstract class IndexedContainer {
    private final PsiExpression myQualifier;

    protected IndexedContainer(PsiExpression qualifier) {
        this.myQualifier = PsiUtil.skipParenthesizedExprDown(qualifier);
    }

    public abstract boolean isGetMethodReference(PsiMethodReferenceExpression var1);

    public abstract PsiExpression extractGetExpressionFromIndex(@Nullable PsiExpression var1);

    public abstract PsiExpression extractIndexFromGetExpression(@Nullable PsiExpression var1);

    public PsiExpression getQualifier() {
        return this.myQualifier;
    }

    public boolean isQualifierEquivalent(@Nullable PsiExpression candidate2) {
        return (candidate2 = PsiUtil.skipParenthesizedExprDown(candidate2)) != null && PsiEquivalenceUtil.areElementsEquivalent(this.myQualifier, candidate2);
    }

    public abstract PsiType getElementType();

    @Nullable
    public static IndexedContainer fromLengthExpression(@Nullable PsiExpression expression2) {
        PsiMethodCallExpression call2;
        PsiExpression arrayExpression = ExpressionUtils.getArrayFromLengthExpression(expression2 = PsiUtil.skipParenthesizedExprDown(expression2));
        if (arrayExpression != null) {
            return new ArrayIndexedContainer(arrayExpression);
        }
        if (expression2 instanceof PsiMethodCallExpression && ListIndexedContainer.isSizeCall(call2 = (PsiMethodCallExpression)expression2)) {
            return new ListIndexedContainer(ExpressionUtils.getQualifierOrThis(call2.getMethodExpression()));
        }
        return null;
    }

    static class ListIndexedContainer
    extends IndexedContainer {
        ListIndexedContainer(PsiExpression qualifier) {
            super(qualifier);
        }

        @Override
        public boolean isGetMethodReference(PsiMethodReferenceExpression methodReference) {
            if (!"get".equals(methodReference.getReferenceName())) {
                return false;
            }
            if (!this.isQualifierEquivalent(ExpressionUtils.getQualifierOrThis(methodReference))) {
                return false;
            }
            PsiMethod method = ObjectUtils.tryCast(methodReference.resolve(), PsiMethod.class);
            return method != null && MethodUtils.methodMatches(method, "java.util.List", null, "get", PsiType.INT);
        }

        @Override
        public PsiExpression extractGetExpressionFromIndex(@Nullable PsiExpression indexExpression) {
            PsiElement gParent;
            PsiElement parent2;
            if (indexExpression != null && (parent2 = PsiUtil.skipParenthesizedExprUp(indexExpression.getParent())) instanceof PsiExpressionList && (gParent = PsiUtil.skipParenthesizedExprUp(parent2.getParent())) instanceof PsiMethodCallExpression && PsiTreeUtil.isAncestor(this.extractIndexFromGetExpression((PsiExpression)gParent), indexExpression, false)) {
                return (PsiExpression)gParent;
            }
            return null;
        }

        @Override
        public PsiExpression extractIndexFromGetExpression(@Nullable PsiExpression expression2) {
            PsiMethodCallExpression call2 = ObjectUtils.tryCast(PsiUtil.skipParenthesizedExprDown(expression2), PsiMethodCallExpression.class);
            if (call2 == null) {
                return null;
            }
            PsiExpression[] args = call2.getArgumentList().getExpressions();
            if (args.length == 1 && ListIndexedContainer.isGetCall(call2) && this.isQualifierEquivalent(ExpressionUtils.getQualifierOrThis(call2.getMethodExpression()))) {
                return args[0];
            }
            return null;
        }

        @Override
        public PsiType getElementType() {
            PsiType type2 = PsiUtil.substituteTypeParameter(this.getQualifier().getType(), "java.util.List", 0, false);
            return GenericsUtil.getVariableTypeByExpressionType(type2);
        }

        static boolean isGetCall(PsiMethodCallExpression call2) {
            return MethodCallUtils.isCallToMethod(call2, "java.util.List", null, "get", PsiType.INT);
        }

        static boolean isSizeCall(PsiMethodCallExpression call2) {
            return MethodCallUtils.isCallToMethod(call2, "java.util.List", (PsiType)PsiType.INT, "size", new PsiType[0]);
        }
    }

    static class ArrayIndexedContainer
    extends IndexedContainer {
        ArrayIndexedContainer(PsiExpression qualifier) {
            super(qualifier);
        }

        @Override
        public boolean isGetMethodReference(PsiMethodReferenceExpression methodReference) {
            return false;
        }

        @Override
        public PsiExpression extractGetExpressionFromIndex(@Nullable PsiExpression indexExpression) {
            PsiElement parent2;
            if (indexExpression != null && (parent2 = PsiUtil.skipParenthesizedExprUp(indexExpression.getParent())) instanceof PsiExpression && PsiTreeUtil.isAncestor(this.extractIndexFromGetExpression((PsiExpression)parent2), indexExpression, false)) {
                return (PsiExpression)parent2;
            }
            return null;
        }

        @Override
        public PsiExpression extractIndexFromGetExpression(@Nullable PsiExpression expression2) {
            PsiArrayAccessExpression arrayAccess;
            if ((expression2 = PsiUtil.skipParenthesizedExprDown(expression2)) instanceof PsiArrayAccessExpression && this.isQualifierEquivalent((arrayAccess = (PsiArrayAccessExpression)expression2).getArrayExpression())) {
                return arrayAccess.getIndexExpression();
            }
            return null;
        }

        @Override
        public PsiType getElementType() {
            PsiType type2 = this.getQualifier().getType();
            return type2 instanceof PsiArrayType ? ((PsiArrayType)type2).getComponentType() : null;
        }
    }
}

