/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.psiutils;

import com.intellij.codeInspection.inheritance.ImplicitSubclassProvider;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ClassInheritorsSearch;
import com.intellij.psi.search.searches.FunctionalExpressionSearch;
import com.intellij.util.Processor;
import com.intellij.util.Query;
import java.util.concurrent.atomic.AtomicInteger;
import org.jetbrains.annotations.NotNull;

public class InheritanceUtil {
    private InheritanceUtil() {
    }

    public static boolean existsMutualSubclass(PsiClass class1, final PsiClass class2, final boolean avoidExpensiveProcessing) {
        if (class1 instanceof PsiTypeParameter) {
            PsiClass[] superClasses2;
            for (PsiClass superClass : superClasses2 = class1.getSupers()) {
                if (InheritanceUtil.existsMutualSubclass(superClass, class2, avoidExpensiveProcessing)) continue;
                return false;
            }
            return true;
        }
        if (class2 instanceof PsiTypeParameter) {
            return InheritanceUtil.existsMutualSubclass(class2, class1, avoidExpensiveProcessing);
        }
        String className2 = class1.getQualifiedName();
        if ("java.lang.Object".equals(className2)) {
            return true;
        }
        String class2Name = class2.getQualifiedName();
        if ("java.lang.Object".equals(class2Name)) {
            return true;
        }
        if (class1.isInheritor(class2, true) || class2.isInheritor(class1, true)) {
            return true;
        }
        GlobalSearchScope scope = GlobalSearchScope.allScope(class1.getProject());
        Query<PsiClass> search = ClassInheritorsSearch.search(class1, scope, true);
        final boolean[] result2 = new boolean[1];
        search.forEach(new Processor<PsiClass>(){
            AtomicInteger count = new AtomicInteger(0);

            @Override
            public boolean process(PsiClass inheritor) {
                if (inheritor.equals(class2) || inheritor.isInheritor(class2, true) || avoidExpensiveProcessing && this.count.incrementAndGet() > 20) {
                    result2[0] = true;
                    return false;
                }
                return true;
            }
        });
        return result2[0];
    }

    public static boolean hasImplementation(@NotNull PsiClass aClass2) {
        if (aClass2 == null) {
            InheritanceUtil.$$$reportNull$$$0(0);
        }
        GlobalSearchScope scope = GlobalSearchScope.projectScope(aClass2.getProject());
        if (aClass2.isInterface() && FunctionalExpressionSearch.search(aClass2, (SearchScope)scope).findFirst() != null) {
            return true;
        }
        for (ImplicitSubclassProvider provider : ImplicitSubclassProvider.Companion.getEP_NAME().getExtensions()) {
            ImplicitSubclassProvider.SubclassingInfo info;
            if (!provider.isApplicableTo(aClass2) || (info = provider.getSubclassingInfo(aClass2)) == null || info.isAbstract()) continue;
            return true;
        }
        Query<PsiClass> search = ClassInheritorsSearch.search(aClass2, scope, true);
        return !search.forEach(inheritor -> inheritor.isInterface() || inheritor.isAnnotationType() || inheritor.hasModifierProperty("abstract"));
    }

    public static boolean hasOneInheritor(PsiClass aClass2) {
        CountingProcessor processor = new CountingProcessor(2);
        ProgressManager.getInstance().runProcess(() -> ClassInheritorsSearch.search(aClass2, aClass2.getUseScope(), false).forEach(processor), null);
        return processor.getCount() == 1;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "com/siyeh/ig/psiutils/InheritanceUtil", "hasImplementation"));
    }

    private static class CountingProcessor
    implements Processor<PsiClass> {
        private final AtomicInteger myCount = new AtomicInteger(0);
        private final int myLimit;

        CountingProcessor(int limit) {
            this.myLimit = limit;
        }

        public int getCount() {
            return this.myCount.get();
        }

        @Override
        public boolean process(PsiClass aClass2) {
            return this.myCount.incrementAndGet() < this.myLimit;
        }
    }
}

