/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.psiutils;

import com.intellij.psi.PsiArrayAccessExpression;
import com.intellij.psi.PsiArrayInitializerExpression;
import com.intellij.psi.PsiAssertStatement;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiBlockStatement;
import com.intellij.psi.PsiBreakStatement;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassObjectAccessExpression;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiConditionalExpression;
import com.intellij.psi.PsiContinueStatement;
import com.intellij.psi.PsiDeclarationStatement;
import com.intellij.psi.PsiDoWhileStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiEmptyStatement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiExpressionListStatement;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiForStatement;
import com.intellij.psi.PsiForeachStatement;
import com.intellij.psi.PsiIfStatement;
import com.intellij.psi.PsiInstanceOfExpression;
import com.intellij.psi.PsiLabeledStatement;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiParenthesizedExpression;
import com.intellij.psi.PsiPolyadicExpression;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiResourceList;
import com.intellij.psi.PsiResourceListElement;
import com.intellij.psi.PsiResourceVariable;
import com.intellij.psi.PsiReturnStatement;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiSuperExpression;
import com.intellij.psi.PsiSwitchLabelStatement;
import com.intellij.psi.PsiSwitchStatement;
import com.intellij.psi.PsiSynchronizedStatement;
import com.intellij.psi.PsiThisExpression;
import com.intellij.psi.PsiThrowStatement;
import com.intellij.psi.PsiTryStatement;
import com.intellij.psi.PsiTypeCastExpression;
import com.intellij.psi.PsiUnaryExpression;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.PsiWhileStatement;
import com.intellij.psi.util.MethodSignature;
import com.siyeh.ig.psiutils.BoolUtils;
import com.siyeh.ig.psiutils.ClassUtils;
import com.siyeh.ig.psiutils.ExceptionUtils;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class InitializationUtils {
    private InitializationUtils() {
    }

    public static boolean methodAssignsVariableOrFails(@Nullable PsiMethod method, @NotNull PsiVariable variable2) {
        if (variable2 == null) {
            InitializationUtils.$$$reportNull$$$0(0);
        }
        return InitializationUtils.methodAssignsVariableOrFails(method, variable2, false);
    }

    public static boolean expressionAssignsVariableOrFails(@Nullable PsiExpression expression2, @NotNull PsiVariable variable2) {
        if (variable2 == null) {
            InitializationUtils.$$$reportNull$$$0(1);
        }
        return InitializationUtils.expressionAssignsVariableOrFails(expression2, variable2, new HashSet<MethodSignature>(), true);
    }

    public static boolean methodAssignsVariableOrFails(@Nullable PsiMethod method, @NotNull PsiVariable variable2, boolean strict) {
        if (variable2 == null) {
            InitializationUtils.$$$reportNull$$$0(2);
        }
        if (method == null) {
            return false;
        }
        return InitializationUtils.blockAssignsVariableOrFails(method.getBody(), variable2, strict);
    }

    public static boolean blockAssignsVariableOrFails(@Nullable PsiCodeBlock block, @NotNull PsiVariable variable2) {
        if (variable2 == null) {
            InitializationUtils.$$$reportNull$$$0(3);
        }
        return InitializationUtils.blockAssignsVariableOrFails(block, variable2, false);
    }

    public static boolean blockAssignsVariableOrFails(@Nullable PsiCodeBlock block, @NotNull PsiVariable variable2, boolean strict) {
        if (variable2 == null) {
            InitializationUtils.$$$reportNull$$$0(4);
        }
        return InitializationUtils.blockAssignsVariableOrFails(block, variable2, new HashSet<MethodSignature>(), strict);
    }

    private static boolean blockAssignsVariableOrFails(@Nullable PsiCodeBlock block, @NotNull PsiVariable variable2, @NotNull Set<MethodSignature> checkedMethods, boolean strict) {
        if (variable2 == null) {
            InitializationUtils.$$$reportNull$$$0(5);
        }
        if (checkedMethods == null) {
            InitializationUtils.$$$reportNull$$$0(6);
        }
        if (block == null) {
            return false;
        }
        int assignmentCount = 0;
        for (PsiStatement statement2 : block.getStatements()) {
            if (!InitializationUtils.statementAssignsVariableOrFails(statement2, variable2, checkedMethods, strict)) continue;
            if (strict) {
                ++assignmentCount;
                continue;
            }
            return true;
        }
        return assignmentCount == 1;
    }

    private static boolean statementAssignsVariableOrFails(@Nullable PsiStatement statement2, PsiVariable variable2, @NotNull Set<MethodSignature> checkedMethods, boolean strict) {
        if (checkedMethods == null) {
            InitializationUtils.$$$reportNull$$$0(7);
        }
        if (statement2 == null) {
            return false;
        }
        if (ExceptionUtils.statementThrowsException(statement2)) {
            return true;
        }
        if (statement2 instanceof PsiBreakStatement || statement2 instanceof PsiContinueStatement || statement2 instanceof PsiAssertStatement || statement2 instanceof PsiEmptyStatement || statement2 instanceof PsiSwitchLabelStatement) {
            return false;
        }
        if (statement2 instanceof PsiReturnStatement) {
            PsiReturnStatement returnStatement = (PsiReturnStatement)statement2;
            return InitializationUtils.expressionAssignsVariableOrFails(returnStatement.getReturnValue(), variable2, checkedMethods, strict);
        }
        if (statement2 instanceof PsiThrowStatement) {
            PsiThrowStatement throwStatement = (PsiThrowStatement)statement2;
            return InitializationUtils.expressionAssignsVariableOrFails(throwStatement.getException(), variable2, checkedMethods, strict);
        }
        if (statement2 instanceof PsiExpressionListStatement) {
            PsiExpressionListStatement list2 = (PsiExpressionListStatement)statement2;
            PsiExpressionList expressionList = list2.getExpressionList();
            for (PsiExpression expression2 : expressionList.getExpressions()) {
                if (!InitializationUtils.expressionAssignsVariableOrFails(expression2, variable2, checkedMethods, strict)) continue;
                return true;
            }
            return false;
        }
        if (statement2 instanceof PsiExpressionStatement) {
            PsiExpressionStatement expressionStatement = (PsiExpressionStatement)statement2;
            return InitializationUtils.expressionAssignsVariableOrFails(expressionStatement.getExpression(), variable2, checkedMethods, strict);
        }
        if (statement2 instanceof PsiDeclarationStatement) {
            PsiDeclarationStatement declarationStatement = (PsiDeclarationStatement)statement2;
            return InitializationUtils.declarationStatementAssignsVariableOrFails(declarationStatement, variable2, checkedMethods, strict);
        }
        if (statement2 instanceof PsiForStatement) {
            PsiForStatement forStatement = (PsiForStatement)statement2;
            return InitializationUtils.forStatementAssignsVariableOrFails(forStatement, variable2, checkedMethods, strict);
        }
        if (statement2 instanceof PsiForeachStatement) {
            PsiForeachStatement foreachStatement = (PsiForeachStatement)statement2;
            return InitializationUtils.foreachStatementAssignsVariableOrFails(foreachStatement, variable2, checkedMethods, strict);
        }
        if (statement2 instanceof PsiWhileStatement) {
            PsiWhileStatement whileStatement = (PsiWhileStatement)statement2;
            return InitializationUtils.whileStatementAssignsVariableOrFails(whileStatement, variable2, checkedMethods, strict);
        }
        if (statement2 instanceof PsiDoWhileStatement) {
            PsiDoWhileStatement doWhileStatement = (PsiDoWhileStatement)statement2;
            return InitializationUtils.doWhileAssignsVariableOrFails(doWhileStatement, variable2, checkedMethods, strict);
        }
        if (statement2 instanceof PsiSynchronizedStatement) {
            PsiSynchronizedStatement synchronizedStatement = (PsiSynchronizedStatement)statement2;
            return InitializationUtils.blockAssignsVariableOrFails(synchronizedStatement.getBody(), variable2, checkedMethods, strict);
        }
        if (statement2 instanceof PsiBlockStatement) {
            PsiBlockStatement blockStatement = (PsiBlockStatement)statement2;
            return InitializationUtils.blockAssignsVariableOrFails(blockStatement.getCodeBlock(), variable2, checkedMethods, strict);
        }
        if (statement2 instanceof PsiLabeledStatement) {
            PsiLabeledStatement labeledStatement = (PsiLabeledStatement)statement2;
            return InitializationUtils.statementAssignsVariableOrFails(labeledStatement.getStatement(), variable2, checkedMethods, strict);
        }
        if (statement2 instanceof PsiIfStatement) {
            PsiIfStatement ifStatement = (PsiIfStatement)statement2;
            return InitializationUtils.ifStatementAssignsVariableOrFails(ifStatement, variable2, checkedMethods, strict);
        }
        if (statement2 instanceof PsiTryStatement) {
            PsiTryStatement tryStatement = (PsiTryStatement)statement2;
            return InitializationUtils.tryStatementAssignsVariableOrFails(tryStatement, variable2, checkedMethods, strict);
        }
        if (statement2 instanceof PsiSwitchStatement) {
            PsiSwitchStatement switchStatement = (PsiSwitchStatement)statement2;
            return InitializationUtils.switchStatementAssignsVariableOrFails(switchStatement, variable2, checkedMethods, strict);
        }
        return false;
    }

    public static boolean switchStatementAssignsVariableOrFails(@NotNull PsiSwitchStatement switchStatement, @NotNull PsiVariable variable2, boolean strict) {
        if (switchStatement == null) {
            InitializationUtils.$$$reportNull$$$0(8);
        }
        if (variable2 == null) {
            InitializationUtils.$$$reportNull$$$0(9);
        }
        return InitializationUtils.switchStatementAssignsVariableOrFails(switchStatement, variable2, new HashSet<MethodSignature>(), strict);
    }

    private static boolean switchStatementAssignsVariableOrFails(@NotNull PsiSwitchStatement switchStatement, @NotNull PsiVariable variable2, @NotNull Set<MethodSignature> checkedMethods, boolean strict) {
        PsiExpression expression2;
        if (switchStatement == null) {
            InitializationUtils.$$$reportNull$$$0(10);
        }
        if (variable2 == null) {
            InitializationUtils.$$$reportNull$$$0(11);
        }
        if (checkedMethods == null) {
            InitializationUtils.$$$reportNull$$$0(12);
        }
        if (InitializationUtils.expressionAssignsVariableOrFails(expression2 = switchStatement.getExpression(), variable2, checkedMethods, strict)) {
            return true;
        }
        PsiCodeBlock body = switchStatement.getBody();
        if (body == null) {
            return false;
        }
        PsiStatement[] statements = body.getStatements();
        boolean containsDefault = false;
        boolean assigns = false;
        for (int i = 0; i < statements.length; ++i) {
            PsiStatement statement2 = statements[i];
            if (statement2 instanceof PsiSwitchLabelStatement) {
                PsiSwitchLabelStatement labelStatement = (PsiSwitchLabelStatement)statement2;
                if (i == statements.length - 1) {
                    return false;
                }
                if (labelStatement.isDefaultCase()) {
                    containsDefault = true;
                }
                assigns = false;
                continue;
            }
            if (statement2 instanceof PsiBreakStatement) {
                PsiBreakStatement breakStatement = (PsiBreakStatement)statement2;
                if (breakStatement.getLabelIdentifier() != null) {
                    return false;
                }
                if (!assigns) {
                    return false;
                }
                assigns = false;
                continue;
            }
            if (i != statements.length - 1 || (assigns |= InitializationUtils.statementAssignsVariableOrFails(statement2, variable2, checkedMethods, strict))) continue;
            return false;
        }
        return containsDefault;
    }

    private static boolean declarationStatementAssignsVariableOrFails(PsiDeclarationStatement declarationStatement, PsiVariable variable2, Set<MethodSignature> checkedMethods, boolean strict) {
        PsiElement[] elements;
        for (PsiElement element : elements = declarationStatement.getDeclaredElements()) {
            PsiVariable declaredVariable;
            if (!(element instanceof PsiVariable) || !InitializationUtils.expressionAssignsVariableOrFails((declaredVariable = (PsiVariable)element).getInitializer(), variable2, checkedMethods, strict)) continue;
            return true;
        }
        return false;
    }

    private static boolean tryStatementAssignsVariableOrFails(@NotNull PsiTryStatement tryStatement, PsiVariable variable2, @NotNull Set<MethodSignature> checkedMethods, boolean strict) {
        PsiCodeBlock[] catchBlocks;
        PsiResourceList resourceList;
        if (tryStatement == null) {
            InitializationUtils.$$$reportNull$$$0(13);
        }
        if (checkedMethods == null) {
            InitializationUtils.$$$reportNull$$$0(14);
        }
        if ((resourceList = tryStatement.getResourceList()) != null) {
            for (PsiResourceListElement resource : resourceList) {
                PsiExpression initializer2;
                if (!(resource instanceof PsiResourceVariable) || !InitializationUtils.expressionAssignsVariableOrFails(initializer2 = ((PsiResourceVariable)resource).getInitializer(), variable2, checkedMethods, strict)) continue;
                return true;
            }
        }
        boolean initializedInTryAndCatch = InitializationUtils.blockAssignsVariableOrFails(tryStatement.getTryBlock(), variable2, checkedMethods, strict);
        for (PsiCodeBlock catchBlock : catchBlocks = tryStatement.getCatchBlocks()) {
            if (strict) {
                initializedInTryAndCatch &= ExceptionUtils.blockThrowsException(catchBlock);
                continue;
            }
            initializedInTryAndCatch &= InitializationUtils.blockAssignsVariableOrFails(catchBlock, variable2, checkedMethods, strict);
        }
        return initializedInTryAndCatch || InitializationUtils.blockAssignsVariableOrFails(tryStatement.getFinallyBlock(), variable2, checkedMethods, strict);
    }

    private static boolean ifStatementAssignsVariableOrFails(@NotNull PsiIfStatement ifStatement, PsiVariable variable2, @NotNull Set<MethodSignature> checkedMethods, boolean strict) {
        PsiExpression condition;
        if (ifStatement == null) {
            InitializationUtils.$$$reportNull$$$0(15);
        }
        if (checkedMethods == null) {
            InitializationUtils.$$$reportNull$$$0(16);
        }
        if (InitializationUtils.expressionAssignsVariableOrFails(condition = ifStatement.getCondition(), variable2, checkedMethods, strict)) {
            return true;
        }
        PsiStatement thenBranch = ifStatement.getThenBranch();
        if (BoolUtils.isTrue(condition)) {
            return InitializationUtils.statementAssignsVariableOrFails(thenBranch, variable2, checkedMethods, strict);
        }
        PsiStatement elseBranch = ifStatement.getElseBranch();
        if (BoolUtils.isFalse(condition)) {
            return InitializationUtils.statementAssignsVariableOrFails(elseBranch, variable2, checkedMethods, strict);
        }
        return InitializationUtils.statementAssignsVariableOrFails(thenBranch, variable2, checkedMethods, strict) && InitializationUtils.statementAssignsVariableOrFails(elseBranch, variable2, checkedMethods, strict);
    }

    private static boolean doWhileAssignsVariableOrFails(@NotNull PsiDoWhileStatement doWhileStatement, PsiVariable variable2, @NotNull Set<MethodSignature> checkedMethods, boolean strict) {
        if (doWhileStatement == null) {
            InitializationUtils.$$$reportNull$$$0(17);
        }
        if (checkedMethods == null) {
            InitializationUtils.$$$reportNull$$$0(18);
        }
        return InitializationUtils.statementAssignsVariableOrFails(doWhileStatement.getBody(), variable2, checkedMethods, strict) || InitializationUtils.expressionAssignsVariableOrFails(doWhileStatement.getCondition(), variable2, checkedMethods, strict);
    }

    private static boolean whileStatementAssignsVariableOrFails(@NotNull PsiWhileStatement whileStatement, PsiVariable variable2, @NotNull Set<MethodSignature> checkedMethods, boolean strict) {
        PsiStatement body;
        PsiExpression condition;
        if (whileStatement == null) {
            InitializationUtils.$$$reportNull$$$0(19);
        }
        if (checkedMethods == null) {
            InitializationUtils.$$$reportNull$$$0(20);
        }
        if (InitializationUtils.expressionAssignsVariableOrFails(condition = whileStatement.getCondition(), variable2, checkedMethods, strict)) {
            return true;
        }
        return BoolUtils.isTrue(condition) && InitializationUtils.statementAssignsVariableOrFails(body = whileStatement.getBody(), variable2, checkedMethods, strict);
    }

    private static boolean forStatementAssignsVariableOrFails(@NotNull PsiForStatement forStatement, PsiVariable variable2, @NotNull Set<MethodSignature> checkedMethods, boolean strict) {
        if (forStatement == null) {
            InitializationUtils.$$$reportNull$$$0(21);
        }
        if (checkedMethods == null) {
            InitializationUtils.$$$reportNull$$$0(22);
        }
        if (InitializationUtils.statementAssignsVariableOrFails(forStatement.getInitialization(), variable2, checkedMethods, strict)) {
            return true;
        }
        PsiExpression condition = forStatement.getCondition();
        if (InitializationUtils.expressionAssignsVariableOrFails(condition, variable2, checkedMethods, strict)) {
            return true;
        }
        if (BoolUtils.isTrue(condition)) {
            if (InitializationUtils.statementAssignsVariableOrFails(forStatement.getBody(), variable2, checkedMethods, strict)) {
                return true;
            }
            if (InitializationUtils.statementAssignsVariableOrFails(forStatement.getUpdate(), variable2, checkedMethods, strict)) {
                return true;
            }
        }
        return false;
    }

    private static boolean foreachStatementAssignsVariableOrFails(@NotNull PsiForeachStatement foreachStatement, PsiVariable field, @NotNull Set<MethodSignature> checkedMethods, boolean strict) {
        if (foreachStatement == null) {
            InitializationUtils.$$$reportNull$$$0(23);
        }
        if (checkedMethods == null) {
            InitializationUtils.$$$reportNull$$$0(24);
        }
        return InitializationUtils.expressionAssignsVariableOrFails(foreachStatement.getIteratedValue(), field, checkedMethods, strict);
    }

    private static boolean expressionAssignsVariableOrFails(@Nullable PsiExpression expression2, PsiVariable variable2, @NotNull Set<MethodSignature> checkedMethods, boolean strict) {
        if (checkedMethods == null) {
            InitializationUtils.$$$reportNull$$$0(25);
        }
        if (expression2 == null) {
            return false;
        }
        if (expression2 instanceof PsiThisExpression || expression2 instanceof PsiLiteralExpression || expression2 instanceof PsiSuperExpression || expression2 instanceof PsiClassObjectAccessExpression || expression2 instanceof PsiReferenceExpression) {
            return false;
        }
        if (expression2 instanceof PsiParenthesizedExpression) {
            PsiParenthesizedExpression parenthesizedExpression = (PsiParenthesizedExpression)expression2;
            return InitializationUtils.expressionAssignsVariableOrFails(parenthesizedExpression.getExpression(), variable2, checkedMethods, strict);
        }
        if (expression2 instanceof PsiMethodCallExpression) {
            PsiMethodCallExpression methodCallExpression = (PsiMethodCallExpression)expression2;
            return InitializationUtils.methodCallAssignsVariableOrFails(methodCallExpression, variable2, checkedMethods, strict);
        }
        if (expression2 instanceof PsiNewExpression) {
            PsiNewExpression newExpression = (PsiNewExpression)expression2;
            return InitializationUtils.newExpressionAssignsVariableOrFails(newExpression, variable2, checkedMethods, strict);
        }
        if (expression2 instanceof PsiArrayInitializerExpression) {
            PsiArrayInitializerExpression array = (PsiArrayInitializerExpression)expression2;
            for (PsiExpression initializer2 : array.getInitializers()) {
                if (!InitializationUtils.expressionAssignsVariableOrFails(initializer2, variable2, checkedMethods, strict)) continue;
                return true;
            }
            return false;
        }
        if (expression2 instanceof PsiTypeCastExpression) {
            PsiTypeCastExpression typeCast = (PsiTypeCastExpression)expression2;
            return InitializationUtils.expressionAssignsVariableOrFails(typeCast.getOperand(), variable2, checkedMethods, strict);
        }
        if (expression2 instanceof PsiArrayAccessExpression) {
            PsiArrayAccessExpression accessExpression = (PsiArrayAccessExpression)expression2;
            return InitializationUtils.expressionAssignsVariableOrFails(accessExpression.getArrayExpression(), variable2, checkedMethods, strict) || InitializationUtils.expressionAssignsVariableOrFails(accessExpression.getIndexExpression(), variable2, checkedMethods, strict);
        }
        if (expression2 instanceof PsiUnaryExpression) {
            PsiUnaryExpression unaryOperation = (PsiUnaryExpression)expression2;
            return InitializationUtils.expressionAssignsVariableOrFails(unaryOperation.getOperand(), variable2, checkedMethods, strict);
        }
        if (expression2 instanceof PsiPolyadicExpression) {
            PsiPolyadicExpression polyadicExpression = (PsiPolyadicExpression)expression2;
            for (PsiExpression operand : polyadicExpression.getOperands()) {
                if (!InitializationUtils.expressionAssignsVariableOrFails(operand, variable2, checkedMethods, strict)) continue;
                return true;
            }
            return false;
        }
        if (expression2 instanceof PsiConditionalExpression) {
            PsiConditionalExpression conditional = (PsiConditionalExpression)expression2;
            if (InitializationUtils.expressionAssignsVariableOrFails(conditional.getCondition(), variable2, checkedMethods, strict)) {
                return true;
            }
            return InitializationUtils.expressionAssignsVariableOrFails(conditional.getThenExpression(), variable2, checkedMethods, strict) && InitializationUtils.expressionAssignsVariableOrFails(conditional.getElseExpression(), variable2, checkedMethods, strict);
        }
        if (expression2 instanceof PsiAssignmentExpression) {
            PsiElement element;
            PsiAssignmentExpression assignment = (PsiAssignmentExpression)expression2;
            PsiExpression lhs = assignment.getLExpression();
            if (InitializationUtils.expressionAssignsVariableOrFails(lhs, variable2, checkedMethods, strict)) {
                return true;
            }
            if (InitializationUtils.expressionAssignsVariableOrFails(assignment.getRExpression(), variable2, checkedMethods, strict)) {
                return true;
            }
            return lhs instanceof PsiReferenceExpression && variable2.equals(element = ((PsiReference)((Object)lhs)).resolve());
        }
        if (expression2 instanceof PsiInstanceOfExpression) {
            PsiInstanceOfExpression instanceOfExpression = (PsiInstanceOfExpression)expression2;
            return InitializationUtils.expressionAssignsVariableOrFails(instanceOfExpression.getOperand(), variable2, checkedMethods, strict);
        }
        return false;
    }

    private static boolean newExpressionAssignsVariableOrFails(@NotNull PsiNewExpression newExpression, PsiVariable variable2, @NotNull Set<MethodSignature> checkedMethods, boolean strict) {
        PsiExpressionList argumentList2;
        if (newExpression == null) {
            InitializationUtils.$$$reportNull$$$0(26);
        }
        if (checkedMethods == null) {
            InitializationUtils.$$$reportNull$$$0(27);
        }
        if ((argumentList2 = newExpression.getArgumentList()) != null) {
            for (PsiExpression argument : argumentList2.getExpressions()) {
                if (!InitializationUtils.expressionAssignsVariableOrFails(argument, variable2, checkedMethods, strict)) continue;
                return true;
            }
        }
        if (InitializationUtils.expressionAssignsVariableOrFails(newExpression.getArrayInitializer(), variable2, checkedMethods, strict)) {
            return true;
        }
        for (PsiExpression dimension : newExpression.getArrayDimensions()) {
            if (!InitializationUtils.expressionAssignsVariableOrFails(dimension, variable2, checkedMethods, strict)) continue;
            return true;
        }
        return false;
    }

    private static boolean methodCallAssignsVariableOrFails(@NotNull PsiMethodCallExpression callExpression, PsiVariable variable2, @NotNull Set<MethodSignature> checkedMethods, boolean strict) {
        if (callExpression == null) {
            InitializationUtils.$$$reportNull$$$0(28);
        }
        if (checkedMethods == null) {
            InitializationUtils.$$$reportNull$$$0(29);
        }
        PsiExpressionList argumentList2 = callExpression.getArgumentList();
        for (PsiExpression argument : argumentList2.getExpressions()) {
            if (!InitializationUtils.expressionAssignsVariableOrFails(argument, variable2, checkedMethods, strict)) continue;
            return true;
        }
        if (InitializationUtils.expressionAssignsVariableOrFails(callExpression.getMethodExpression(), variable2, checkedMethods, strict)) {
            return true;
        }
        PsiMethod method = callExpression.resolveMethod();
        if (method == null) {
            return false;
        }
        MethodSignature methodSignature = method.getSignature(PsiSubstitutor.EMPTY);
        if (!checkedMethods.add(methodSignature)) {
            return false;
        }
        PsiClass containingClass = ClassUtils.getContainingClass(callExpression);
        PsiClass calledClass = method.getContainingClass();
        if (calledClass == null || !calledClass.equals(containingClass)) {
            return false;
        }
        if (method.hasModifierProperty("static") || method.hasModifierProperty("private") || method.hasModifierProperty("final") || method.isConstructor() || calledClass.hasModifierProperty("final")) {
            return InitializationUtils.blockAssignsVariableOrFails(method.getBody(), variable2, checkedMethods, strict);
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "variable";
                break;
            }
            case 6: 
            case 7: 
            case 12: 
            case 14: 
            case 16: 
            case 18: 
            case 20: 
            case 22: 
            case 24: 
            case 25: 
            case 27: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "checkedMethods";
                break;
            }
            case 8: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "switchStatement";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tryStatement";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ifStatement";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "doWhileStatement";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "whileStatement";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "forStatement";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "foreachStatement";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newExpression";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callExpression";
                break;
            }
        }
        objectArray2[1] = "com/siyeh/ig/psiutils/InitializationUtils";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "methodAssignsVariableOrFails";
                break;
            }
            case 1: 
            case 25: {
                objectArray = objectArray2;
                objectArray2[2] = "expressionAssignsVariableOrFails";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "blockAssignsVariableOrFails";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "statementAssignsVariableOrFails";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[2] = "switchStatementAssignsVariableOrFails";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[2] = "tryStatementAssignsVariableOrFails";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[2] = "ifStatementAssignsVariableOrFails";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray2;
                objectArray2[2] = "doWhileAssignsVariableOrFails";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray2;
                objectArray2[2] = "whileStatementAssignsVariableOrFails";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray2;
                objectArray2[2] = "forStatementAssignsVariableOrFails";
                break;
            }
            case 23: 
            case 24: {
                objectArray = objectArray2;
                objectArray2[2] = "foreachStatementAssignsVariableOrFails";
                break;
            }
            case 26: 
            case 27: {
                objectArray = objectArray2;
                objectArray2[2] = "newExpressionAssignsVariableOrFails";
                break;
            }
            case 28: 
            case 29: {
                objectArray = objectArray2;
                objectArray2[2] = "methodCallAssignsVariableOrFails";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

