/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.psiutils;

import com.intellij.codeInspection.reference.RefMethod;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.Stack;

public class MethodInheritanceUtils {
    private MethodInheritanceUtils() {
    }

    public static Set<RefMethod> calculateSiblingMethods(RefMethod method) {
        HashSet<RefMethod> siblingMethods = new HashSet<RefMethod>();
        Stack<RefMethod> pendingMethods = new Stack<RefMethod>();
        pendingMethods.add(method);
        while (!pendingMethods.isEmpty()) {
            RefMethod methodToAnalyze = (RefMethod)pendingMethods.pop();
            siblingMethods.add(methodToAnalyze);
            Collection<RefMethod> overridingMethods = methodToAnalyze.getDerivedMethods();
            for (RefMethod overridingMethod : overridingMethods) {
                if (siblingMethods.contains(overridingMethod) || pendingMethods.contains(overridingMethod)) continue;
                pendingMethods.add(overridingMethod);
            }
            Collection<RefMethod> superMethods = methodToAnalyze.getSuperMethods();
            for (RefMethod superMethod : superMethods) {
                if (siblingMethods.contains(superMethod) || pendingMethods.contains(superMethod)) continue;
                pendingMethods.add(superMethod);
            }
        }
        return siblingMethods;
    }
}

