/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.psiutils;

import com.intellij.codeInspection.dataFlow.ControlFlowAnalyzer;
import com.intellij.codeInspection.dataFlow.MethodContract;
import com.intellij.psi.JavaDirectoryService;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiBreakStatement;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiContinueStatement;
import com.intellij.psi.PsiDeclarationStatement;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.PsiReturnStatement;
import com.intellij.psi.PsiThrowStatement;
import com.intellij.psi.PsiUnaryExpression;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PropertyUtil;
import gnu.trove.THashSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.Stack;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.Vector;
import java.util.WeakHashMap;
import java.util.function.Predicate;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SideEffectChecker {
    private static final Set<String> ourSideEffectFreeClasses = new THashSet<String>(Arrays.asList(Object.class.getName(), Short.class.getName(), Character.class.getName(), Byte.class.getName(), Integer.class.getName(), Long.class.getName(), Float.class.getName(), Double.class.getName(), String.class.getName(), StringBuffer.class.getName(), Boolean.class.getName(), ArrayList.class.getName(), Date.class.getName(), HashMap.class.getName(), HashSet.class.getName(), Hashtable.class.getName(), LinkedHashMap.class.getName(), LinkedHashSet.class.getName(), LinkedList.class.getName(), Stack.class.getName(), TreeMap.class.getName(), TreeSet.class.getName(), Vector.class.getName(), WeakHashMap.class.getName()));

    private SideEffectChecker() {
    }

    public static boolean mayHaveSideEffects(@NotNull PsiExpression exp) {
        if (exp == null) {
            SideEffectChecker.$$$reportNull$$$0(0);
        }
        SideEffectsVisitor visitor2 = new SideEffectsVisitor(null);
        exp.accept(visitor2);
        return visitor2.mayHaveSideEffects();
    }

    public static boolean mayHaveSideEffects(@NotNull PsiElement element, Predicate<PsiMethodCallExpression> shouldIgnoreCall) {
        if (element == null) {
            SideEffectChecker.$$$reportNull$$$0(1);
        }
        SideEffectsVisitor visitor2 = new SideEffectsVisitor(null, shouldIgnoreCall);
        element.accept(visitor2);
        return visitor2.mayHaveSideEffects();
    }

    public static boolean checkSideEffects(@NotNull PsiExpression element, @NotNull List<PsiElement> sideEffects) {
        if (element == null) {
            SideEffectChecker.$$$reportNull$$$0(2);
        }
        if (sideEffects == null) {
            SideEffectChecker.$$$reportNull$$$0(3);
        }
        SideEffectsVisitor visitor2 = new SideEffectsVisitor(sideEffects);
        element.accept(visitor2);
        return visitor2.mayHaveSideEffects();
    }

    public static List<PsiExpression> extractSideEffectExpressions(@NotNull PsiExpression element) {
        if (element == null) {
            SideEffectChecker.$$$reportNull$$$0(4);
        }
        ArrayList<PsiElement> list2 = new ArrayList<PsiElement>();
        element.accept(new SideEffectsVisitor(list2));
        return StreamEx.of(list2).select(PsiExpression.class).toList();
    }

    public static boolean mayHaveExceptionalSideEffect(PsiMethod method) {
        if (method.getName().startsWith("assert") || method.getName().startsWith("check")) {
            return true;
        }
        return ControlFlowAnalyzer.getMethodContracts(method).stream().anyMatch(mc -> mc.returnValue == MethodContract.ValueConstraint.THROW_EXCEPTION);
    }

    private static boolean isSideEffectFreeConstructor(@NotNull PsiNewExpression newExpression) {
        PsiClass throwableClass;
        String packageName;
        String qualifiedName2;
        PsiJavaCodeReferenceElement classReference;
        if (newExpression == null) {
            SideEffectChecker.$$$reportNull$$$0(5);
        }
        PsiClass aClass2 = (classReference = newExpression.getClassReference()) == null ? null : (PsiClass)classReference.resolve();
        String string = qualifiedName2 = aClass2 == null ? null : aClass2.getQualifiedName();
        if (qualifiedName2 == null) {
            return false;
        }
        if (ourSideEffectFreeClasses.contains(qualifiedName2)) {
            return true;
        }
        PsiFile file2 = aClass2.getContainingFile();
        PsiDirectory directory = file2.getContainingDirectory();
        PsiPackage classPackage = directory == null ? null : JavaDirectoryService.getInstance().getPackage(directory);
        String string2 = packageName = classPackage == null ? null : classPackage.getQualifiedName();
        return ("java.lang".equals(packageName) || "java.io".equals(packageName)) && (throwableClass = JavaPsiFacade.getInstance(aClass2.getProject()).findClass("java.lang.Throwable", aClass2.getResolveScope())) != null && InheritanceUtil.isInheritorOrSelf(aClass2, throwableClass, true);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "exp";
                break;
            }
            case 1: 
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sideEffects";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newExpression";
                break;
            }
        }
        objectArray2[1] = "com/siyeh/ig/psiutils/SideEffectChecker";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "mayHaveSideEffects";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "checkSideEffects";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "extractSideEffectExpressions";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "isSideEffectFreeConstructor";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class SideEffectsVisitor
    extends JavaRecursiveElementWalkingVisitor {
        @Nullable
        private final List<PsiElement> mySideEffects;
        boolean found;
        final Predicate<PsiMethodCallExpression> myIgnoredCallPredicate;

        SideEffectsVisitor(@Nullable List<PsiElement> sideEffects) {
            this(sideEffects, call2 -> false);
        }

        SideEffectsVisitor(@Nullable List<PsiElement> sideEffects, Predicate<PsiMethodCallExpression> predicate) {
            this.myIgnoredCallPredicate = predicate;
            this.mySideEffects = sideEffects;
        }

        private void addSideEffect(PsiElement element) {
            this.found = true;
            if (this.mySideEffects != null) {
                this.mySideEffects.add(element);
            } else {
                this.stopWalking();
            }
        }

        @Override
        public void visitAssignmentExpression(@NotNull PsiAssignmentExpression expression2) {
            if (expression2 == null) {
                SideEffectsVisitor.$$$reportNull$$$0(0);
            }
            this.addSideEffect(expression2);
        }

        @Override
        public void visitMethodCallExpression(@NotNull PsiMethodCallExpression expression2) {
            PsiMethod method;
            if (expression2 == null) {
                SideEffectsVisitor.$$$reportNull$$$0(1);
            }
            if (!this.myIgnoredCallPredicate.test(expression2) && !this.isPure(method = expression2.resolveMethod())) {
                this.addSideEffect(expression2);
                return;
            }
            super.visitMethodCallExpression(expression2);
        }

        protected boolean isPure(PsiMethod method) {
            if (method == null) {
                return false;
            }
            if (PropertyUtil.isSimpleGetter(method)) {
                return true;
            }
            return ControlFlowAnalyzer.isPure(method) && !SideEffectChecker.mayHaveExceptionalSideEffect(method);
        }

        @Override
        public void visitNewExpression(@NotNull PsiNewExpression expression2) {
            if (expression2 == null) {
                SideEffectsVisitor.$$$reportNull$$$0(2);
            }
            if (!SideEffectChecker.isSideEffectFreeConstructor(expression2)) {
                this.addSideEffect(expression2);
                return;
            }
            super.visitNewExpression(expression2);
        }

        @Override
        public void visitUnaryExpression(@NotNull PsiUnaryExpression expression2) {
            IElementType tokenType;
            if (expression2 == null) {
                SideEffectsVisitor.$$$reportNull$$$0(3);
            }
            if ((tokenType = expression2.getOperationTokenType()).equals(JavaTokenType.PLUSPLUS) || tokenType.equals(JavaTokenType.MINUSMINUS)) {
                this.addSideEffect(expression2);
                return;
            }
            super.visitUnaryExpression(expression2);
        }

        @Override
        public void visitDeclarationStatement(PsiDeclarationStatement statement2) {
            this.addSideEffect(statement2);
        }

        @Override
        public void visitBreakStatement(PsiBreakStatement statement2) {
            this.addSideEffect(statement2);
        }

        @Override
        public void visitClass(PsiClass aClass2) {
        }

        @Override
        public void visitContinueStatement(PsiContinueStatement statement2) {
            this.addSideEffect(statement2);
        }

        @Override
        public void visitReturnStatement(PsiReturnStatement statement2) {
            this.addSideEffect(statement2);
        }

        @Override
        public void visitThrowStatement(PsiThrowStatement statement2) {
            this.addSideEffect(statement2);
        }

        @Override
        public void visitLambdaExpression(PsiLambdaExpression expression2) {
        }

        public boolean mayHaveSideEffects() {
            return this.found;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "expression";
            objectArray2[1] = "com/siyeh/ig/psiutils/SideEffectChecker$SideEffectsVisitor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitAssignmentExpression";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitMethodCallExpression";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitNewExpression";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitUnaryExpression";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

