/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.psiutils;

import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.search.searches.MethodReferencesSearch;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.Processor;
import com.intellij.util.Query;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;

public class SingletonUtil {
    private SingletonUtil() {
    }

    public static boolean isSingleton(@NotNull PsiClass aClass2) {
        if (aClass2 == null) {
            SingletonUtil.$$$reportNull$$$0(0);
        }
        if (aClass2.isInterface() || aClass2.isEnum() || aClass2.isAnnotationType()) {
            return false;
        }
        if (aClass2 instanceof PsiTypeParameter || aClass2 instanceof PsiAnonymousClass) {
            return false;
        }
        PsiMethod[] constructors2 = SingletonUtil.getIfOnlyInvisibleConstructors(aClass2);
        if (constructors2.length == 0) {
            return false;
        }
        PsiField selfInstance = SingletonUtil.getIfOneStaticSelfInstance(aClass2);
        return selfInstance != null && SingletonUtil.newOnlyAssignsToStaticSelfInstance(constructors2[0], selfInstance);
    }

    private static PsiField getIfOneStaticSelfInstance(PsiClass aClass2) {
        Stream<PsiField> fieldStream = Stream.concat(Arrays.stream(aClass2.getFields()), Arrays.stream(aClass2.getInnerClasses()).filter(innerClass -> innerClass.hasModifierProperty("static")).flatMap(innerClass -> Arrays.stream(innerClass.getFields())));
        List fields2 = fieldStream.filter(field -> SingletonUtil.resolveToSingletonField(aClass2, field)).limit(2L).collect(Collectors.toList());
        return fields2.size() == 1 ? (PsiField)fields2.get(0) : null;
    }

    private static boolean resolveToSingletonField(PsiClass aClass2, PsiField field) {
        if (!field.hasModifierProperty("static")) {
            return false;
        }
        PsiClass targetClass = PsiUtil.resolveClassInClassTypeOnly(field.getType());
        return aClass2.equals(targetClass);
    }

    @NotNull
    private static PsiMethod[] getIfOnlyInvisibleConstructors(PsiClass aClass2) {
        PsiMethod[] constructors2 = aClass2.getConstructors();
        if (constructors2.length == 0) {
            if (PsiMethod.EMPTY_ARRAY == null) {
                SingletonUtil.$$$reportNull$$$0(1);
            }
            return PsiMethod.EMPTY_ARRAY;
        }
        for (PsiMethod constructor : constructors2) {
            if (constructor.hasModifierProperty("public")) {
                if (PsiMethod.EMPTY_ARRAY == null) {
                    SingletonUtil.$$$reportNull$$$0(2);
                }
                return PsiMethod.EMPTY_ARRAY;
            }
            if (constructor.hasModifierProperty("private") || constructor.hasModifierProperty("protected")) continue;
            if (PsiMethod.EMPTY_ARRAY == null) {
                SingletonUtil.$$$reportNull$$$0(3);
            }
            return PsiMethod.EMPTY_ARRAY;
        }
        if (constructors2 == null) {
            SingletonUtil.$$$reportNull$$$0(4);
        }
        return constructors2;
    }

    private static boolean newOnlyAssignsToStaticSelfInstance(PsiMethod method, PsiField field) {
        Query<PsiReference> search = MethodReferencesSearch.search(method, field.getUseScope(), false);
        NewOnlyAssignedToFieldProcessor processor = new NewOnlyAssignedToFieldProcessor(field);
        search.forEach(processor);
        return processor.isNewOnlyAssignedToField();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aClass";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/siyeh/ig/psiutils/SingletonUtil";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/siyeh/ig/psiutils/SingletonUtil";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getIfOnlyInvisibleConstructors";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isSingleton";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class NewOnlyAssignedToFieldProcessor
    implements Processor<PsiReference> {
        private boolean newOnlyAssignedToField = true;
        private final PsiField field;

        public NewOnlyAssignedToFieldProcessor(PsiField field) {
            this.field = field;
        }

        @Override
        public boolean process(PsiReference reference) {
            PsiElement element = reference.getElement();
            PsiElement parent2 = element.getParent();
            if (!(parent2 instanceof PsiNewExpression)) {
                this.newOnlyAssignedToField = false;
                return false;
            }
            PsiElement grandParent = parent2.getParent();
            if (this.field.equals(grandParent)) {
                return true;
            }
            if (!(grandParent instanceof PsiAssignmentExpression)) {
                this.newOnlyAssignedToField = false;
                return false;
            }
            PsiAssignmentExpression assignmentExpression = (PsiAssignmentExpression)grandParent;
            PsiExpression lhs = assignmentExpression.getLExpression();
            if (!(lhs instanceof PsiReferenceExpression)) {
                this.newOnlyAssignedToField = false;
                return false;
            }
            PsiReferenceExpression referenceExpression = (PsiReferenceExpression)lhs;
            PsiElement target = referenceExpression.resolve();
            if (!this.field.equals(target)) {
                this.newOnlyAssignedToField = false;
                return false;
            }
            return true;
        }

        public boolean isNewOnlyAssignedToField() {
            return this.newOnlyAssignedToField;
        }
    }
}

