/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.psiutils;

import com.intellij.psi.PsiArrayAccessExpression;
import com.intellij.psi.PsiArrayInitializerExpression;
import com.intellij.psi.PsiAssertStatement;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiBlockStatement;
import com.intellij.psi.PsiBreakStatement;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassObjectAccessExpression;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiConditionalExpression;
import com.intellij.psi.PsiContinueStatement;
import com.intellij.psi.PsiDeclarationStatement;
import com.intellij.psi.PsiDoWhileStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiEmptyStatement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiExpressionListStatement;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiForStatement;
import com.intellij.psi.PsiForeachStatement;
import com.intellij.psi.PsiIfStatement;
import com.intellij.psi.PsiInstanceOfExpression;
import com.intellij.psi.PsiLabeledStatement;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiParenthesizedExpression;
import com.intellij.psi.PsiPolyadicExpression;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiResourceList;
import com.intellij.psi.PsiResourceListElement;
import com.intellij.psi.PsiResourceVariable;
import com.intellij.psi.PsiReturnStatement;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiSuperExpression;
import com.intellij.psi.PsiSwitchLabelStatement;
import com.intellij.psi.PsiSwitchStatement;
import com.intellij.psi.PsiSynchronizedStatement;
import com.intellij.psi.PsiThisExpression;
import com.intellij.psi.PsiThrowStatement;
import com.intellij.psi.PsiTryStatement;
import com.intellij.psi.PsiTypeCastExpression;
import com.intellij.psi.PsiUnaryExpression;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.PsiWhileStatement;
import com.intellij.psi.util.MethodSignature;
import com.intellij.psi.util.PsiTreeUtil;
import com.siyeh.ig.psiutils.BoolUtils;
import com.siyeh.ig.psiutils.ClassUtils;
import com.siyeh.ig.psiutils.ComparisonUtils;
import com.siyeh.ig.psiutils.ExceptionUtils;
import com.siyeh.ig.psiutils.ParenthesesUtils;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class UninitializedReadCollector {
    private final Set<PsiExpression> uninitializedReads = new HashSet<PsiExpression>();
    private int counter = 0;

    @NotNull
    public PsiExpression[] getUninitializedReads() {
        PsiExpression[] psiExpressionArray = this.uninitializedReads.toArray(new PsiExpression[this.uninitializedReads.size()]);
        if (psiExpressionArray == null) {
            UninitializedReadCollector.$$$reportNull$$$0(0);
        }
        return psiExpressionArray;
    }

    public boolean blockAssignsVariable(@Nullable PsiCodeBlock block, @NotNull PsiVariable variable2) {
        if (variable2 == null) {
            UninitializedReadCollector.$$$reportNull$$$0(1);
        }
        return this.blockAssignsVariable(block, variable2, this.counter, new HashSet<MethodSignature>());
    }

    private boolean blockAssignsVariable(@Nullable PsiCodeBlock block, @NotNull PsiVariable variable2, int stamp, @NotNull Set<MethodSignature> checkedMethods) {
        PsiStatement[] statements;
        if (variable2 == null) {
            UninitializedReadCollector.$$$reportNull$$$0(2);
        }
        if (checkedMethods == null) {
            UninitializedReadCollector.$$$reportNull$$$0(3);
        }
        if (this.counter != stamp) {
            return true;
        }
        if (block == null) {
            return false;
        }
        for (PsiStatement statement2 : statements = block.getStatements()) {
            if (this.statementAssignsVariable(statement2, variable2, stamp, checkedMethods)) {
                return true;
            }
            if (this.counter == stamp) continue;
            return true;
        }
        return false;
    }

    private boolean statementAssignsVariable(@Nullable PsiStatement statement2, @NotNull PsiVariable variable2, int stamp, @NotNull Set<MethodSignature> checkedMethods) {
        if (variable2 == null) {
            UninitializedReadCollector.$$$reportNull$$$0(4);
        }
        if (checkedMethods == null) {
            UninitializedReadCollector.$$$reportNull$$$0(5);
        }
        if (statement2 == null) {
            return false;
        }
        if (ExceptionUtils.statementThrowsException(statement2)) {
            return true;
        }
        if (statement2 instanceof PsiBreakStatement || statement2 instanceof PsiContinueStatement || statement2 instanceof PsiAssertStatement || statement2 instanceof PsiEmptyStatement) {
            return false;
        }
        if (statement2 instanceof PsiReturnStatement) {
            PsiReturnStatement returnStatement = (PsiReturnStatement)statement2;
            PsiExpression returnValue = returnStatement.getReturnValue();
            return this.expressionAssignsVariable(returnValue, variable2, stamp, checkedMethods);
        }
        if (statement2 instanceof PsiThrowStatement) {
            PsiThrowStatement throwStatement = (PsiThrowStatement)statement2;
            PsiExpression exception = throwStatement.getException();
            return this.expressionAssignsVariable(exception, variable2, stamp, checkedMethods);
        }
        if (statement2 instanceof PsiExpressionListStatement) {
            PsiExpression[] expressions;
            PsiExpressionListStatement list2 = (PsiExpressionListStatement)statement2;
            PsiExpressionList expressionList = list2.getExpressionList();
            for (PsiExpression expression2 : expressions = expressionList.getExpressions()) {
                if (!this.expressionAssignsVariable(expression2, variable2, stamp, checkedMethods)) continue;
                return true;
            }
            return false;
        }
        if (statement2 instanceof PsiExpressionStatement) {
            PsiExpressionStatement expressionStatement = (PsiExpressionStatement)statement2;
            PsiExpression expression3 = expressionStatement.getExpression();
            return this.expressionAssignsVariable(expression3, variable2, stamp, checkedMethods);
        }
        if (statement2 instanceof PsiDeclarationStatement) {
            PsiDeclarationStatement declarationStatement = (PsiDeclarationStatement)statement2;
            return this.declarationStatementAssignsVariable(declarationStatement, variable2, stamp, checkedMethods);
        }
        if (statement2 instanceof PsiForStatement) {
            PsiForStatement forStatement = (PsiForStatement)statement2;
            return this.forStatementAssignsVariable(forStatement, variable2, stamp, checkedMethods);
        }
        if (statement2 instanceof PsiForeachStatement) {
            PsiForeachStatement foreachStatement = (PsiForeachStatement)statement2;
            return this.foreachStatementAssignsVariable(foreachStatement, variable2);
        }
        if (statement2 instanceof PsiWhileStatement) {
            PsiWhileStatement whileStatement = (PsiWhileStatement)statement2;
            return this.whileStatementAssignsVariable(whileStatement, variable2, stamp, checkedMethods);
        }
        if (statement2 instanceof PsiDoWhileStatement) {
            PsiDoWhileStatement doWhileStatement = (PsiDoWhileStatement)statement2;
            return this.doWhileAssignsVariable(doWhileStatement, variable2, stamp, checkedMethods);
        }
        if (statement2 instanceof PsiSynchronizedStatement) {
            PsiSynchronizedStatement synchronizedStatement = (PsiSynchronizedStatement)statement2;
            PsiCodeBlock body = synchronizedStatement.getBody();
            return this.blockAssignsVariable(body, variable2, stamp, checkedMethods);
        }
        if (statement2 instanceof PsiBlockStatement) {
            PsiBlockStatement blockStatement = (PsiBlockStatement)statement2;
            PsiCodeBlock codeBlock = blockStatement.getCodeBlock();
            return this.blockAssignsVariable(codeBlock, variable2, stamp, checkedMethods);
        }
        if (statement2 instanceof PsiLabeledStatement) {
            PsiLabeledStatement labeledStatement = (PsiLabeledStatement)statement2;
            PsiStatement statementLabeled = labeledStatement.getStatement();
            return this.statementAssignsVariable(statementLabeled, variable2, stamp, checkedMethods);
        }
        if (statement2 instanceof PsiIfStatement) {
            PsiIfStatement ifStatement = (PsiIfStatement)statement2;
            return this.ifStatementAssignsVariable(ifStatement, variable2, stamp, checkedMethods);
        }
        if (statement2 instanceof PsiTryStatement) {
            PsiTryStatement tryStatement = (PsiTryStatement)statement2;
            return this.tryStatementAssignsVariable(tryStatement, variable2, stamp, checkedMethods);
        }
        if (statement2 instanceof PsiSwitchStatement) {
            PsiSwitchStatement switchStatement = (PsiSwitchStatement)statement2;
            return this.switchStatementAssignsVariable(switchStatement, variable2, stamp, checkedMethods);
        }
        if (statement2 instanceof PsiSwitchLabelStatement) {
            return false;
        }
        assert (false) : "unknown statement: " + statement2;
        return false;
    }

    private boolean switchStatementAssignsVariable(@NotNull PsiSwitchStatement switchStatement, @NotNull PsiVariable variable2, int stamp, @NotNull Set<MethodSignature> checkedMethods) {
        PsiExpression expression2;
        if (switchStatement == null) {
            UninitializedReadCollector.$$$reportNull$$$0(6);
        }
        if (variable2 == null) {
            UninitializedReadCollector.$$$reportNull$$$0(7);
        }
        if (checkedMethods == null) {
            UninitializedReadCollector.$$$reportNull$$$0(8);
        }
        if (this.expressionAssignsVariable(expression2 = switchStatement.getExpression(), variable2, stamp, checkedMethods)) {
            return true;
        }
        PsiCodeBlock body = switchStatement.getBody();
        if (body == null) {
            return false;
        }
        PsiStatement[] statements = body.getStatements();
        boolean containsDefault = false;
        boolean assigns = false;
        for (int i = 0; i < statements.length; ++i) {
            PsiStatement statement2 = statements[i];
            if (statement2 instanceof PsiSwitchLabelStatement) {
                PsiSwitchLabelStatement labelStatement = (PsiSwitchLabelStatement)statement2;
                if (i == statements.length - 1) {
                    return false;
                }
                if (labelStatement.isDefaultCase()) {
                    containsDefault = true;
                }
                assigns = false;
                continue;
            }
            if (statement2 instanceof PsiBreakStatement) {
                PsiBreakStatement breakStatement = (PsiBreakStatement)statement2;
                if (breakStatement.getLabelIdentifier() != null) {
                    return false;
                }
                if (!assigns) {
                    return false;
                }
                assigns = false;
                continue;
            }
            if (i != statements.length - 1 || (assigns |= this.statementAssignsVariable(statement2, variable2, stamp, checkedMethods))) continue;
            return false;
        }
        return containsDefault;
    }

    private boolean declarationStatementAssignsVariable(@NotNull PsiDeclarationStatement declarationStatement, @NotNull PsiVariable variable2, int stamp, @NotNull Set<MethodSignature> checkedMethods) {
        PsiElement[] elements;
        if (declarationStatement == null) {
            UninitializedReadCollector.$$$reportNull$$$0(9);
        }
        if (variable2 == null) {
            UninitializedReadCollector.$$$reportNull$$$0(10);
        }
        if (checkedMethods == null) {
            UninitializedReadCollector.$$$reportNull$$$0(11);
        }
        for (PsiElement element : elements = declarationStatement.getDeclaredElements()) {
            PsiVariable variableElement;
            PsiExpression initializer2;
            if (!(element instanceof PsiVariable) || !this.expressionAssignsVariable(initializer2 = (variableElement = (PsiVariable)element).getInitializer(), variable2, stamp, checkedMethods)) continue;
            return true;
        }
        return false;
    }

    private boolean tryStatementAssignsVariable(@NotNull PsiTryStatement tryStatement, @NotNull PsiVariable variable2, int stamp, @NotNull Set<MethodSignature> checkedMethods) {
        PsiCodeBlock[] catchBlocks;
        PsiResourceList resourceList;
        if (tryStatement == null) {
            UninitializedReadCollector.$$$reportNull$$$0(12);
        }
        if (variable2 == null) {
            UninitializedReadCollector.$$$reportNull$$$0(13);
        }
        if (checkedMethods == null) {
            UninitializedReadCollector.$$$reportNull$$$0(14);
        }
        if ((resourceList = tryStatement.getResourceList()) != null) {
            for (PsiResourceListElement resource : resourceList) {
                PsiExpression initializer2;
                if (!(resource instanceof PsiResourceVariable) || !this.expressionAssignsVariable(initializer2 = ((PsiResourceVariable)resource).getInitializer(), variable2, stamp, checkedMethods)) continue;
                return true;
            }
        }
        PsiCodeBlock tryBlock = tryStatement.getTryBlock();
        boolean initializedInTryOrCatch = this.blockAssignsVariable(tryBlock, variable2, stamp, checkedMethods);
        for (PsiCodeBlock catchBlock : catchBlocks = tryStatement.getCatchBlocks()) {
            initializedInTryOrCatch &= this.blockAssignsVariable(catchBlock, variable2, stamp, checkedMethods);
        }
        if (initializedInTryOrCatch) {
            return true;
        }
        PsiCodeBlock finallyBlock = tryStatement.getFinallyBlock();
        return this.blockAssignsVariable(finallyBlock, variable2, stamp, checkedMethods);
    }

    private boolean ifStatementAssignsVariable(@NotNull PsiIfStatement ifStatement, @NotNull PsiVariable variable2, int stamp, @NotNull Set<MethodSignature> checkedMethods) {
        PsiExpression condition;
        if (ifStatement == null) {
            UninitializedReadCollector.$$$reportNull$$$0(15);
        }
        if (variable2 == null) {
            UninitializedReadCollector.$$$reportNull$$$0(16);
        }
        if (checkedMethods == null) {
            UninitializedReadCollector.$$$reportNull$$$0(17);
        }
        if (this.expressionAssignsVariable(condition = ifStatement.getCondition(), variable2, stamp, checkedMethods)) {
            return true;
        }
        PsiStatement thenBranch = ifStatement.getThenBranch();
        PsiStatement elseBranch = ifStatement.getElseBranch();
        return this.statementAssignsVariable(thenBranch, variable2, stamp, checkedMethods) && this.statementAssignsVariable(elseBranch, variable2, stamp, checkedMethods);
    }

    private boolean doWhileAssignsVariable(@NotNull PsiDoWhileStatement doWhileStatement, @NotNull PsiVariable variable2, int stamp, @NotNull Set<MethodSignature> checkedMethods) {
        if (doWhileStatement == null) {
            UninitializedReadCollector.$$$reportNull$$$0(18);
        }
        if (variable2 == null) {
            UninitializedReadCollector.$$$reportNull$$$0(19);
        }
        if (checkedMethods == null) {
            UninitializedReadCollector.$$$reportNull$$$0(20);
        }
        PsiExpression condition = doWhileStatement.getCondition();
        PsiStatement body = doWhileStatement.getBody();
        return this.statementAssignsVariable(body, variable2, stamp, checkedMethods) || this.expressionAssignsVariable(condition, variable2, stamp, checkedMethods);
    }

    private boolean whileStatementAssignsVariable(@NotNull PsiWhileStatement whileStatement, @NotNull PsiVariable variable2, int stamp, @NotNull Set<MethodSignature> checkedMethods) {
        PsiStatement body;
        PsiExpression condition;
        if (whileStatement == null) {
            UninitializedReadCollector.$$$reportNull$$$0(21);
        }
        if (variable2 == null) {
            UninitializedReadCollector.$$$reportNull$$$0(22);
        }
        if (checkedMethods == null) {
            UninitializedReadCollector.$$$reportNull$$$0(23);
        }
        if (this.expressionAssignsVariable(condition = whileStatement.getCondition(), variable2, stamp, checkedMethods)) {
            return true;
        }
        return BoolUtils.isTrue(condition) && this.statementAssignsVariable(body = whileStatement.getBody(), variable2, stamp, checkedMethods);
    }

    private boolean forStatementAssignsVariable(@NotNull PsiForStatement forStatement, @NotNull PsiVariable variable2, int stamp, @NotNull Set<MethodSignature> checkedMethods) {
        PsiStatement initialization;
        if (forStatement == null) {
            UninitializedReadCollector.$$$reportNull$$$0(24);
        }
        if (variable2 == null) {
            UninitializedReadCollector.$$$reportNull$$$0(25);
        }
        if (checkedMethods == null) {
            UninitializedReadCollector.$$$reportNull$$$0(26);
        }
        if (this.statementAssignsVariable(initialization = forStatement.getInitialization(), variable2, stamp, checkedMethods)) {
            return true;
        }
        PsiExpression condition = forStatement.getCondition();
        if (this.expressionAssignsVariable(condition, variable2, stamp, checkedMethods)) {
            return true;
        }
        if (BoolUtils.isTrue(condition)) {
            PsiStatement body = forStatement.getBody();
            if (this.statementAssignsVariable(body, variable2, stamp, checkedMethods)) {
                return true;
            }
            PsiStatement update = forStatement.getUpdate();
            if (this.statementAssignsVariable(update, variable2, stamp, checkedMethods)) {
                return true;
            }
        }
        return false;
    }

    private boolean foreachStatementAssignsVariable(PsiForeachStatement forStatement, PsiVariable variable2) {
        return false;
    }

    private boolean expressionAssignsVariable(@Nullable PsiExpression expression2, @NotNull PsiVariable variable2, int stamp, @NotNull Set<MethodSignature> checkedMethods) {
        if (variable2 == null) {
            UninitializedReadCollector.$$$reportNull$$$0(27);
        }
        if (checkedMethods == null) {
            UninitializedReadCollector.$$$reportNull$$$0(28);
        }
        if (this.counter != stamp) {
            return true;
        }
        if (expression2 == null) {
            return false;
        }
        if (expression2 instanceof PsiThisExpression || expression2 instanceof PsiLiteralExpression || expression2 instanceof PsiSuperExpression || expression2 instanceof PsiClassObjectAccessExpression) {
            return false;
        }
        if (expression2 instanceof PsiReferenceExpression) {
            PsiReferenceExpression referenceExpression = (PsiReferenceExpression)expression2;
            return this.referenceExpressionAssignsVariable(referenceExpression, variable2, stamp, checkedMethods);
        }
        if (expression2 instanceof PsiMethodCallExpression) {
            PsiMethodCallExpression callExpression = (PsiMethodCallExpression)expression2;
            return this.methodCallAssignsVariable(callExpression, variable2, stamp, checkedMethods);
        }
        if (expression2 instanceof PsiNewExpression) {
            PsiNewExpression newExpression = (PsiNewExpression)expression2;
            return this.newExpressionAssignsVariable(newExpression, variable2, stamp, checkedMethods);
        }
        if (expression2 instanceof PsiArrayInitializerExpression) {
            PsiExpression[] initializers;
            PsiArrayInitializerExpression array = (PsiArrayInitializerExpression)expression2;
            for (PsiExpression initializer2 : initializers = array.getInitializers()) {
                if (!this.expressionAssignsVariable(initializer2, variable2, stamp, checkedMethods)) continue;
                return true;
            }
            return false;
        }
        if (expression2 instanceof PsiTypeCastExpression) {
            PsiTypeCastExpression typeCast = (PsiTypeCastExpression)expression2;
            PsiExpression operand = typeCast.getOperand();
            return this.expressionAssignsVariable(operand, variable2, stamp, checkedMethods);
        }
        if (expression2 instanceof PsiArrayAccessExpression) {
            PsiArrayAccessExpression accessExpression = (PsiArrayAccessExpression)expression2;
            PsiExpression arrayExpression = accessExpression.getArrayExpression();
            PsiExpression indexExpression = accessExpression.getIndexExpression();
            return this.expressionAssignsVariable(arrayExpression, variable2, stamp, checkedMethods) || this.expressionAssignsVariable(indexExpression, variable2, stamp, checkedMethods);
        }
        if (expression2 instanceof PsiUnaryExpression) {
            PsiUnaryExpression unaryExpression = (PsiUnaryExpression)expression2;
            PsiExpression operand = unaryExpression.getOperand();
            return this.expressionAssignsVariable(operand, variable2, stamp, checkedMethods);
        }
        if (expression2 instanceof PsiPolyadicExpression) {
            PsiExpression[] operands;
            PsiPolyadicExpression polyadicExpression = (PsiPolyadicExpression)expression2;
            for (PsiExpression operand : operands = polyadicExpression.getOperands()) {
                if (!this.expressionAssignsVariable(operand, variable2, stamp, checkedMethods)) continue;
                return true;
            }
            return false;
        }
        if (expression2 instanceof PsiConditionalExpression) {
            PsiConditionalExpression conditional = (PsiConditionalExpression)expression2;
            PsiExpression condition = conditional.getCondition();
            if (this.expressionAssignsVariable(condition, variable2, stamp, checkedMethods)) {
                return true;
            }
            PsiExpression thenExpression = conditional.getThenExpression();
            PsiExpression elseExpression = conditional.getElseExpression();
            return this.expressionAssignsVariable(thenExpression, variable2, stamp, checkedMethods) && this.expressionAssignsVariable(elseExpression, variable2, stamp, checkedMethods);
        }
        if (expression2 instanceof PsiAssignmentExpression) {
            PsiAssignmentExpression assignment = (PsiAssignmentExpression)expression2;
            return this.assignmentExpressionAssignsVariable(assignment, variable2, stamp, checkedMethods);
        }
        if (expression2 instanceof PsiParenthesizedExpression) {
            PsiParenthesizedExpression parenthesizedExpression = (PsiParenthesizedExpression)expression2;
            PsiExpression innerExpression = parenthesizedExpression.getExpression();
            return this.expressionAssignsVariable(innerExpression, variable2, stamp, checkedMethods);
        }
        if (expression2 instanceof PsiInstanceOfExpression) {
            PsiInstanceOfExpression instanceOfExpression = (PsiInstanceOfExpression)expression2;
            PsiExpression operand = instanceOfExpression.getOperand();
            return this.expressionAssignsVariable(operand, variable2, stamp, checkedMethods);
        }
        return false;
    }

    private boolean assignmentExpressionAssignsVariable(@NotNull PsiAssignmentExpression assignment, @NotNull PsiVariable variable2, int stamp, @NotNull Set<MethodSignature> checkedMethods) {
        PsiElement element;
        PsiExpression lhs;
        if (assignment == null) {
            UninitializedReadCollector.$$$reportNull$$$0(29);
        }
        if (variable2 == null) {
            UninitializedReadCollector.$$$reportNull$$$0(30);
        }
        if (checkedMethods == null) {
            UninitializedReadCollector.$$$reportNull$$$0(31);
        }
        if (this.expressionAssignsVariable(lhs = ParenthesesUtils.stripParentheses(assignment.getLExpression()), variable2, stamp, checkedMethods)) {
            return true;
        }
        PsiExpression rhs = assignment.getRExpression();
        if (this.expressionAssignsVariable(rhs, variable2, stamp, checkedMethods)) {
            return true;
        }
        return lhs instanceof PsiReferenceExpression && (element = ((PsiReference)((Object)lhs)).resolve()) != null && element.equals(variable2);
    }

    private boolean referenceExpressionAssignsVariable(@NotNull PsiReferenceExpression referenceExpression, @NotNull PsiVariable variable2, int stamp, @NotNull Set<MethodSignature> checkedMethods) {
        PsiExpression qualifierExpression;
        if (referenceExpression == null) {
            UninitializedReadCollector.$$$reportNull$$$0(32);
        }
        if (variable2 == null) {
            UninitializedReadCollector.$$$reportNull$$$0(33);
        }
        if (checkedMethods == null) {
            UninitializedReadCollector.$$$reportNull$$$0(34);
        }
        if (this.expressionAssignsVariable(qualifierExpression = referenceExpression.getQualifierExpression(), variable2, stamp, checkedMethods)) {
            return true;
        }
        if (variable2.equals(referenceExpression.resolve())) {
            PsiElement parent2 = ParenthesesUtils.getParentSkipParentheses(referenceExpression);
            if (parent2 instanceof PsiAssignmentExpression) {
                PsiAssignmentExpression assignmentExpression = (PsiAssignmentExpression)parent2;
                PsiExpression rhs = assignmentExpression.getRExpression();
                if (rhs != null && rhs.equals(referenceExpression)) {
                    this.checkReferenceExpression(referenceExpression, variable2, qualifierExpression);
                }
            } else if (!(parent2 instanceof PsiExpression) || !ComparisonUtils.isNullComparison((PsiExpression)parent2)) {
                this.checkReferenceExpression(referenceExpression, variable2, qualifierExpression);
            }
        }
        return false;
    }

    private void checkReferenceExpression(PsiReferenceExpression referenceExpression, PsiVariable variable2, PsiExpression qualifierExpression) {
        PsiReferenceExpression reference;
        PsiElement target;
        if (!referenceExpression.isQualified() || qualifierExpression instanceof PsiThisExpression) {
            this.uninitializedReads.add(referenceExpression);
            ++this.counter;
        } else if (variable2.hasModifierProperty("static") && qualifierExpression instanceof PsiReferenceExpression && (target = (reference = (PsiReferenceExpression)qualifierExpression).resolve()) instanceof PsiClass && target.equals(PsiTreeUtil.getParentOfType((PsiElement)variable2, PsiClass.class))) {
            this.uninitializedReads.add(referenceExpression);
            ++this.counter;
        }
    }

    private boolean newExpressionAssignsVariable(@NotNull PsiNewExpression newExpression, @NotNull PsiVariable variable2, int stamp, @NotNull Set<MethodSignature> checkedMethods) {
        PsiExpression[] arrayDimensions;
        PsiArrayInitializerExpression arrayInitializer;
        PsiExpressionList argumentList2;
        if (newExpression == null) {
            UninitializedReadCollector.$$$reportNull$$$0(35);
        }
        if (variable2 == null) {
            UninitializedReadCollector.$$$reportNull$$$0(36);
        }
        if (checkedMethods == null) {
            UninitializedReadCollector.$$$reportNull$$$0(37);
        }
        if ((argumentList2 = newExpression.getArgumentList()) != null) {
            PsiExpression[] args;
            for (PsiExpression arg : args = argumentList2.getExpressions()) {
                if (!this.expressionAssignsVariable(arg, variable2, stamp, checkedMethods)) continue;
                return true;
            }
        }
        if (this.expressionAssignsVariable(arrayInitializer = newExpression.getArrayInitializer(), variable2, stamp, checkedMethods)) {
            return true;
        }
        for (PsiExpression dim : arrayDimensions = newExpression.getArrayDimensions()) {
            if (!this.expressionAssignsVariable(dim, variable2, stamp, checkedMethods)) continue;
            return true;
        }
        return false;
    }

    private boolean methodCallAssignsVariable(@NotNull PsiMethodCallExpression callExpression, @NotNull PsiVariable variable2, int stamp, @NotNull Set<MethodSignature> checkedMethods) {
        PsiExpression[] arguments2;
        PsiReferenceExpression methodExpression;
        if (callExpression == null) {
            UninitializedReadCollector.$$$reportNull$$$0(38);
        }
        if (variable2 == null) {
            UninitializedReadCollector.$$$reportNull$$$0(39);
        }
        if (checkedMethods == null) {
            UninitializedReadCollector.$$$reportNull$$$0(40);
        }
        if (this.expressionAssignsVariable(methodExpression = callExpression.getMethodExpression(), variable2, stamp, checkedMethods)) {
            return true;
        }
        PsiExpressionList argumentList2 = callExpression.getArgumentList();
        for (PsiExpression argument : arguments2 = argumentList2.getExpressions()) {
            if (!this.expressionAssignsVariable(argument, variable2, stamp, checkedMethods)) continue;
            return true;
        }
        PsiMethod method = callExpression.resolveMethod();
        if (method == null) {
            return false;
        }
        MethodSignature methodSignature = method.getSignature(PsiSubstitutor.EMPTY);
        if (!checkedMethods.add(methodSignature)) {
            return false;
        }
        PsiClass containingClass = ClassUtils.getContainingClass(callExpression);
        PsiClass calledClass = method.getContainingClass();
        if (calledClass == null || !calledClass.equals(containingClass)) {
            return false;
        }
        if (method.hasModifierProperty("static") || method.isConstructor() || method.hasModifierProperty("private") || method.hasModifierProperty("final") || calledClass.hasModifierProperty("final")) {
            PsiCodeBlock body = method.getBody();
            return this.blockAssignsVariable(body, variable2, stamp, checkedMethods);
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/siyeh/ig/psiutils/UninitializedReadCollector";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 7: 
            case 10: 
            case 13: 
            case 16: 
            case 19: 
            case 22: 
            case 25: 
            case 27: 
            case 30: 
            case 33: 
            case 36: 
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "variable";
                break;
            }
            case 3: 
            case 5: 
            case 8: 
            case 11: 
            case 14: 
            case 17: 
            case 20: 
            case 23: 
            case 26: 
            case 28: 
            case 31: 
            case 34: 
            case 37: 
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "checkedMethods";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "switchStatement";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "declarationStatement";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tryStatement";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ifStatement";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "doWhileStatement";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "whileStatement";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "forStatement";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "assignment";
                break;
            }
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "referenceExpression";
                break;
            }
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newExpression";
                break;
            }
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callExpression";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getUninitializedReads";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: {
                objectArray = objectArray2;
                objectArray2[1] = "com/siyeh/ig/psiutils/UninitializedReadCollector";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "blockAssignsVariable";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "statementAssignsVariable";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "switchStatementAssignsVariable";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "declarationStatementAssignsVariable";
                break;
            }
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "tryStatementAssignsVariable";
                break;
            }
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "ifStatementAssignsVariable";
                break;
            }
            case 18: 
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "doWhileAssignsVariable";
                break;
            }
            case 21: 
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "whileStatementAssignsVariable";
                break;
            }
            case 24: 
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "forStatementAssignsVariable";
                break;
            }
            case 27: 
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "expressionAssignsVariable";
                break;
            }
            case 29: 
            case 30: 
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "assignmentExpressionAssignsVariable";
                break;
            }
            case 32: 
            case 33: 
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "referenceExpressionAssignsVariable";
                break;
            }
            case 35: 
            case 36: 
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "newExpressionAssignsVariable";
                break;
            }
            case 38: 
            case 39: 
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "methodCallAssignsVariable";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

