/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.psiutils;

import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiArrayInitializerExpression;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiReturnStatement;
import com.intellij.psi.PsiUnaryExpression;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.tree.IElementType;
import com.siyeh.ig.psiutils.VariableUsedVisitor;
import org.jetbrains.annotations.NotNull;

class VariableValueUsedVisitor
extends JavaRecursiveElementWalkingVisitor {
    @NotNull
    private final PsiVariable variable;
    private boolean read;
    private boolean written;

    VariableValueUsedVisitor(@NotNull PsiVariable variable2) {
        if (variable2 == null) {
            VariableValueUsedVisitor.$$$reportNull$$$0(0);
        }
        this.variable = variable2;
    }

    @Override
    public void visitElement(@NotNull PsiElement element) {
        if (element == null) {
            VariableValueUsedVisitor.$$$reportNull$$$0(1);
        }
        if (this.read || this.written) {
            return;
        }
        super.visitElement(element);
    }

    @Override
    public void visitAssignmentExpression(@NotNull PsiAssignmentExpression assignment) {
        PsiReferenceExpression referenceExpression;
        PsiElement target;
        if (assignment == null) {
            VariableValueUsedVisitor.$$$reportNull$$$0(2);
        }
        if (this.read || this.written) {
            return;
        }
        super.visitAssignmentExpression(assignment);
        PsiExpression lhs = assignment.getLExpression();
        if (lhs instanceof PsiReferenceExpression && this.variable.equals(target = (referenceExpression = (PsiReferenceExpression)lhs).resolve())) {
            this.written = true;
            return;
        }
        PsiExpression rhs = assignment.getRExpression();
        if (rhs == null) {
            return;
        }
        this.read = VariableUsedVisitor.isVariableUsedIn(this.variable, rhs);
    }

    @Override
    public void visitUnaryExpression(@NotNull PsiUnaryExpression unaryExpression) {
        if (unaryExpression == null) {
            VariableValueUsedVisitor.$$$reportNull$$$0(3);
        }
        if (this.read || this.written) {
            return;
        }
        super.visitUnaryExpression(unaryExpression);
        IElementType tokenType = unaryExpression.getOperationTokenType();
        if (!tokenType.equals(JavaTokenType.PLUSPLUS) && !tokenType.equals(JavaTokenType.MINUSMINUS)) {
            return;
        }
        PsiExpression operand = unaryExpression.getOperand();
        if (!(operand instanceof PsiReferenceExpression)) {
            return;
        }
        PsiReferenceExpression referenceExpression = (PsiReferenceExpression)operand;
        PsiElement target = referenceExpression.resolve();
        if (!this.variable.equals(target)) {
            return;
        }
        this.written = true;
    }

    @Override
    public void visitVariable(@NotNull PsiVariable variable2) {
        if (variable2 == null) {
            VariableValueUsedVisitor.$$$reportNull$$$0(4);
        }
        if (this.read || this.written) {
            return;
        }
        super.visitVariable(variable2);
        PsiExpression initalizer = variable2.getInitializer();
        if (initalizer == null) {
            return;
        }
        this.read = VariableUsedVisitor.isVariableUsedIn(variable2, initalizer);
    }

    @Override
    public void visitMethodCallExpression(@NotNull PsiMethodCallExpression call2) {
        PsiExpression[] arguments2;
        if (call2 == null) {
            VariableValueUsedVisitor.$$$reportNull$$$0(5);
        }
        if (this.read || this.written) {
            return;
        }
        super.visitMethodCallExpression(call2);
        PsiReferenceExpression methodExpression = call2.getMethodExpression();
        PsiExpression qualifier = methodExpression.getQualifierExpression();
        if (qualifier != null && VariableUsedVisitor.isVariableUsedIn(this.variable, qualifier)) {
            this.read = true;
            return;
        }
        PsiExpressionList argumentList2 = call2.getArgumentList();
        for (PsiExpression argument : arguments2 = argumentList2.getExpressions()) {
            if (!VariableUsedVisitor.isVariableUsedIn(this.variable, argument)) continue;
            this.read = true;
            return;
        }
    }

    @Override
    public void visitNewExpression(@NotNull PsiNewExpression newExpression) {
        PsiExpression[] arguments2;
        if (newExpression == null) {
            VariableValueUsedVisitor.$$$reportNull$$$0(6);
        }
        if (this.read || this.written) {
            return;
        }
        super.visitNewExpression(newExpression);
        PsiExpressionList argumentList2 = newExpression.getArgumentList();
        if (argumentList2 == null) {
            return;
        }
        for (PsiExpression argument : arguments2 = argumentList2.getExpressions()) {
            if (!VariableUsedVisitor.isVariableUsedIn(this.variable, argument)) continue;
            this.read = true;
            return;
        }
    }

    @Override
    public void visitArrayInitializerExpression(PsiArrayInitializerExpression expression2) {
        PsiExpression[] arguments2;
        if (this.read || this.written) {
            return;
        }
        super.visitArrayInitializerExpression(expression2);
        for (PsiExpression argument : arguments2 = expression2.getInitializers()) {
            if (!VariableUsedVisitor.isVariableUsedIn(this.variable, argument)) continue;
            this.read = true;
            return;
        }
    }

    @Override
    public void visitReturnStatement(@NotNull PsiReturnStatement returnStatement) {
        if (returnStatement == null) {
            VariableValueUsedVisitor.$$$reportNull$$$0(7);
        }
        if (this.read || this.written) {
            return;
        }
        super.visitReturnStatement(returnStatement);
        PsiExpression returnValue = returnStatement.getReturnValue();
        if (returnValue == null) {
            return;
        }
        this.read = VariableUsedVisitor.isVariableUsedIn(this.variable, returnValue);
    }

    @Override
    public void visitClass(PsiClass aClass2) {
        if (this.read || this.written) {
            return;
        }
        super.visitClass(aClass2);
        this.read = VariableUsedVisitor.isVariableUsedIn(this.variable, aClass2);
    }

    boolean isVariableValueUsed() {
        return this.read;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "variable";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "assignment";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "unaryExpression";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "call";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newExpression";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "returnStatement";
                break;
            }
        }
        objectArray2[1] = "com/siyeh/ig/psiutils/VariableValueUsedVisitor";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "visitElement";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "visitAssignmentExpression";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "visitUnaryExpression";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "visitVariable";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "visitMethodCallExpression";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "visitNewExpression";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "visitReturnStatement";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

