/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.resources;

import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiMethodReferenceExpression;
import com.intellij.psi.PsiMethodReferenceUtil;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiResourceVariable;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.psiutils.MethodMatcher;
import com.siyeh.ig.psiutils.TypeUtils;
import com.siyeh.ig.resources.ResourceInspection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.jdom.Element;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AutoCloseableResourceInspectionBase
extends ResourceInspection {
    private static final List<String> DEFAULT_IGNORED_TYPES = Arrays.asList("java.util.stream.Stream", "java.util.stream.IntStream", "java.util.stream.LongStream", "java.util.stream.DoubleStream");
    public boolean ignoreFromMethodCall = false;
    final List<String> ignoredTypes = new ArrayList<String>(DEFAULT_IGNORED_TYPES);
    protected final MethodMatcher myMethodMatcher = new MethodMatcher().add("java.util.Formatter", "format").add("java.io.Writer", "append").add("com.google.common.base.Preconditions", "checkNotNull").add("org.hibernate.Session", "close").add("java.io.PrintWriter", "printf").finishDefault();

    @Override
    @Nls
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("auto.closeable.resource.display.name", new Object[0]);
        if (string == null) {
            AutoCloseableResourceInspectionBase.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    @NotNull
    public String getID() {
        if ("resource" == null) {
            AutoCloseableResourceInspectionBase.$$$reportNull$$$0(1);
        }
        return "resource";
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos2) {
        PsiType type2 = (PsiType)infos2[0];
        String text2 = type2.getPresentableText();
        String string = InspectionGadgetsBundle.message("auto.closeable.resource.problem.descriptor", text2);
        if (string == null) {
            AutoCloseableResourceInspectionBase.$$$reportNull$$$0(2);
        }
        return string;
    }

    @Override
    @Nullable
    protected InspectionGadgetsFix buildFix(Object ... infos2) {
        boolean buildQuickfix = (Boolean)infos2[1];
        if (!buildQuickfix) {
            return null;
        }
        return new AutoCloseableResourceFix();
    }

    @Override
    public void readSettings(@NotNull Element node) throws InvalidDataException {
        if (node == null) {
            AutoCloseableResourceInspectionBase.$$$reportNull$$$0(3);
        }
        super.readSettings(node);
        for (Element option : node.getChildren("option")) {
            String ignoredTypesString;
            String name = option.getAttributeValue("name");
            if (!"ignoredTypes".equals(name) || (ignoredTypesString = option.getAttributeValue("value")) == null) continue;
            this.ignoredTypes.clear();
            AutoCloseableResourceInspectionBase.parseString(ignoredTypesString, this.ignoredTypes);
        }
        this.myMethodMatcher.readSettings(node);
    }

    @Override
    public void writeSettings(@NotNull Element node) throws WriteExternalException {
        if (node == null) {
            AutoCloseableResourceInspectionBase.$$$reportNull$$$0(4);
        }
        this.writeBooleanOption(node, "ignoreFromMethodCall", false);
        this.writeBooleanOption(node, "anyMethodMayClose", true);
        if (!DEFAULT_IGNORED_TYPES.equals(this.ignoredTypes)) {
            String ignoredTypesString = AutoCloseableResourceInspectionBase.formatString(this.ignoredTypes);
            node.addContent(new Element("option").setAttribute("name", "ignoredTypes").setAttribute("value", ignoredTypesString));
        }
        this.myMethodMatcher.writeSettings(node);
    }

    @Override
    protected boolean isResourceCreation(PsiExpression expression2) {
        return TypeUtils.expressionHasTypeOrSubtype(expression2, "java.lang.AutoCloseable") && !TypeUtils.expressionHasTypeOrSubtype(expression2, this.ignoredTypes);
    }

    @Override
    public boolean shouldInspect(PsiFile file2) {
        return PsiUtil.isLanguageLevel7OrHigher(file2);
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new AutoCloseableResourceVisitor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 3: 
            case 4: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 3: 
            case 4: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/siyeh/ig/resources/AutoCloseableResourceInspectionBase";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getID";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "buildErrorString";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "com/siyeh/ig/resources/AutoCloseableResourceInspectionBase";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "readSettings";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "writeSettings";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 3: 
            case 4: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class AutoCloseableResourceVisitor
    extends BaseInspectionVisitor {
        private AutoCloseableResourceVisitor() {
        }

        @Override
        public void visitNewExpression(PsiNewExpression expression2) {
            super.visitNewExpression(expression2);
            if (!this.isNotSafelyClosedResource(expression2)) {
                return;
            }
            this.registerNewExpressionError(expression2, expression2.getType(), Boolean.FALSE);
        }

        @Override
        public void visitMethodCallExpression(PsiMethodCallExpression expression2) {
            super.visitMethodCallExpression(expression2);
            if (AutoCloseableResourceInspectionBase.this.ignoreFromMethodCall || AutoCloseableResourceInspectionBase.this.myMethodMatcher.matches(expression2) || !this.isNotSafelyClosedResource(expression2)) {
                return;
            }
            this.registerMethodCallError(expression2, expression2.getType(), Boolean.TRUE);
        }

        @Override
        public void visitMethodReferenceExpression(PsiMethodReferenceExpression expression2) {
            super.visitMethodReferenceExpression(expression2);
            if (!expression2.isConstructor()) {
                return;
            }
            PsiType type2 = PsiMethodReferenceUtil.getQualifierType(expression2);
            if (!InheritanceUtil.isInheritor(type2, "java.lang.AutoCloseable")) {
                return;
            }
            for (String ignoredType : AutoCloseableResourceInspectionBase.this.ignoredTypes) {
                if (!InheritanceUtil.isInheritor(type2, ignoredType)) continue;
                return;
            }
            this.registerError((PsiElement)expression2, type2, Boolean.FALSE);
        }

        private boolean isNotSafelyClosedResource(PsiExpression expression2) {
            if (!AutoCloseableResourceInspectionBase.this.isResourceCreation(expression2)) {
                return false;
            }
            PsiVariable variable2 = ResourceInspection.getVariable(expression2);
            return !(variable2 instanceof PsiResourceVariable) && !AutoCloseableResourceInspectionBase.this.isResourceEscapingFromMethod(variable2, expression2);
        }
    }

    private class AutoCloseableResourceFix
    extends InspectionGadgetsFix {
        private AutoCloseableResourceFix() {
        }

        @Override
        @Nls
        @NotNull
        public String getFamilyName() {
            String string = InspectionGadgetsBundle.message("auto.closeable.resource.quickfix", new Object[0]);
            if (string == null) {
                AutoCloseableResourceFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        @Override
        protected void doFix(Project project, ProblemDescriptor descriptor2) {
            PsiElement element = descriptor2.getPsiElement();
            PsiMethodCallExpression methodCallExpression = PsiTreeUtil.getParentOfType(element, PsiMethodCallExpression.class);
            if (methodCallExpression == null) {
                return;
            }
            AutoCloseableResourceInspectionBase.this.myMethodMatcher.add(methodCallExpression);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/resources/AutoCloseableResourceInspectionBase$AutoCloseableResourceFix", "getFamilyName"));
        }
    }
}

