/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.security;

import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.util.FileTypeUtils;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.psiutils.ControlFlowUtils;
import com.siyeh.ig.psiutils.MethodUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DesignForExtensionInspection
extends BaseInspection {
    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("design.for.extension.display.name", new Object[0]);
        if (string == null) {
            DesignForExtensionInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos2) {
        String string = InspectionGadgetsBundle.message("design.for.extension.problem.descriptor", new Object[0]);
        if (string == null) {
            DesignForExtensionInspection.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Override
    @Nullable
    protected InspectionGadgetsFix buildFix(Object ... infos2) {
        PsiMethod method = (PsiMethod)infos2[0];
        if (MethodUtils.isOverridden(method)) {
            return null;
        }
        return new MakeMethodFinalFix(method.getName());
    }

    @Override
    public boolean shouldInspect(PsiFile file2) {
        return !FileTypeUtils.isInServerPageFile(file2);
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new DesignForExtensionVisitor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/siyeh/ig/security/DesignForExtensionInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "buildErrorString";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    private static class DesignForExtensionVisitor
    extends BaseInspectionVisitor {
        private DesignForExtensionVisitor() {
        }

        @Override
        public void visitMethod(PsiMethod method) {
            super.visitMethod(method);
            if (method.isConstructor()) {
                return;
            }
            if (method.hasModifierProperty("private") || method.hasModifierProperty("final") || method.hasModifierProperty("abstract") || method.hasModifierProperty("static")) {
                return;
            }
            PsiClass containingClass = method.getContainingClass();
            if (containingClass == null) {
                return;
            }
            if (containingClass.isEnum() || containingClass.isInterface() || containingClass.isAnnotationType()) {
                return;
            }
            if (containingClass.hasModifierProperty("final")) {
                return;
            }
            if (containingClass instanceof PsiAnonymousClass) {
                return;
            }
            PsiCodeBlock body = method.getBody();
            if (ControlFlowUtils.isEmptyCodeBlock(body)) {
                return;
            }
            this.registerMethodError(method, method);
        }
    }

    private static class MakeMethodFinalFix
    extends InspectionGadgetsFix {
        private final String myMethodName;

        public MakeMethodFinalFix(String methodName) {
            this.myMethodName = methodName;
        }

        @Override
        @NotNull
        public String getName() {
            String string = InspectionGadgetsBundle.message("make.method.final.fix.name", this.myMethodName);
            if (string == null) {
                MakeMethodFinalFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        @Override
        @NotNull
        public String getFamilyName() {
            if ("Make method 'final'" == null) {
                MakeMethodFinalFix.$$$reportNull$$$0(1);
            }
            return "Make method 'final'";
        }

        @Override
        protected void doFix(Project project, ProblemDescriptor descriptor2) {
            PsiElement element = descriptor2.getPsiElement().getParent();
            if (!(element instanceof PsiMethod)) {
                return;
            }
            PsiMethod method = (PsiMethod)element;
            PsiModifierList modifierList = method.getModifierList();
            modifierList.setModifierProperty("final", true);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[2];
            objectArray2[0] = "com/siyeh/ig/security/DesignForExtensionInspection$MakeMethodFinalFix";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
            }
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
        }
    }
}

