/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.security;

import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ui.SingleCheckboxOptionsPanel;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiEnumConstant;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.psiutils.ControlFlowUtils;
import com.siyeh.ig.psiutils.SerializationUtils;
import java.util.Arrays;
import javax.swing.JComponent;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SerializableDeserializableClassInSecureContextInspection
extends BaseInspection {
    public boolean ignoreThrowable = false;

    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("serializable.class.in.secure.context.display.name", new Object[0]);
        if (string == null) {
            SerializableDeserializableClassInSecureContextInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos2) {
        Boolean serializable = (Boolean)infos2[0];
        Boolean deserializable = (Boolean)infos2[1];
        if (serializable.booleanValue()) {
            String string = deserializable != false ? InspectionGadgetsBundle.message("serializable.deserializable.class.in.secure.context.problem.descriptor", new Object[0]) : InspectionGadgetsBundle.message("serializable.class.in.secure.context.problem.descriptor", new Object[0]);
            if (string == null) {
                SerializableDeserializableClassInSecureContextInspection.$$$reportNull$$$0(1);
            }
            return string;
        }
        String string = InspectionGadgetsBundle.message("deserializable.class.in.secure.context.problem.descriptor", new Object[0]);
        if (string == null) {
            SerializableDeserializableClassInSecureContextInspection.$$$reportNull$$$0(2);
        }
        return string;
    }

    @Override
    @Nullable
    protected InspectionGadgetsFix buildFix(Object ... infos2) {
        boolean addWriteObjectMethod;
        Boolean serializable = (Boolean)infos2[0];
        Boolean deserializable = (Boolean)infos2[1];
        PsiClass aClass2 = (PsiClass)infos2[2];
        boolean addReadObjectMethod = deserializable != false && !SerializableDeserializableClassInSecureContextInspection.hasOwnReadObjectMethod(aClass2);
        boolean bl = addWriteObjectMethod = serializable != false && !SerializableDeserializableClassInSecureContextInspection.hasOwnWriteObjectMethod(aClass2);
        if (!addReadObjectMethod && !addWriteObjectMethod) {
            return null;
        }
        return new AddReadWriteObjectMethodsFix(addReadObjectMethod, addWriteObjectMethod);
    }

    private static boolean hasOwnReadObjectMethod(PsiClass aClass2) {
        return Arrays.stream(aClass2.findMethodsByName("readObject", false)).anyMatch(SerializationUtils::isReadObject);
    }

    private static boolean hasOwnWriteObjectMethod(PsiClass aClass2) {
        return Arrays.stream(aClass2.findMethodsByName("writeObject", false)).anyMatch(SerializationUtils::isWriteObject);
    }

    @Override
    @Nullable
    public JComponent createOptionsPanel() {
        return new SingleCheckboxOptionsPanel(InspectionGadgetsBundle.message("ignore.classes.extending.throwable.option", new Object[0]), this, "ignoreThrowable");
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new SerializableDeserializableClassInSecureContextVisitor();
    }

    @Override
    public String getAlternativeID() {
        return "serial";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/siyeh/ig/security/SerializableDeserializableClassInSecureContextInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "buildErrorString";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    private class SerializableDeserializableClassInSecureContextVisitor
    extends BaseInspectionVisitor {
        private SerializableDeserializableClassInSecureContextVisitor() {
        }

        @Override
        public void visitClass(@NotNull PsiClass aClass2) {
            boolean deserializable;
            if (aClass2 == null) {
                SerializableDeserializableClassInSecureContextVisitor.$$$reportNull$$$0(0);
            }
            if (aClass2.isInterface() || aClass2.isAnnotationType()) {
                return;
            }
            if (aClass2 instanceof PsiTypeParameter || !SerializationUtils.isSerializable(aClass2)) {
                return;
            }
            if (SerializableDeserializableClassInSecureContextInspection.this.ignoreThrowable && InheritanceUtil.isInheritor(aClass2, false, "java.lang.Throwable")) {
                return;
            }
            if (!this.hasSerializableState(aClass2)) {
                return;
            }
            boolean serializable = !this.hasWriteObjectMethodWhichAlwaysThrowsException(aClass2);
            boolean bl = deserializable = !this.hasReadObjectMethodWhichAlwaysThrowsException(aClass2);
            if (!serializable && !deserializable) {
                return;
            }
            this.registerClassError(aClass2, serializable, deserializable, aClass2);
        }

        private boolean hasSerializableState(PsiClass aClass2) {
            return Arrays.stream(aClass2.getFields()).filter(f -> !f.hasModifierProperty("static")).filter(f -> !f.hasModifierProperty("transient")).anyMatch(f -> !(f instanceof PsiEnumConstant));
        }

        private boolean hasReadObjectMethodWhichAlwaysThrowsException(PsiClass aClass2) {
            for (PsiMethod method : aClass2.findMethodsByName("readObject", true)) {
                if (!SerializationUtils.isReadObject(method)) continue;
                return ControlFlowUtils.methodAlwaysThrowsException((PsiMethod)method.getNavigationElement());
            }
            return false;
        }

        private boolean hasWriteObjectMethodWhichAlwaysThrowsException(PsiClass aClass2) {
            for (PsiMethod method : aClass2.findMethodsByName("writeObject", true)) {
                if (!SerializationUtils.isWriteObject(method)) continue;
                return ControlFlowUtils.methodAlwaysThrowsException((PsiMethod)method.getNavigationElement());
            }
            return false;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "com/siyeh/ig/security/SerializableDeserializableClassInSecureContextInspection$SerializableDeserializableClassInSecureContextVisitor", "visitClass"));
        }
    }

    private static class AddReadWriteObjectMethodsFix
    extends InspectionGadgetsFix {
        private final boolean myReadObject;
        private final boolean myWriteObject;

        AddReadWriteObjectMethodsFix(boolean readObject, boolean writeObject) {
            this.myReadObject = readObject;
            this.myWriteObject = writeObject;
        }

        @Override
        @Nls
        @NotNull
        public String getName() {
            if (this.myReadObject) {
                String string = this.myWriteObject ? this.getFamilyName() : "Add 'readObject()' method which always throws exception";
                if (string == null) {
                    AddReadWriteObjectMethodsFix.$$$reportNull$$$0(0);
                }
                return string;
            }
            if ("Add 'writeObject()' methods which always throws exception" == null) {
                AddReadWriteObjectMethodsFix.$$$reportNull$$$0(1);
            }
            return "Add 'writeObject()' methods which always throws exception";
        }

        @Override
        @Nls
        @NotNull
        public String getFamilyName() {
            if ("Add 'readObject()' and 'writeObject()' methods which always throw exception" == null) {
                AddReadWriteObjectMethodsFix.$$$reportNull$$$0(2);
            }
            return "Add 'readObject()' and 'writeObject()' methods which always throw exception";
        }

        @Override
        protected void doFix(Project project, ProblemDescriptor descriptor2) {
            PsiElement element = descriptor2.getPsiElement();
            PsiClass containingClass = PsiTreeUtil.getParentOfType(element, PsiClass.class);
            if (containingClass == null) {
                return;
            }
            String className2 = containingClass.getQualifiedName();
            PsiElementFactory factory2 = JavaPsiFacade.getElementFactory(project);
            if (this.myReadObject) {
                PsiMethod readObjectMethod = factory2.createMethodFromText("private void readObject(java.io.ObjectInputStream in) throws java.io.IOException, java.lang.ClassNotFoundException {  throw new java.io.NotSerializableException(\"" + className2 + "\");}", containingClass);
                containingClass.add(readObjectMethod);
            }
            if (this.myWriteObject) {
                PsiMethod writeObjectMethod = factory2.createMethodFromText("private void writeObject(java.io.ObjectOutputStream out) throws java.io.IOException {  throw new java.io.NotSerializableException(\"" + className2 + "\");}", containingClass);
                containingClass.add(writeObjectMethod);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[2];
            objectArray2[0] = "com/siyeh/ig/security/SerializableDeserializableClassInSecureContextInspection$AddReadWriteObjectMethodsFix";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
            }
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
        }
    }
}

