/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.style;

import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ui.SingleCheckboxOptionsPanel;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.util.PsiUtilCore;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.psiutils.ControlFlowUtils;
import com.siyeh.ig.psiutils.ExpressionUtils;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;

public class ImplicitCallToSuperInspection
extends BaseInspection {
    public boolean m_ignoreForObjectSubclasses = false;

    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("implicit.call.to.super.display.name", new Object[0]);
        if (string == null) {
            ImplicitCallToSuperInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos2) {
        String string = InspectionGadgetsBundle.message("implicit.call.to.super.problem.descriptor", new Object[0]);
        if (string == null) {
            ImplicitCallToSuperInspection.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Override
    public InspectionGadgetsFix buildFix(Object ... infos2) {
        return new AddExplicitSuperCall();
    }

    @Override
    public JComponent createOptionsPanel() {
        return new SingleCheckboxOptionsPanel(InspectionGadgetsBundle.message("implicit.call.to.super.ignore.option", new Object[0]), this, "m_ignoreForObjectSubclasses");
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new ImplicitCallToSuperVisitor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/siyeh/ig/style/ImplicitCallToSuperInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "buildErrorString";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    private class ImplicitCallToSuperVisitor
    extends BaseInspectionVisitor {
        private ImplicitCallToSuperVisitor() {
        }

        @Override
        public void visitMethod(@NotNull PsiMethod method) {
            String superClassName;
            PsiClass superClass;
            if (method == null) {
                ImplicitCallToSuperVisitor.$$$reportNull$$$0(0);
            }
            super.visitMethod(method);
            if (!method.isConstructor() || method.getNameIdentifier() == null) {
                return;
            }
            PsiClass containingClass = method.getContainingClass();
            if (containingClass == null) {
                return;
            }
            if (containingClass.isEnum()) {
                return;
            }
            if (ImplicitCallToSuperInspection.this.m_ignoreForObjectSubclasses && (superClass = containingClass.getSuperClass()) != null && "java.lang.Object".equals(superClassName = superClass.getQualifiedName())) {
                return;
            }
            PsiStatement firstStatement = ControlFlowUtils.getFirstStatementInBlock(method.getBody());
            if (firstStatement == null) {
                this.registerMethodError(method, new Object[0]);
                return;
            }
            if (this.isConstructorCall(firstStatement) || PsiUtilCore.hasErrorElementChild(firstStatement)) {
                return;
            }
            this.registerMethodError(method, new Object[0]);
        }

        private boolean isConstructorCall(PsiStatement statement2) {
            if (!(statement2 instanceof PsiExpressionStatement)) {
                return false;
            }
            PsiExpressionStatement expressionStatement = (PsiExpressionStatement)statement2;
            PsiExpression expression2 = expressionStatement.getExpression();
            return ExpressionUtils.isConstructorInvocation(expression2);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "com/siyeh/ig/style/ImplicitCallToSuperInspection$ImplicitCallToSuperVisitor", "visitMethod"));
        }
    }

    private static class AddExplicitSuperCall
    extends InspectionGadgetsFix {
        private AddExplicitSuperCall() {
        }

        @Override
        @NotNull
        public String getFamilyName() {
            String string = InspectionGadgetsBundle.message("implicit.call.to.super.make.explicit.quickfix", new Object[0]);
            if (string == null) {
                AddExplicitSuperCall.$$$reportNull$$$0(0);
            }
            return string;
        }

        @Override
        public void doFix(Project project, ProblemDescriptor descriptor2) {
            PsiElement methodName = descriptor2.getPsiElement();
            PsiElement parent2 = methodName.getParent();
            if (!(parent2 instanceof PsiMethod)) {
                return;
            }
            PsiMethod method = (PsiMethod)parent2;
            PsiCodeBlock body = method.getBody();
            PsiElementFactory factory2 = JavaPsiFacade.getElementFactory(project);
            PsiStatement newStatement = factory2.createStatementFromText("super();", null);
            CodeStyleManager styleManager = CodeStyleManager.getInstance(project);
            if (body == null) {
                return;
            }
            PsiJavaToken brace = body.getLBrace();
            body.addAfter(newStatement, brace);
            styleManager.reformat(body);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/style/ImplicitCallToSuperInspection$AddExplicitSuperCall", "getFamilyName"));
        }
    }
}

