/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.style;

import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.psi.PsiCallExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.util.PropertyUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.psiutils.ExpressionUtils;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;

public class NestedMethodCallInspectionBase
extends BaseInspection {
    public boolean m_ignoreFieldInitializations = true;
    protected boolean ignoreStaticMethods = false;
    protected boolean ignoreGetterCalls = false;

    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("nested.method.call.display.name", new Object[0]);
        if (string == null) {
            NestedMethodCallInspectionBase.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos2) {
        String string = InspectionGadgetsBundle.message("nested.method.call.problem.descriptor", new Object[0]);
        if (string == null) {
            NestedMethodCallInspectionBase.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new NestedMethodCallVisitor();
    }

    @Override
    public void writeSettings(@NotNull Element node) throws WriteExternalException {
        if (node == null) {
            NestedMethodCallInspectionBase.$$$reportNull$$$0(2);
        }
        super.writeSettings(node);
        if (this.ignoreStaticMethods) {
            node.addContent(new Element("option").setAttribute("name", "ignoreStaticMethods").setAttribute("value", String.valueOf(this.ignoreStaticMethods)));
        }
        if (this.ignoreGetterCalls) {
            node.addContent(new Element("option").setAttribute("name", "ignoreGetterCalls").setAttribute("value", String.valueOf(this.ignoreGetterCalls)));
        }
    }

    @Override
    public void readSettings(@NotNull Element node) throws InvalidDataException {
        if (node == null) {
            NestedMethodCallInspectionBase.$$$reportNull$$$0(3);
        }
        super.readSettings(node);
        for (Element option : node.getChildren("option")) {
            if ("ignoreGetterCalls".equals(option.getAttributeValue("name"))) {
                this.ignoreGetterCalls = Boolean.parseBoolean(option.getAttributeValue("value"));
                continue;
            }
            if (!"ignoreStaticMethods".equals(option.getAttributeValue("name"))) continue;
            this.ignoreStaticMethods = Boolean.parseBoolean(option.getAttributeValue("value"));
        }
    }

    @Override
    protected boolean buildQuickFixesOnlyForOnTheFlyErrors() {
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: 
            case 3: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: 
            case 3: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/siyeh/ig/style/NestedMethodCallInspectionBase";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "buildErrorString";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "com/siyeh/ig/style/NestedMethodCallInspectionBase";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "writeSettings";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "readSettings";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: 
            case 3: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class NestedMethodCallVisitor
    extends BaseInspectionVisitor {
        private NestedMethodCallVisitor() {
        }

        @Override
        public void visitMethodCallExpression(@NotNull PsiMethodCallExpression expression2) {
            PsiField field;
            PsiExpression outerExpression;
            if (expression2 == null) {
                NestedMethodCallVisitor.$$$reportNull$$$0(0);
            }
            super.visitMethodCallExpression(expression2);
            for (outerExpression = expression2; outerExpression != null && outerExpression.getParent() instanceof PsiExpression; outerExpression = (PsiExpression)outerExpression.getParent()) {
            }
            if (outerExpression == null) {
                return;
            }
            PsiElement parent2 = outerExpression.getParent();
            if (!(parent2 instanceof PsiExpressionList)) {
                return;
            }
            PsiElement grandParent = parent2.getParent();
            if (!(grandParent instanceof PsiCallExpression)) {
                return;
            }
            if (ExpressionUtils.isConstructorInvocation(grandParent)) {
                return;
            }
            if (NestedMethodCallInspectionBase.this.m_ignoreFieldInitializations && (field = PsiTreeUtil.getParentOfType((PsiElement)expression2, PsiField.class)) != null) {
                return;
            }
            PsiMethod method = expression2.resolveMethod();
            if (method == null) {
                return;
            }
            if (NestedMethodCallInspectionBase.this.ignoreStaticMethods || NestedMethodCallInspectionBase.this.ignoreGetterCalls) {
                if (NestedMethodCallInspectionBase.this.ignoreStaticMethods && method.hasModifierProperty("static")) {
                    return;
                }
                if (NestedMethodCallInspectionBase.this.ignoreGetterCalls && PropertyUtil.isSimpleGetter(method)) {
                    return;
                }
            }
            this.registerMethodCallError(expression2, new Object[0]);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/siyeh/ig/style/NestedMethodCallInspectionBase$NestedMethodCallVisitor", "visitMethodCallExpression"));
        }
    }
}

